/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Permission
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="group_id")
    public Long groupId;
    @JsonProperty(value="group_name")
    public String groupName;
    @JsonProperty(value="permission")
    public String permission;
    @JsonProperty(value="recursive")
    public Boolean recursive;

    public Permission() {
        this(null, null);
    }

    public Permission(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Permission(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Permission.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Permission.create(parameters, this.options);
    }

    public static ListIterator<Permission> list() throws RuntimeException {
        return Permission.list(null, null);
    }

    public static ListIterator<Permission> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Permission.list(parameters, null);
    }

    public static ListIterator<Permission> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("include_groups") && !(parameters.get("include_groups") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: include_groups must be of type Boolean parameters[\"include_groups\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type String parameters[\"group_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type String parameters[\"user_id\"]");
        }
        String url = String.format("%s%s/permissions", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Permission>> typeReference = new TypeReference<List<Permission>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Permission> all() throws RuntimeException {
        return Permission.all(null, null);
    }

    public static ListIterator<Permission> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Permission.list(parameters, options);
    }

    public static Permission create(HashMap<String, Object> parameters) throws RuntimeException {
        return Permission.create(parameters, null);
    }

    public static Permission create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("permission") && !(parameters.get("permission") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: permission must be of type String parameters[\"permission\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("username") && !(parameters.get("username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: username must be of type String parameters[\"username\"]");
        }
        String url = String.format("%s%s/permissions", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Permission> typeReference = new TypeReference<Permission>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Permission.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Permission.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/permissions/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Permission.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Permission.delete(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    @Generated
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="group_name")
    @Generated
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @JsonProperty(value="permission")
    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public Boolean getRecursive() {
        return this.recursive;
    }

    @JsonProperty(value="recursive")
    @Generated
    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }
}

