/*
 * Decompiled with CFR 0.152.
 */
package com.files.util;

import com.files.FilesConfig;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threadly.util.StackSuppressedRuntimeException;

public class BufferPool {
    private static final Logger log = LoggerFactory.getLogger(BufferPool.class);
    private static final boolean TRACK_BUFFER_CREATION_STACK = true;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int T_BUFFER_SIZE = FilesConfig.getInstance().getCachedBufferTinySize();
    public static final int S_BUFFER_SIZE = FilesConfig.getInstance().getCachedBufferSmallSize();
    public static final int M_BUFFER_SIZE = FilesConfig.getInstance().getCachedBufferMediumSize();
    public static final int L_BUFFER_SIZE = FilesConfig.getInstance().getCachedBufferLargeSize();
    protected static final int T_BUFFER_TARGET_COUNT;
    protected static final int S_BUFFER_TARGET_COUNT;
    protected static final int M_BUFFER_TARGET_COUNT;
    protected static final int MAX_ALLOCATION;
    protected static final Semaphore TOTAL_ALLOCATED;
    protected static final Queue<byte[]> T_BUFFERS;
    protected static final Queue<byte[]> S_BUFFERS;
    protected static final Queue<byte[]> M_BUFFERS;
    protected static final Queue<byte[]> L_BUFFERS;

    private BufferPool() {
    }

    public static int getAvailableAllocation() {
        return TOTAL_ALLOCATED.availablePermits();
    }

    public static int getTotalAllocated() {
        return MAX_ALLOCATION - TOTAL_ALLOCATED.availablePermits();
    }

    public static int getWaitingToAllocateThreadCount() {
        return TOTAL_ALLOCATED.getQueueLength();
    }

    public static int availableTinyBufferCount() {
        return T_BUFFERS.size();
    }

    public static int availableSmallBufferCount() {
        return S_BUFFERS.size();
    }

    public static int availableMediumBufferCount() {
        return M_BUFFERS.size();
    }

    public static int availableLargeBufferCount() {
        return L_BUFFERS.size();
    }

    public static Buffer needBuffer(int minSize) {
        try {
            if (minSize <= T_BUFFER_SIZE) {
                return BufferPool.needTinyBuffer(minSize);
            }
            if (minSize <= S_BUFFER_SIZE) {
                return BufferPool.needSmallBuffer(minSize);
            }
            if (minSize <= M_BUFFER_SIZE) {
                return BufferPool.needMediumBuffer(minSize);
            }
            if (minSize <= L_BUFFER_SIZE) {
                return BufferPool.needLargeBuffer(minSize);
            }
            throw new IllegalArgumentException("Buffer size too large: " + minSize);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted waiting for buffer", e);
        }
    }

    private static Buffer atomicPoll(Queue<byte[]> buffers) {
        byte[] bytes = buffers.poll();
        if (bytes == null) {
            return null;
        }
        return new Buffer(bytes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Buffer needTinyBuffer(int minSize) throws InterruptedException {
        Buffer result;
        while ((result = BufferPool.atomicPoll(T_BUFFERS)) == null) {
            result = BufferPool.tryMakeBuffer(minSize, T_BUFFER_SIZE);
            if (result != null) return result;
            Buffer larger = BufferPool.atomicPoll(S_BUFFERS);
            if (larger == null) {
                larger = BufferPool.atomicPoll(M_BUFFERS);
            }
            if (larger == null) {
                larger = BufferPool.atomicPoll(L_BUFFERS);
            }
            if (larger != null) {
                return BufferPool.swapBuffer(larger, T_BUFFER_SIZE);
            }
            BufferPool.noBufferBlock(T_BUFFERS);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Buffer needSmallBuffer(int minSize) throws InterruptedException {
        int attempt = 0;
        while (true) {
            ++attempt;
            Buffer result = BufferPool.atomicPoll(S_BUFFERS);
            if (result != null) return result;
            result = BufferPool.tryMakeBuffer(minSize, S_BUFFER_SIZE);
            if (result != null) return result;
            Buffer larger = BufferPool.atomicPoll(M_BUFFERS);
            if (larger == null) {
                larger = BufferPool.atomicPoll(L_BUFFERS);
            }
            if (larger != null) {
                return BufferPool.swapBuffer(larger, S_BUFFER_SIZE);
            }
            if (attempt % 2 == 1) {
                BufferPool.trimCache(T_BUFFER_TARGET_COUNT, T_BUFFERS);
            }
            BufferPool.noBufferBlock(S_BUFFERS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Buffer needMediumBuffer(int minSize) throws InterruptedException {
        int attempt = 0;
        while (true) {
            ++attempt;
            Buffer result = BufferPool.atomicPoll(M_BUFFERS);
            if (result != null) return result;
            result = BufferPool.tryMakeBuffer(minSize, M_BUFFER_SIZE);
            if (result != null) return result;
            Buffer larger = BufferPool.atomicPoll(L_BUFFERS);
            if (larger != null) {
                return BufferPool.swapBuffer(larger, M_BUFFER_SIZE);
            }
            if (attempt % 2 == 1) {
                if ((T_BUFFERS.size() - T_BUFFER_TARGET_COUNT) * T_BUFFER_SIZE <= (S_BUFFERS.size() - S_BUFFER_TARGET_COUNT) * S_BUFFER_SIZE) {
                    BufferPool.trimCache(S_BUFFER_TARGET_COUNT, S_BUFFERS);
                } else {
                    BufferPool.trimCache(T_BUFFER_TARGET_COUNT, T_BUFFERS);
                }
            }
            BufferPool.noBufferBlock(M_BUFFERS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Buffer needLargeBuffer(int minSize) throws InterruptedException {
        int attempt = 0;
        Buffer result;
        while ((result = BufferPool.atomicPoll(L_BUFFERS)) == null) {
            result = BufferPool.tryMakeBuffer(minSize, L_BUFFER_SIZE);
            if (result != null) return result;
            if (++attempt % 2 == 1) {
                int tinySavings = (T_BUFFERS.size() - T_BUFFER_TARGET_COUNT) * T_BUFFER_SIZE;
                int smallSavings = (S_BUFFERS.size() - S_BUFFER_TARGET_COUNT) * S_BUFFER_SIZE;
                int medSavings = (M_BUFFERS.size() - M_BUFFER_TARGET_COUNT) * M_BUFFER_SIZE;
                if (medSavings >= smallSavings && medSavings >= tinySavings) {
                    BufferPool.trimCache(M_BUFFER_TARGET_COUNT, M_BUFFERS);
                } else if (smallSavings >= tinySavings) {
                    BufferPool.trimCache(S_BUFFER_TARGET_COUNT, S_BUFFERS);
                } else {
                    BufferPool.trimCache(T_BUFFER_TARGET_COUNT, T_BUFFERS);
                }
            }
            BufferPool.noBufferBlock(L_BUFFERS);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void noBufferBlock(Collection<?> preferedQueue) throws InterruptedException {
        Collection<?> collection = preferedQueue;
        synchronized (collection) {
            if (preferedQueue.isEmpty()) {
                preferedQueue.wait(50L);
            }
        }
    }

    private static Buffer tryMakeBuffer(int minSize, int idealSize) {
        if (TOTAL_ALLOCATED.tryAcquire(idealSize)) {
            return new Buffer(idealSize);
        }
        if (TOTAL_ALLOCATED.tryAcquire(minSize)) {
            return new Buffer(minSize);
        }
        return null;
    }

    private static void trimCache(int targetSize, Queue<byte[]> buffers) {
        while (buffers.size() > targetSize) {
            byte[] b = buffers.poll();
            if (b == null) continue;
            BufferPool.releaseBytes(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheBytes(byte[] bytes) {
        Queue<byte[]> bufferCache = null;
        if (bytes.length == T_BUFFER_SIZE) {
            bufferCache = T_BUFFERS;
        } else if (bytes.length == S_BUFFER_SIZE) {
            bufferCache = S_BUFFERS;
        } else if (bytes.length == M_BUFFER_SIZE) {
            bufferCache = M_BUFFERS;
        } else if (bytes.length == L_BUFFER_SIZE) {
            bufferCache = L_BUFFERS;
        }
        if (bufferCache == null) {
            BufferPool.releaseBytes(bytes);
        } else {
            bufferCache.add(bytes);
            Queue<byte[]> queue = bufferCache;
            synchronized (queue) {
                bufferCache.notifyAll();
            }
        }
    }

    private static void releaseBytes(byte[] b) {
        TOTAL_ALLOCATED.release(b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Buffer swapBuffer(Buffer larger, int newSize) {
        int releaseAmount = larger.bytes.length - newSize;
        byte[] byArray = larger.bytes;
        synchronized (byArray) {
            if (releaseAmount <= 0) {
                throw new IllegalStateException("Buffer smaller than new allocation");
            }
            if (larger.closed) {
                throw new IllegalStateException("Buffer already released");
            }
            larger.closed = true;
        }
        TOTAL_ALLOCATED.release(releaseAmount);
        return new Buffer(newSize);
    }

    static {
        T_BUFFERS = new ConcurrentLinkedQueue<byte[]>();
        S_BUFFERS = new ConcurrentLinkedQueue<byte[]>();
        M_BUFFERS = new ConcurrentLinkedQueue<byte[]>();
        L_BUFFERS = new ConcurrentLinkedQueue<byte[]>();
        MAX_ALLOCATION = FilesConfig.getInstance().getCachedBufferMaxBytes();
        TOTAL_ALLOCATED = new Semaphore(MAX_ALLOCATION);
        T_BUFFER_TARGET_COUNT = (int)((double)MAX_ALLOCATION * 0.25 / (double)T_BUFFER_SIZE);
        S_BUFFER_TARGET_COUNT = (int)((double)MAX_ALLOCATION * 0.25 / (double)S_BUFFER_SIZE);
        M_BUFFER_TARGET_COUNT = (int)((double)MAX_ALLOCATION * 0.25 / (double)M_BUFFER_SIZE);
    }

    public static class Buffer
    implements AutoCloseable {
        public static final Buffer POISON_PILL = new Buffer(EMPTY_BYTE_ARRAY){
            {
                this.closed = true;
            }
        };
        private final StackTraceElement[] creationStack = Thread.currentThread().getStackTrace();
        private final byte[] bytes;
        private int offset;
        private int length;
        protected volatile boolean closed;

        public Buffer(int size) {
            this.bytes = new byte[size];
            this.offset = 0;
            this.length = size;
        }

        public Buffer(byte[] bytes) {
            this.bytes = bytes;
            this.offset = 0;
            this.length = bytes.length;
        }

        public byte[] getBuffer() {
            if (this.closed) {
                throw new IllegalStateException("Buffer closed");
            }
            return this.bytes;
        }

        public int getRemaining() {
            if (this.closed) {
                throw new IllegalStateException("Buffer closed");
            }
            return this.length - this.offset;
        }

        public void setLength(int length) {
            if (length > this.bytes.length) {
                throw new IllegalArgumentException("Length beyond byte size");
            }
            if (length < 0) {
                throw new IllegalArgumentException("Length can't be negative");
            }
            this.length = length;
        }

        public int getOffset() {
            if (this.closed) {
                throw new IllegalStateException("Buffer closed");
            }
            return this.offset;
        }

        public void incrementOffset(int count) {
            this.setOffset(this.offset + count);
        }

        public void setOffset(int offset) {
            if (offset > this.length) {
                throw new IllegalArgumentException("Offset beyond length");
            }
            if (offset < 0) {
                throw new IllegalArgumentException("Offset can't be negative");
            }
            this.offset = offset;
        }

        public void flip() {
            this.length = this.offset;
            this.offset = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeAsUnhealthy() {
            byte[] byArray = this.bytes;
            synchronized (this.bytes) {
                if (this.closed) {
                    throw new IllegalStateException("Buffer already released");
                }
                this.closed = true;
                BufferPool.releaseBytes(this.bytes);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.atomicClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void atomicClose() {
            byte[] byArray = this.bytes;
            synchronized (this.bytes) {
                if (!this.closed) {
                    this.closed = true;
                    BufferPool.cacheBytes(this.bytes);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private Throwable creationLogThrowable() {
            if (this.creationStack == null) {
                return null;
            }
            StackSuppressedRuntimeException ex = new StackSuppressedRuntimeException();
            ex.setStackTrace(this.creationStack);
            return ex;
        }

        protected void finalize() {
            if (!this.closed) {
                log.warn("Buffer not released!", this.creationLogThrowable());
                this.atomicClose();
            }
        }
    }
}

