/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ApiRequestLog
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="timestamp")
    public Date timestamp;
    @JsonProperty(value="api_key_id")
    public Long apiKeyId;
    @JsonProperty(value="api_key_prefix")
    public String apiKeyPrefix;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="user_is_from_parent_site")
    public Boolean userIsFromParentSite;
    @JsonProperty(value="interface")
    public String interfaceName;
    @JsonProperty(value="request_method")
    public String requestMethod;
    @JsonProperty(value="request_path")
    public String requestPath;
    @JsonProperty(value="request_ip")
    public String requestIp;
    @JsonProperty(value="request_host")
    public String requestHost;
    @JsonProperty(value="request_id")
    public String requestId;
    @JsonProperty(value="api_name")
    public String apiName;
    @JsonProperty(value="user_agent")
    public String userAgent;
    @JsonProperty(value="error_type")
    public String errorType;
    @JsonProperty(value="error_message")
    public String errorMessage;
    @JsonProperty(value="response_code")
    public Long responseCode;
    @JsonProperty(value="success")
    public Boolean success;
    @JsonProperty(value="duration_ms")
    public Long durationMs;

    public ApiRequestLog() {
        this(null, null);
    }

    public ApiRequestLog(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public ApiRequestLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<ApiRequestLog> list() throws RuntimeException {
        return ApiRequestLog.list(null, null);
    }

    public static ListIterator<ApiRequestLog> list(HashMap<String, Object> parameters) throws RuntimeException {
        return ApiRequestLog.list(parameters, null);
    }

    public static ListIterator<ApiRequestLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/api_request_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<ApiRequestLog>> typeReference = new TypeReference<List<ApiRequestLog>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<ApiRequestLog> all() throws RuntimeException {
        return ApiRequestLog.all(null, null);
    }

    public static ListIterator<ApiRequestLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ApiRequestLog.list(parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Long getApiKeyId() {
        return this.apiKeyId;
    }

    @Generated
    public String getApiKeyPrefix() {
        return this.apiKeyPrefix;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public Boolean getUserIsFromParentSite() {
        return this.userIsFromParentSite;
    }

    @Generated
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Generated
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @Generated
    public String getRequestPath() {
        return this.requestPath;
    }

    @Generated
    public String getRequestIp() {
        return this.requestIp;
    }

    @Generated
    public String getRequestHost() {
        return this.requestHost;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getApiName() {
        return this.apiName;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public String getErrorType() {
        return this.errorType;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Long getResponseCode() {
        return this.responseCode;
    }

    @Generated
    public Boolean getSuccess() {
        return this.success;
    }

    @Generated
    public Long getDurationMs() {
        return this.durationMs;
    }
}

