/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.models.File;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileUploadPart
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="send")
    public Map<String, String> send;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="ask_about_overwrites")
    public Boolean askAboutOverwrites;
    @JsonProperty(value="available_parts")
    public Long availableParts;
    @JsonProperty(value="expires")
    public String expires;
    @JsonProperty(value="headers")
    public Map<String, String> headers;
    @JsonProperty(value="http_method")
    public String httpMethod;
    @JsonProperty(value="next_partsize")
    public Long nextPartsize;
    @JsonProperty(value="parallel_parts")
    public Boolean parallelParts;
    @JsonProperty(value="retry_parts")
    public Boolean retryParts;
    @JsonProperty(value="parameters")
    public Map<String, String> parameters;
    @JsonProperty(value="part_number")
    public Long partNumber;
    @JsonProperty(value="partsize")
    public Long partsize;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="ref")
    public String ref;
    @JsonProperty(value="upload_uri")
    public String uploadUri;

    public File putInputStream(InputStream inputStream, Date date) throws IOException, InterruptedException {
        return this.putInputStream(inputStream, date, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File putInputStream(InputStream inputStream, Date date, int threadCount) throws IOException, InterruptedException {
        HttpMethods.RequestMethods requestMethod = this.httpMethod == "post" ? HttpMethods.RequestMethods.POST : HttpMethods.RequestMethods.PUT;
        boolean isParallel = this.parallelParts != false && threadCount > 1;
        ExecutorService executor = isParallel ? Executors.newFixedThreadPool(threadCount) : null;
        Semaphore semaphore = isParallel ? new Semaphore(threadCount * 2) : null;
        ArrayList<Future<Void>> concurrentUploads = new ArrayList<Future<Void>>();
        BufferedInputStream bufferedInputStream = null;
        FileUploadPart part = this;
        try {
            byte[] buffer;
            int n;
            bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = bufferedInputStream.read(buffer = new byte[part.partsize.intValue()])) != -1) {
                if (isParallel) {
                    semaphore.acquire();
                    FileUploadPart currentPart = part;
                    concurrentUploads.add(executor.submit(() -> {
                        try {
                            FilesClient.putBuffer(currentPart.uploadUri, requestMethod, currentPart.path, buffer, n);
                        }
                        finally {
                            semaphore.release();
                        }
                        return null;
                    }));
                } else {
                    FilesClient.putBuffer(part.uploadUri, requestMethod, part.path, buffer, n);
                }
                HashMap<String, Object> parameters = new HashMap<String, Object>(part.parameters);
                parameters.put("ref", part.ref);
                parameters.put("part", (String)((Object)Long.valueOf(part.partNumber + 1L)));
                part = File.create(part.path, parameters, part.options);
            }
            for (Future future : concurrentUploads) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new IOException(e.getCause());
                    return part.completeUpload();
                }
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    public File putBufferedInputStream(BufferedInputStream inputStream, long length, Date date) throws IOException {
        HttpMethods.RequestMethods requestMethod = this.httpMethod == "post" ? HttpMethods.RequestMethods.POST : HttpMethods.RequestMethods.PUT;
        FilesClient.putBufferedInputStream(this.uploadUri, requestMethod, this.path, inputStream, length);
        return this.completeUpload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File putLocalFile(String source) throws IOException {
        java.io.File file = new java.io.File(source);
        long fileLength = file.length();
        try (BufferedInputStream bufferedInputStream = null;){
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            File file2 = this.putBufferedInputStream(bufferedInputStream, fileLength, null);
            return file2;
        }
    }

    private File completeUpload() throws IOException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("action", "end");
        parameters.put("ref", this.ref);
        return File.completeUpload(this.path, parameters, this.options);
    }

    public FileUploadPart() {
        this(null, null);
    }

    public FileUploadPart(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public FileUploadPart(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Map<String, String> getSend() {
        return this.send;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public Boolean getAskAboutOverwrites() {
        return this.askAboutOverwrites;
    }

    @Generated
    public Long getAvailableParts() {
        return this.availableParts;
    }

    @Generated
    public String getExpires() {
        return this.expires;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public Long getNextPartsize() {
        return this.nextPartsize;
    }

    @Generated
    public Boolean getParallelParts() {
        return this.parallelParts;
    }

    @Generated
    public Boolean getRetryParts() {
        return this.retryParts;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public Long getPartNumber() {
        return this.partNumber;
    }

    @Generated
    public Long getPartsize() {
        return this.partsize;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getRef() {
        return this.ref;
    }

    @Generated
    public String getUploadUri() {
        return this.uploadUri;
    }
}

