/*
 * Decompiled with CFR 0.152.
 */
package com.files.net;

import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.net.FilesHttpInterceptor;
import devcsrj.okhttp3.logging.HttpLoggingInterceptor;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesHttpClient {
    private static FilesHttpClient instance;
    protected static final Logger log;
    protected OkHttpClient okHttpClient;

    protected FilesHttpClient() {
        FilesConfig filesConfig = FilesConfig.getInstance();
        ConnectionPool pool = FilesClient.httpPool;
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.cache(null);
            builder.connectionPool(pool);
            builder.hostnameVerifier((hostname, session) -> true);
            builder.retryOnConnectionFailure(false);
            builder.addInterceptor((Interceptor)new FilesHttpInterceptor());
            builder.connectTimeout(30L, TimeUnit.SECONDS);
            builder.readTimeout(60L, TimeUnit.SECONDS);
            if (FilesConfig.getInstance().getHttpLoggingEnabled() && log.isDebugEnabled()) {
                builder.addInterceptor((Interceptor)new HttpLoggingInterceptor());
            }
            if (filesConfig.getUpstreamInsecureAllowed()) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            }
            if (FilesConfig.getInstance().getUpstreamHttp2Enabled()) {
                builder.protocols(Arrays.asList(Protocol.HTTP_1_1, Protocol.HTTP_2));
            } else {
                builder.protocols(Arrays.asList(Protocol.HTTP_1_1));
            }
            this.okHttpClient = builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getHttpClient() {
        if (instance != null) return FilesHttpClient.instance.okHttpClient;
        Class<FilesHttpClient> clazz = FilesHttpClient.class;
        synchronized (FilesHttpClient.class) {
            if (instance != null) return FilesHttpClient.instance.okHttpClient;
            instance = new FilesHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return FilesHttpClient.instance.okHttpClient;
        }
    }

    static {
        log = LoggerFactory.getLogger(FilesHttpClient.class);
    }
}

