/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Session
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="language")
    public String language;
    @JsonProperty(value="read_only")
    public Boolean readOnly;
    @JsonProperty(value="sftp_insecure_ciphers")
    public Boolean sftpInsecureCiphers;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="password")
    public String password;
    @JsonProperty(value="otp")
    public String otp;
    @JsonProperty(value="partial_session_id")
    public String partialSessionId;

    public Session() {
        this(null, null);
    }

    public Session(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Session(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Session.create(parameters, this.options);
    }

    public static Session create(HashMap<String, Object> parameters) throws RuntimeException {
        return Session.create(parameters, null);
    }

    public static Session create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("username") && !(parameters.get("username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: username must be of type String parameters[\"username\"]");
        }
        if (parameters.containsKey("password") && !(parameters.get("password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password must be of type String parameters[\"password\"]");
        }
        if (parameters.containsKey("otp") && !(parameters.get("otp") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: otp must be of type String parameters[\"otp\"]");
        }
        if (parameters.containsKey("partial_session_id") && !(parameters.get("partial_session_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: partial_session_id must be of type String parameters[\"partial_session_id\"]");
        }
        String url = String.format("%s%s/sessions", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Session> typeReference = new TypeReference<Session>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void delete(HashMap<String, Object> parameters) throws RuntimeException {
        Session.delete(parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        options = options != null ? options : new HashMap<String, Object>();
        String url = String.format("%s%s/sessions", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Session.destroy(null, null);
    }

    public static void destroy(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Session.delete(parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @JsonProperty(value="read_only")
    @Generated
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public Boolean getSftpInsecureCiphers() {
        return this.sftpInsecureCiphers;
    }

    @JsonProperty(value="sftp_insecure_ciphers")
    @Generated
    public void setSftpInsecureCiphers(Boolean sftpInsecureCiphers) {
        this.sftpInsecureCiphers = sftpInsecureCiphers;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public String getOtp() {
        return this.otp;
    }

    @JsonProperty(value="otp")
    @Generated
    public void setOtp(String otp) {
        this.otp = otp;
    }

    @Generated
    public String getPartialSessionId() {
        return this.partialSessionId;
    }

    @JsonProperty(value="partial_session_id")
    @Generated
    public void setPartialSessionId(String partialSessionId) {
        this.partialSessionId = partialSessionId;
    }
}

