package com.files.models;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.net.HttpMethods.RequestMethods;
import com.files.util.FilesInputStream;
import com.files.util.ModelUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Getter;
import lombok.Setter;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ApiRequestLog implements ModelInterface {
  @Setter
  private HashMap<String, Object> options;
  private ObjectMapper objectMapper = JsonMapper
      .builder()
      .disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)
      .disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)
      .defaultDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))
      .build();


  public ApiRequestLog() {
    this(null, null);
  }

  public ApiRequestLog(HashMap<String, Object> parameters) {
    this(parameters, null);
  }

  public ApiRequestLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
    this.options = options;
    try {
      ObjectReader objectReader = objectMapper.readerForUpdating(this);
      objectReader.readValue(objectMapper.writeValueAsString(parameters));
    } catch (JsonProcessingException e) {
      // TODO: error generation on constructor
    }
  }


  /**
  * Start Time of Action
  */
  @Getter
  @JsonProperty("timestamp")
  public Date timestamp;

  /**
  * API Key ID, if applicable
  */
  @Getter
  @JsonProperty("api_key_id")
  public Long apiKeyId;

  /**
  * API Key Prefix, if applicable
  */
  @Getter
  @JsonProperty("api_key_prefix")
  public String apiKeyPrefix;

  /**
  * User ID
  */
  @Getter
  @JsonProperty("user_id")
  public Long userId;

  /**
  * Username
  */
  @Getter
  @JsonProperty("username")
  public String username;

  /**
  * true if this change was performed by a user on a parent site.
  */
  @Getter
  @JsonProperty("user_is_from_parent_site")
  public Boolean userIsFromParentSite;

  /**
  * API Interface
  */
  @Getter
  @JsonProperty("interface")
  public String interfaceName;

  /**
  * HTTP Method
  */
  @Getter
  @JsonProperty("request_method")
  public String requestMethod;

  /**
  * Request path
  */
  @Getter
  @JsonProperty("request_path")
  public String requestPath;

  /**
  * IP of requesting client
  */
  @Getter
  @JsonProperty("request_ip")
  public String requestIp;

  /**
  * Hostname the request was sent to
  */
  @Getter
  @JsonProperty("request_host")
  public String requestHost;

  /**
  * Unique Id of the Request
  */
  @Getter
  @JsonProperty("request_id")
  public String requestId;

  /**
  * Name of API Endpoint
  */
  @Getter
  @JsonProperty("api_name")
  public String apiName;

  /**
  * User-Agent
  */
  @Getter
  @JsonProperty("user_agent")
  public String userAgent;

  /**
  * Error type, if applicable
  */
  @Getter
  @JsonProperty("error_type")
  public String errorType;

  /**
  * Error message, if applicable
  */
  @Getter
  @JsonProperty("error_message")
  public String errorMessage;

  /**
  * HTTP Response Code
  */
  @Getter
  @JsonProperty("response_code")
  public Long responseCode;

  /**
  * `false` if HTTP Response Code is 4xx or 5xx
  */
  @Getter
  @JsonProperty("success")
  public Boolean success;

  /**
  * Duration (in milliseconds)
  */
  @Getter
  @JsonProperty("duration_ms")
  public Long durationMs;



  /**
  * Parameters:
  *   cursor - string - Used for pagination.  When a list request has more records available, cursors are provided in the response headers `X-Files-Cursor-Next` and `X-Files-Cursor-Prev`.  Send one of those cursor value here to resume an existing list from the next available record.  Note: many of our SDKs have iterator methods that will automatically handle cursor-based pagination.
  *   per_page - int64 - Number of records to show per page.  (Max: 10,000, 1,000 or less is recommended).
  *   filter - object - If set, return records where the specified field is equal to the supplied value. Valid fields are `start_date`, `end_date`, `api_key_id`, `interface`, `request_id`, `request_ip`, `request_method`, `success` or `user_id`. Valid field combinations are `[ start_date ]`, `[ end_date ]`, `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ start_date, end_date ]`, `[ start_date, api_key_id ]`, `[ start_date, interface ]`, `[ start_date, request_id ]`, `[ start_date, request_ip ]`, `[ start_date, request_method ]`, `[ start_date, success ]`, `[ start_date, user_id ]`, `[ end_date, api_key_id ]`, `[ end_date, interface ]`, `[ end_date, request_id ]`, `[ end_date, request_ip ]`, `[ end_date, request_method ]`, `[ end_date, success ]`, `[ end_date, user_id ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ success, user_id ]`, `[ start_date, end_date, api_key_id ]`, `[ start_date, end_date, interface ]`, `[ start_date, end_date, request_id ]`, `[ start_date, end_date, request_ip ]`, `[ start_date, end_date, request_method ]`, `[ start_date, end_date, success ]`, `[ start_date, end_date, user_id ]`, `[ start_date, api_key_id, interface ]`, `[ start_date, api_key_id, request_id ]`, `[ start_date, api_key_id, request_ip ]`, `[ start_date, api_key_id, request_method ]`, `[ start_date, api_key_id, success ]`, `[ start_date, api_key_id, user_id ]`, `[ start_date, interface, request_id ]`, `[ start_date, interface, request_ip ]`, `[ start_date, interface, request_method ]`, `[ start_date, interface, success ]`, `[ start_date, interface, user_id ]`, `[ start_date, request_id, request_ip ]`, `[ start_date, request_id, request_method ]`, `[ start_date, request_id, success ]`, `[ start_date, request_id, user_id ]`, `[ start_date, request_ip, request_method ]`, `[ start_date, request_ip, success ]`, `[ start_date, request_ip, user_id ]`, `[ start_date, request_method, success ]`, `[ start_date, request_method, user_id ]`, `[ start_date, success, user_id ]`, `[ end_date, api_key_id, interface ]`, `[ end_date, api_key_id, request_id ]`, `[ end_date, api_key_id, request_ip ]`, `[ end_date, api_key_id, request_method ]`, `[ end_date, api_key_id, success ]`, `[ end_date, api_key_id, user_id ]`, `[ end_date, interface, request_id ]`, `[ end_date, interface, request_ip ]`, `[ end_date, interface, request_method ]`, `[ end_date, interface, success ]`, `[ end_date, interface, user_id ]`, `[ end_date, request_id, request_ip ]`, `[ end_date, request_id, request_method ]`, `[ end_date, request_id, success ]`, `[ end_date, request_id, user_id ]`, `[ end_date, request_ip, request_method ]`, `[ end_date, request_ip, success ]`, `[ end_date, request_ip, user_id ]`, `[ end_date, request_method, success ]`, `[ end_date, request_method, user_id ]`, `[ end_date, success, user_id ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, success, user_id ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, success, user_id ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, success, user_id ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, success, user_id ]`, `[ request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface ]`, `[ start_date, end_date, api_key_id, request_id ]`, `[ start_date, end_date, api_key_id, request_ip ]`, `[ start_date, end_date, api_key_id, request_method ]`, `[ start_date, end_date, api_key_id, success ]`, `[ start_date, end_date, api_key_id, user_id ]`, `[ start_date, end_date, interface, request_id ]`, `[ start_date, end_date, interface, request_ip ]`, `[ start_date, end_date, interface, request_method ]`, `[ start_date, end_date, interface, success ]`, `[ start_date, end_date, interface, user_id ]`, `[ start_date, end_date, request_id, request_ip ]`, `[ start_date, end_date, request_id, request_method ]`, `[ start_date, end_date, request_id, success ]`, `[ start_date, end_date, request_id, user_id ]`, `[ start_date, end_date, request_ip, request_method ]`, `[ start_date, end_date, request_ip, success ]`, `[ start_date, end_date, request_ip, user_id ]`, `[ start_date, end_date, request_method, success ]`, `[ start_date, end_date, request_method, user_id ]`, `[ start_date, end_date, success, user_id ]`, `[ start_date, api_key_id, interface, request_id ]`, `[ start_date, api_key_id, interface, request_ip ]`, `[ start_date, api_key_id, interface, request_method ]`, `[ start_date, api_key_id, interface, success ]`, `[ start_date, api_key_id, interface, user_id ]`, `[ start_date, api_key_id, request_id, request_ip ]`, `[ start_date, api_key_id, request_id, request_method ]`, `[ start_date, api_key_id, request_id, success ]`, `[ start_date, api_key_id, request_id, user_id ]`, `[ start_date, api_key_id, request_ip, request_method ]`, `[ start_date, api_key_id, request_ip, success ]`, `[ start_date, api_key_id, request_ip, user_id ]`, `[ start_date, api_key_id, request_method, success ]`, `[ start_date, api_key_id, request_method, user_id ]`, `[ start_date, api_key_id, success, user_id ]`, `[ start_date, interface, request_id, request_ip ]`, `[ start_date, interface, request_id, request_method ]`, `[ start_date, interface, request_id, success ]`, `[ start_date, interface, request_id, user_id ]`, `[ start_date, interface, request_ip, request_method ]`, `[ start_date, interface, request_ip, success ]`, `[ start_date, interface, request_ip, user_id ]`, `[ start_date, interface, request_method, success ]`, `[ start_date, interface, request_method, user_id ]`, `[ start_date, interface, success, user_id ]`, `[ start_date, request_id, request_ip, request_method ]`, `[ start_date, request_id, request_ip, success ]`, `[ start_date, request_id, request_ip, user_id ]`, `[ start_date, request_id, request_method, success ]`, `[ start_date, request_id, request_method, user_id ]`, `[ start_date, request_id, success, user_id ]`, `[ start_date, request_ip, request_method, success ]`, `[ start_date, request_ip, request_method, user_id ]`, `[ start_date, request_ip, success, user_id ]`, `[ start_date, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id ]`, `[ end_date, api_key_id, interface, request_ip ]`, `[ end_date, api_key_id, interface, request_method ]`, `[ end_date, api_key_id, interface, success ]`, `[ end_date, api_key_id, interface, user_id ]`, `[ end_date, api_key_id, request_id, request_ip ]`, `[ end_date, api_key_id, request_id, request_method ]`, `[ end_date, api_key_id, request_id, success ]`, `[ end_date, api_key_id, request_id, user_id ]`, `[ end_date, api_key_id, request_ip, request_method ]`, `[ end_date, api_key_id, request_ip, success ]`, `[ end_date, api_key_id, request_ip, user_id ]`, `[ end_date, api_key_id, request_method, success ]`, `[ end_date, api_key_id, request_method, user_id ]`, `[ end_date, api_key_id, success, user_id ]`, `[ end_date, interface, request_id, request_ip ]`, `[ end_date, interface, request_id, request_method ]`, `[ end_date, interface, request_id, success ]`, `[ end_date, interface, request_id, user_id ]`, `[ end_date, interface, request_ip, request_method ]`, `[ end_date, interface, request_ip, success ]`, `[ end_date, interface, request_ip, user_id ]`, `[ end_date, interface, request_method, success ]`, `[ end_date, interface, request_method, user_id ]`, `[ end_date, interface, success, user_id ]`, `[ end_date, request_id, request_ip, request_method ]`, `[ end_date, request_id, request_ip, success ]`, `[ end_date, request_id, request_ip, user_id ]`, `[ end_date, request_id, request_method, success ]`, `[ end_date, request_id, request_method, user_id ]`, `[ end_date, request_id, success, user_id ]`, `[ end_date, request_ip, request_method, success ]`, `[ end_date, request_ip, request_method, user_id ]`, `[ end_date, request_ip, success, user_id ]`, `[ end_date, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_method, success, user_id ]`, `[ request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip ]`, `[ start_date, end_date, api_key_id, interface, request_method ]`, `[ start_date, end_date, api_key_id, interface, success ]`, `[ start_date, end_date, api_key_id, interface, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip ]`, `[ start_date, end_date, api_key_id, request_id, request_method ]`, `[ start_date, end_date, api_key_id, request_id, success ]`, `[ start_date, end_date, api_key_id, request_id, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, request_ip, success ]`, `[ start_date, end_date, api_key_id, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, request_method, success ]`, `[ start_date, end_date, api_key_id, request_method, user_id ]`, `[ start_date, end_date, api_key_id, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip ]`, `[ start_date, end_date, interface, request_id, request_method ]`, `[ start_date, end_date, interface, request_id, success ]`, `[ start_date, end_date, interface, request_id, user_id ]`, `[ start_date, end_date, interface, request_ip, request_method ]`, `[ start_date, end_date, interface, request_ip, success ]`, `[ start_date, end_date, interface, request_ip, user_id ]`, `[ start_date, end_date, interface, request_method, success ]`, `[ start_date, end_date, interface, request_method, user_id ]`, `[ start_date, end_date, interface, success, user_id ]`, `[ start_date, end_date, request_id, request_ip, request_method ]`, `[ start_date, end_date, request_id, request_ip, success ]`, `[ start_date, end_date, request_id, request_ip, user_id ]`, `[ start_date, end_date, request_id, request_method, success ]`, `[ start_date, end_date, request_id, request_method, user_id ]`, `[ start_date, end_date, request_id, success, user_id ]`, `[ start_date, end_date, request_ip, request_method, success ]`, `[ start_date, end_date, request_ip, request_method, user_id ]`, `[ start_date, end_date, request_ip, success, user_id ]`, `[ start_date, end_date, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip ]`, `[ start_date, api_key_id, interface, request_id, request_method ]`, `[ start_date, api_key_id, interface, request_id, success ]`, `[ start_date, api_key_id, interface, request_id, user_id ]`, `[ start_date, api_key_id, interface, request_ip, request_method ]`, `[ start_date, api_key_id, interface, request_ip, success ]`, `[ start_date, api_key_id, interface, request_ip, user_id ]`, `[ start_date, api_key_id, interface, request_method, success ]`, `[ start_date, api_key_id, interface, request_method, user_id ]`, `[ start_date, api_key_id, interface, success, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, request_method ]`, `[ start_date, api_key_id, request_id, request_ip, success ]`, `[ start_date, api_key_id, request_id, request_ip, user_id ]`, `[ start_date, api_key_id, request_id, request_method, success ]`, `[ start_date, api_key_id, request_id, request_method, user_id ]`, `[ start_date, api_key_id, request_id, success, user_id ]`, `[ start_date, api_key_id, request_ip, request_method, success ]`, `[ start_date, api_key_id, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, request_ip, success, user_id ]`, `[ start_date, api_key_id, request_method, success, user_id ]`, `[ start_date, interface, request_id, request_ip, request_method ]`, `[ start_date, interface, request_id, request_ip, success ]`, `[ start_date, interface, request_id, request_ip, user_id ]`, `[ start_date, interface, request_id, request_method, success ]`, `[ start_date, interface, request_id, request_method, user_id ]`, `[ start_date, interface, request_id, success, user_id ]`, `[ start_date, interface, request_ip, request_method, success ]`, `[ start_date, interface, request_ip, request_method, user_id ]`, `[ start_date, interface, request_ip, success, user_id ]`, `[ start_date, interface, request_method, success, user_id ]`, `[ start_date, request_id, request_ip, request_method, success ]`, `[ start_date, request_id, request_ip, request_method, user_id ]`, `[ start_date, request_id, request_ip, success, user_id ]`, `[ start_date, request_id, request_method, success, user_id ]`, `[ start_date, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip ]`, `[ end_date, api_key_id, interface, request_id, request_method ]`, `[ end_date, api_key_id, interface, request_id, success ]`, `[ end_date, api_key_id, interface, request_id, user_id ]`, `[ end_date, api_key_id, interface, request_ip, request_method ]`, `[ end_date, api_key_id, interface, request_ip, success ]`, `[ end_date, api_key_id, interface, request_ip, user_id ]`, `[ end_date, api_key_id, interface, request_method, success ]`, `[ end_date, api_key_id, interface, request_method, user_id ]`, `[ end_date, api_key_id, interface, success, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, request_method ]`, `[ end_date, api_key_id, request_id, request_ip, success ]`, `[ end_date, api_key_id, request_id, request_ip, user_id ]`, `[ end_date, api_key_id, request_id, request_method, success ]`, `[ end_date, api_key_id, request_id, request_method, user_id ]`, `[ end_date, api_key_id, request_id, success, user_id ]`, `[ end_date, api_key_id, request_ip, request_method, success ]`, `[ end_date, api_key_id, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, request_ip, success, user_id ]`, `[ end_date, api_key_id, request_method, success, user_id ]`, `[ end_date, interface, request_id, request_ip, request_method ]`, `[ end_date, interface, request_id, request_ip, success ]`, `[ end_date, interface, request_id, request_ip, user_id ]`, `[ end_date, interface, request_id, request_method, success ]`, `[ end_date, interface, request_id, request_method, user_id ]`, `[ end_date, interface, request_id, success, user_id ]`, `[ end_date, interface, request_ip, request_method, success ]`, `[ end_date, interface, request_ip, request_method, user_id ]`, `[ end_date, interface, request_ip, success, user_id ]`, `[ end_date, interface, request_method, success, user_id ]`, `[ end_date, request_id, request_ip, request_method, success ]`, `[ end_date, request_id, request_ip, request_method, user_id ]`, `[ end_date, request_id, request_ip, success, user_id ]`, `[ end_date, request_id, request_method, success, user_id ]`, `[ end_date, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method ]`, `[ start_date, end_date, api_key_id, interface, request_id, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, interface, request_ip, success ]`, `[ start_date, end_date, api_key_id, interface, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, success ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_method, success ]`, `[ start_date, end_date, api_key_id, request_id, request_method, user_id ]`, `[ start_date, end_date, api_key_id, request_id, success, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method ]`, `[ start_date, end_date, interface, request_id, request_ip, success ]`, `[ start_date, end_date, interface, request_id, request_ip, user_id ]`, `[ start_date, end_date, interface, request_id, request_method, success ]`, `[ start_date, end_date, interface, request_id, request_method, user_id ]`, `[ start_date, end_date, interface, request_id, success, user_id ]`, `[ start_date, end_date, interface, request_ip, request_method, success ]`, `[ start_date, end_date, interface, request_ip, request_method, user_id ]`, `[ start_date, end_date, interface, request_ip, success, user_id ]`, `[ start_date, end_date, interface, request_method, success, user_id ]`, `[ start_date, end_date, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, request_id, request_method, success, user_id ]`, `[ start_date, end_date, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method ]`, `[ start_date, api_key_id, interface, request_id, request_ip, success ]`, `[ start_date, api_key_id, interface, request_id, request_ip, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_method, success ]`, `[ start_date, api_key_id, interface, request_id, request_method, user_id ]`, `[ start_date, api_key_id, interface, request_id, success, user_id ]`, `[ start_date, api_key_id, interface, request_ip, request_method, success ]`, `[ start_date, api_key_id, interface, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, interface, request_ip, success, user_id ]`, `[ start_date, api_key_id, interface, request_method, success, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, request_method, success ]`, `[ start_date, api_key_id, request_id, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, success, user_id ]`, `[ start_date, api_key_id, request_id, request_method, success, user_id ]`, `[ start_date, api_key_id, request_ip, request_method, success, user_id ]`, `[ start_date, interface, request_id, request_ip, request_method, success ]`, `[ start_date, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, interface, request_id, request_ip, success, user_id ]`, `[ start_date, interface, request_id, request_method, success, user_id ]`, `[ start_date, interface, request_ip, request_method, success, user_id ]`, `[ start_date, request_id, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip, request_method ]`, `[ end_date, api_key_id, interface, request_id, request_ip, success ]`, `[ end_date, api_key_id, interface, request_id, request_ip, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_method, success ]`, `[ end_date, api_key_id, interface, request_id, request_method, user_id ]`, `[ end_date, api_key_id, interface, request_id, success, user_id ]`, `[ end_date, api_key_id, interface, request_ip, request_method, success ]`, `[ end_date, api_key_id, interface, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, interface, request_ip, success, user_id ]`, `[ end_date, api_key_id, interface, request_method, success, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, request_method, success ]`, `[ end_date, api_key_id, request_id, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, success, user_id ]`, `[ end_date, api_key_id, request_id, request_method, success, user_id ]`, `[ end_date, api_key_id, request_ip, request_method, success, user_id ]`, `[ end_date, interface, request_id, request_ip, request_method, success ]`, `[ end_date, interface, request_id, request_ip, request_method, user_id ]`, `[ end_date, interface, request_id, request_ip, success, user_id ]`, `[ end_date, interface, request_id, request_method, success, user_id ]`, `[ end_date, interface, request_ip, request_method, success, user_id ]`, `[ end_date, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, interface, request_id, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ end_date, api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ end_date, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method, success, user_id ]` or `[ end_date, api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`.
  *   filter_prefix - object - If set, return records where the specified field is prefixed by the supplied value. Valid fields are `interface`, `request_id`, `request_ip` or `request_method`. Valid field combinations are `[ start_date ]`, `[ end_date ]`, `[ api_key_id ]`, `[ interface ]`, `[ request_id ]`, `[ request_ip ]`, `[ request_method ]`, `[ success ]`, `[ user_id ]`, `[ start_date, end_date ]`, `[ start_date, api_key_id ]`, `[ start_date, interface ]`, `[ start_date, request_id ]`, `[ start_date, request_ip ]`, `[ start_date, request_method ]`, `[ start_date, success ]`, `[ start_date, user_id ]`, `[ end_date, api_key_id ]`, `[ end_date, interface ]`, `[ end_date, request_id ]`, `[ end_date, request_ip ]`, `[ end_date, request_method ]`, `[ end_date, success ]`, `[ end_date, user_id ]`, `[ api_key_id, interface ]`, `[ api_key_id, request_id ]`, `[ api_key_id, request_ip ]`, `[ api_key_id, request_method ]`, `[ api_key_id, success ]`, `[ api_key_id, user_id ]`, `[ interface, request_id ]`, `[ interface, request_ip ]`, `[ interface, request_method ]`, `[ interface, success ]`, `[ interface, user_id ]`, `[ request_id, request_ip ]`, `[ request_id, request_method ]`, `[ request_id, success ]`, `[ request_id, user_id ]`, `[ request_ip, request_method ]`, `[ request_ip, success ]`, `[ request_ip, user_id ]`, `[ request_method, success ]`, `[ request_method, user_id ]`, `[ success, user_id ]`, `[ start_date, end_date, api_key_id ]`, `[ start_date, end_date, interface ]`, `[ start_date, end_date, request_id ]`, `[ start_date, end_date, request_ip ]`, `[ start_date, end_date, request_method ]`, `[ start_date, end_date, success ]`, `[ start_date, end_date, user_id ]`, `[ start_date, api_key_id, interface ]`, `[ start_date, api_key_id, request_id ]`, `[ start_date, api_key_id, request_ip ]`, `[ start_date, api_key_id, request_method ]`, `[ start_date, api_key_id, success ]`, `[ start_date, api_key_id, user_id ]`, `[ start_date, interface, request_id ]`, `[ start_date, interface, request_ip ]`, `[ start_date, interface, request_method ]`, `[ start_date, interface, success ]`, `[ start_date, interface, user_id ]`, `[ start_date, request_id, request_ip ]`, `[ start_date, request_id, request_method ]`, `[ start_date, request_id, success ]`, `[ start_date, request_id, user_id ]`, `[ start_date, request_ip, request_method ]`, `[ start_date, request_ip, success ]`, `[ start_date, request_ip, user_id ]`, `[ start_date, request_method, success ]`, `[ start_date, request_method, user_id ]`, `[ start_date, success, user_id ]`, `[ end_date, api_key_id, interface ]`, `[ end_date, api_key_id, request_id ]`, `[ end_date, api_key_id, request_ip ]`, `[ end_date, api_key_id, request_method ]`, `[ end_date, api_key_id, success ]`, `[ end_date, api_key_id, user_id ]`, `[ end_date, interface, request_id ]`, `[ end_date, interface, request_ip ]`, `[ end_date, interface, request_method ]`, `[ end_date, interface, success ]`, `[ end_date, interface, user_id ]`, `[ end_date, request_id, request_ip ]`, `[ end_date, request_id, request_method ]`, `[ end_date, request_id, success ]`, `[ end_date, request_id, user_id ]`, `[ end_date, request_ip, request_method ]`, `[ end_date, request_ip, success ]`, `[ end_date, request_ip, user_id ]`, `[ end_date, request_method, success ]`, `[ end_date, request_method, user_id ]`, `[ end_date, success, user_id ]`, `[ api_key_id, interface, request_id ]`, `[ api_key_id, interface, request_ip ]`, `[ api_key_id, interface, request_method ]`, `[ api_key_id, interface, success ]`, `[ api_key_id, interface, user_id ]`, `[ api_key_id, request_id, request_ip ]`, `[ api_key_id, request_id, request_method ]`, `[ api_key_id, request_id, success ]`, `[ api_key_id, request_id, user_id ]`, `[ api_key_id, request_ip, request_method ]`, `[ api_key_id, request_ip, success ]`, `[ api_key_id, request_ip, user_id ]`, `[ api_key_id, request_method, success ]`, `[ api_key_id, request_method, user_id ]`, `[ api_key_id, success, user_id ]`, `[ interface, request_id, request_ip ]`, `[ interface, request_id, request_method ]`, `[ interface, request_id, success ]`, `[ interface, request_id, user_id ]`, `[ interface, request_ip, request_method ]`, `[ interface, request_ip, success ]`, `[ interface, request_ip, user_id ]`, `[ interface, request_method, success ]`, `[ interface, request_method, user_id ]`, `[ interface, success, user_id ]`, `[ request_id, request_ip, request_method ]`, `[ request_id, request_ip, success ]`, `[ request_id, request_ip, user_id ]`, `[ request_id, request_method, success ]`, `[ request_id, request_method, user_id ]`, `[ request_id, success, user_id ]`, `[ request_ip, request_method, success ]`, `[ request_ip, request_method, user_id ]`, `[ request_ip, success, user_id ]`, `[ request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface ]`, `[ start_date, end_date, api_key_id, request_id ]`, `[ start_date, end_date, api_key_id, request_ip ]`, `[ start_date, end_date, api_key_id, request_method ]`, `[ start_date, end_date, api_key_id, success ]`, `[ start_date, end_date, api_key_id, user_id ]`, `[ start_date, end_date, interface, request_id ]`, `[ start_date, end_date, interface, request_ip ]`, `[ start_date, end_date, interface, request_method ]`, `[ start_date, end_date, interface, success ]`, `[ start_date, end_date, interface, user_id ]`, `[ start_date, end_date, request_id, request_ip ]`, `[ start_date, end_date, request_id, request_method ]`, `[ start_date, end_date, request_id, success ]`, `[ start_date, end_date, request_id, user_id ]`, `[ start_date, end_date, request_ip, request_method ]`, `[ start_date, end_date, request_ip, success ]`, `[ start_date, end_date, request_ip, user_id ]`, `[ start_date, end_date, request_method, success ]`, `[ start_date, end_date, request_method, user_id ]`, `[ start_date, end_date, success, user_id ]`, `[ start_date, api_key_id, interface, request_id ]`, `[ start_date, api_key_id, interface, request_ip ]`, `[ start_date, api_key_id, interface, request_method ]`, `[ start_date, api_key_id, interface, success ]`, `[ start_date, api_key_id, interface, user_id ]`, `[ start_date, api_key_id, request_id, request_ip ]`, `[ start_date, api_key_id, request_id, request_method ]`, `[ start_date, api_key_id, request_id, success ]`, `[ start_date, api_key_id, request_id, user_id ]`, `[ start_date, api_key_id, request_ip, request_method ]`, `[ start_date, api_key_id, request_ip, success ]`, `[ start_date, api_key_id, request_ip, user_id ]`, `[ start_date, api_key_id, request_method, success ]`, `[ start_date, api_key_id, request_method, user_id ]`, `[ start_date, api_key_id, success, user_id ]`, `[ start_date, interface, request_id, request_ip ]`, `[ start_date, interface, request_id, request_method ]`, `[ start_date, interface, request_id, success ]`, `[ start_date, interface, request_id, user_id ]`, `[ start_date, interface, request_ip, request_method ]`, `[ start_date, interface, request_ip, success ]`, `[ start_date, interface, request_ip, user_id ]`, `[ start_date, interface, request_method, success ]`, `[ start_date, interface, request_method, user_id ]`, `[ start_date, interface, success, user_id ]`, `[ start_date, request_id, request_ip, request_method ]`, `[ start_date, request_id, request_ip, success ]`, `[ start_date, request_id, request_ip, user_id ]`, `[ start_date, request_id, request_method, success ]`, `[ start_date, request_id, request_method, user_id ]`, `[ start_date, request_id, success, user_id ]`, `[ start_date, request_ip, request_method, success ]`, `[ start_date, request_ip, request_method, user_id ]`, `[ start_date, request_ip, success, user_id ]`, `[ start_date, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id ]`, `[ end_date, api_key_id, interface, request_ip ]`, `[ end_date, api_key_id, interface, request_method ]`, `[ end_date, api_key_id, interface, success ]`, `[ end_date, api_key_id, interface, user_id ]`, `[ end_date, api_key_id, request_id, request_ip ]`, `[ end_date, api_key_id, request_id, request_method ]`, `[ end_date, api_key_id, request_id, success ]`, `[ end_date, api_key_id, request_id, user_id ]`, `[ end_date, api_key_id, request_ip, request_method ]`, `[ end_date, api_key_id, request_ip, success ]`, `[ end_date, api_key_id, request_ip, user_id ]`, `[ end_date, api_key_id, request_method, success ]`, `[ end_date, api_key_id, request_method, user_id ]`, `[ end_date, api_key_id, success, user_id ]`, `[ end_date, interface, request_id, request_ip ]`, `[ end_date, interface, request_id, request_method ]`, `[ end_date, interface, request_id, success ]`, `[ end_date, interface, request_id, user_id ]`, `[ end_date, interface, request_ip, request_method ]`, `[ end_date, interface, request_ip, success ]`, `[ end_date, interface, request_ip, user_id ]`, `[ end_date, interface, request_method, success ]`, `[ end_date, interface, request_method, user_id ]`, `[ end_date, interface, success, user_id ]`, `[ end_date, request_id, request_ip, request_method ]`, `[ end_date, request_id, request_ip, success ]`, `[ end_date, request_id, request_ip, user_id ]`, `[ end_date, request_id, request_method, success ]`, `[ end_date, request_id, request_method, user_id ]`, `[ end_date, request_id, success, user_id ]`, `[ end_date, request_ip, request_method, success ]`, `[ end_date, request_ip, request_method, user_id ]`, `[ end_date, request_ip, success, user_id ]`, `[ end_date, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip ]`, `[ api_key_id, interface, request_id, request_method ]`, `[ api_key_id, interface, request_id, success ]`, `[ api_key_id, interface, request_id, user_id ]`, `[ api_key_id, interface, request_ip, request_method ]`, `[ api_key_id, interface, request_ip, success ]`, `[ api_key_id, interface, request_ip, user_id ]`, `[ api_key_id, interface, request_method, success ]`, `[ api_key_id, interface, request_method, user_id ]`, `[ api_key_id, interface, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method ]`, `[ api_key_id, request_id, request_ip, success ]`, `[ api_key_id, request_id, request_ip, user_id ]`, `[ api_key_id, request_id, request_method, success ]`, `[ api_key_id, request_id, request_method, user_id ]`, `[ api_key_id, request_id, success, user_id ]`, `[ api_key_id, request_ip, request_method, success ]`, `[ api_key_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_ip, success, user_id ]`, `[ api_key_id, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method ]`, `[ interface, request_id, request_ip, success ]`, `[ interface, request_id, request_ip, user_id ]`, `[ interface, request_id, request_method, success ]`, `[ interface, request_id, request_method, user_id ]`, `[ interface, request_id, success, user_id ]`, `[ interface, request_ip, request_method, success ]`, `[ interface, request_ip, request_method, user_id ]`, `[ interface, request_ip, success, user_id ]`, `[ interface, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success ]`, `[ request_id, request_ip, request_method, user_id ]`, `[ request_id, request_ip, success, user_id ]`, `[ request_id, request_method, success, user_id ]`, `[ request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip ]`, `[ start_date, end_date, api_key_id, interface, request_method ]`, `[ start_date, end_date, api_key_id, interface, success ]`, `[ start_date, end_date, api_key_id, interface, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip ]`, `[ start_date, end_date, api_key_id, request_id, request_method ]`, `[ start_date, end_date, api_key_id, request_id, success ]`, `[ start_date, end_date, api_key_id, request_id, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, request_ip, success ]`, `[ start_date, end_date, api_key_id, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, request_method, success ]`, `[ start_date, end_date, api_key_id, request_method, user_id ]`, `[ start_date, end_date, api_key_id, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip ]`, `[ start_date, end_date, interface, request_id, request_method ]`, `[ start_date, end_date, interface, request_id, success ]`, `[ start_date, end_date, interface, request_id, user_id ]`, `[ start_date, end_date, interface, request_ip, request_method ]`, `[ start_date, end_date, interface, request_ip, success ]`, `[ start_date, end_date, interface, request_ip, user_id ]`, `[ start_date, end_date, interface, request_method, success ]`, `[ start_date, end_date, interface, request_method, user_id ]`, `[ start_date, end_date, interface, success, user_id ]`, `[ start_date, end_date, request_id, request_ip, request_method ]`, `[ start_date, end_date, request_id, request_ip, success ]`, `[ start_date, end_date, request_id, request_ip, user_id ]`, `[ start_date, end_date, request_id, request_method, success ]`, `[ start_date, end_date, request_id, request_method, user_id ]`, `[ start_date, end_date, request_id, success, user_id ]`, `[ start_date, end_date, request_ip, request_method, success ]`, `[ start_date, end_date, request_ip, request_method, user_id ]`, `[ start_date, end_date, request_ip, success, user_id ]`, `[ start_date, end_date, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip ]`, `[ start_date, api_key_id, interface, request_id, request_method ]`, `[ start_date, api_key_id, interface, request_id, success ]`, `[ start_date, api_key_id, interface, request_id, user_id ]`, `[ start_date, api_key_id, interface, request_ip, request_method ]`, `[ start_date, api_key_id, interface, request_ip, success ]`, `[ start_date, api_key_id, interface, request_ip, user_id ]`, `[ start_date, api_key_id, interface, request_method, success ]`, `[ start_date, api_key_id, interface, request_method, user_id ]`, `[ start_date, api_key_id, interface, success, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, request_method ]`, `[ start_date, api_key_id, request_id, request_ip, success ]`, `[ start_date, api_key_id, request_id, request_ip, user_id ]`, `[ start_date, api_key_id, request_id, request_method, success ]`, `[ start_date, api_key_id, request_id, request_method, user_id ]`, `[ start_date, api_key_id, request_id, success, user_id ]`, `[ start_date, api_key_id, request_ip, request_method, success ]`, `[ start_date, api_key_id, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, request_ip, success, user_id ]`, `[ start_date, api_key_id, request_method, success, user_id ]`, `[ start_date, interface, request_id, request_ip, request_method ]`, `[ start_date, interface, request_id, request_ip, success ]`, `[ start_date, interface, request_id, request_ip, user_id ]`, `[ start_date, interface, request_id, request_method, success ]`, `[ start_date, interface, request_id, request_method, user_id ]`, `[ start_date, interface, request_id, success, user_id ]`, `[ start_date, interface, request_ip, request_method, success ]`, `[ start_date, interface, request_ip, request_method, user_id ]`, `[ start_date, interface, request_ip, success, user_id ]`, `[ start_date, interface, request_method, success, user_id ]`, `[ start_date, request_id, request_ip, request_method, success ]`, `[ start_date, request_id, request_ip, request_method, user_id ]`, `[ start_date, request_id, request_ip, success, user_id ]`, `[ start_date, request_id, request_method, success, user_id ]`, `[ start_date, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip ]`, `[ end_date, api_key_id, interface, request_id, request_method ]`, `[ end_date, api_key_id, interface, request_id, success ]`, `[ end_date, api_key_id, interface, request_id, user_id ]`, `[ end_date, api_key_id, interface, request_ip, request_method ]`, `[ end_date, api_key_id, interface, request_ip, success ]`, `[ end_date, api_key_id, interface, request_ip, user_id ]`, `[ end_date, api_key_id, interface, request_method, success ]`, `[ end_date, api_key_id, interface, request_method, user_id ]`, `[ end_date, api_key_id, interface, success, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, request_method ]`, `[ end_date, api_key_id, request_id, request_ip, success ]`, `[ end_date, api_key_id, request_id, request_ip, user_id ]`, `[ end_date, api_key_id, request_id, request_method, success ]`, `[ end_date, api_key_id, request_id, request_method, user_id ]`, `[ end_date, api_key_id, request_id, success, user_id ]`, `[ end_date, api_key_id, request_ip, request_method, success ]`, `[ end_date, api_key_id, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, request_ip, success, user_id ]`, `[ end_date, api_key_id, request_method, success, user_id ]`, `[ end_date, interface, request_id, request_ip, request_method ]`, `[ end_date, interface, request_id, request_ip, success ]`, `[ end_date, interface, request_id, request_ip, user_id ]`, `[ end_date, interface, request_id, request_method, success ]`, `[ end_date, interface, request_id, request_method, user_id ]`, `[ end_date, interface, request_id, success, user_id ]`, `[ end_date, interface, request_ip, request_method, success ]`, `[ end_date, interface, request_ip, request_method, user_id ]`, `[ end_date, interface, request_ip, success, user_id ]`, `[ end_date, interface, request_method, success, user_id ]`, `[ end_date, request_id, request_ip, request_method, success ]`, `[ end_date, request_id, request_ip, request_method, user_id ]`, `[ end_date, request_id, request_ip, success, user_id ]`, `[ end_date, request_id, request_method, success, user_id ]`, `[ end_date, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method ]`, `[ api_key_id, interface, request_id, request_ip, success ]`, `[ api_key_id, interface, request_id, request_ip, user_id ]`, `[ api_key_id, interface, request_id, request_method, success ]`, `[ api_key_id, interface, request_id, request_method, user_id ]`, `[ api_key_id, interface, request_id, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success ]`, `[ api_key_id, interface, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_ip, success, user_id ]`, `[ api_key_id, interface, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success ]`, `[ api_key_id, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, request_id, request_ip, success, user_id ]`, `[ api_key_id, request_id, request_method, success, user_id ]`, `[ api_key_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success ]`, `[ interface, request_id, request_ip, request_method, user_id ]`, `[ interface, request_id, request_ip, success, user_id ]`, `[ interface, request_id, request_method, success, user_id ]`, `[ interface, request_ip, request_method, success, user_id ]`, `[ request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method ]`, `[ start_date, end_date, api_key_id, interface, request_id, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, interface, request_ip, success ]`, `[ start_date, end_date, api_key_id, interface, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, success ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_method, success ]`, `[ start_date, end_date, api_key_id, request_id, request_method, user_id ]`, `[ start_date, end_date, api_key_id, request_id, success, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method ]`, `[ start_date, end_date, interface, request_id, request_ip, success ]`, `[ start_date, end_date, interface, request_id, request_ip, user_id ]`, `[ start_date, end_date, interface, request_id, request_method, success ]`, `[ start_date, end_date, interface, request_id, request_method, user_id ]`, `[ start_date, end_date, interface, request_id, success, user_id ]`, `[ start_date, end_date, interface, request_ip, request_method, success ]`, `[ start_date, end_date, interface, request_ip, request_method, user_id ]`, `[ start_date, end_date, interface, request_ip, success, user_id ]`, `[ start_date, end_date, interface, request_method, success, user_id ]`, `[ start_date, end_date, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, request_id, request_method, success, user_id ]`, `[ start_date, end_date, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method ]`, `[ start_date, api_key_id, interface, request_id, request_ip, success ]`, `[ start_date, api_key_id, interface, request_id, request_ip, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_method, success ]`, `[ start_date, api_key_id, interface, request_id, request_method, user_id ]`, `[ start_date, api_key_id, interface, request_id, success, user_id ]`, `[ start_date, api_key_id, interface, request_ip, request_method, success ]`, `[ start_date, api_key_id, interface, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, interface, request_ip, success, user_id ]`, `[ start_date, api_key_id, interface, request_method, success, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, request_method, success ]`, `[ start_date, api_key_id, request_id, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, success, user_id ]`, `[ start_date, api_key_id, request_id, request_method, success, user_id ]`, `[ start_date, api_key_id, request_ip, request_method, success, user_id ]`, `[ start_date, interface, request_id, request_ip, request_method, success ]`, `[ start_date, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, interface, request_id, request_ip, success, user_id ]`, `[ start_date, interface, request_id, request_method, success, user_id ]`, `[ start_date, interface, request_ip, request_method, success, user_id ]`, `[ start_date, request_id, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip, request_method ]`, `[ end_date, api_key_id, interface, request_id, request_ip, success ]`, `[ end_date, api_key_id, interface, request_id, request_ip, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_method, success ]`, `[ end_date, api_key_id, interface, request_id, request_method, user_id ]`, `[ end_date, api_key_id, interface, request_id, success, user_id ]`, `[ end_date, api_key_id, interface, request_ip, request_method, success ]`, `[ end_date, api_key_id, interface, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, interface, request_ip, success, user_id ]`, `[ end_date, api_key_id, interface, request_method, success, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, request_method, success ]`, `[ end_date, api_key_id, request_id, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, success, user_id ]`, `[ end_date, api_key_id, request_id, request_method, success, user_id ]`, `[ end_date, api_key_id, request_ip, request_method, success, user_id ]`, `[ end_date, interface, request_id, request_ip, request_method, success ]`, `[ end_date, interface, request_id, request_ip, request_method, user_id ]`, `[ end_date, interface, request_id, request_ip, success, user_id ]`, `[ end_date, interface, request_id, request_method, success, user_id ]`, `[ end_date, interface, request_ip, request_method, success, user_id ]`, `[ end_date, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ api_key_id, interface, request_id, request_method, success, user_id ]`, `[ api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ interface, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, request_method ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, interface, request_id, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ end_date, api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ end_date, api_key_id, interface, request_id, request_method, success, user_id ]`, `[ end_date, api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ end_date, api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ end_date, interface, request_id, request_ip, request_method, success, user_id ]`, `[ api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, request_method, success ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, request_method, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_ip, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_id, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, interface, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, api_key_id, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, end_date, interface, request_id, request_ip, request_method, success, user_id ]`, `[ start_date, api_key_id, interface, request_id, request_ip, request_method, success, user_id ]` or `[ end_date, api_key_id, interface, request_id, request_ip, request_method, success, user_id ]`.
  */
  public static ListIterator<ApiRequestLog> list() throws RuntimeException {
    return list(null, null);
  }

  public static ListIterator<ApiRequestLog> list(HashMap<String, Object> parameters) throws RuntimeException {
    return list(parameters, null);
  }


  public static ListIterator<ApiRequestLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
    parameters = parameters != null ? parameters : new HashMap<String, Object>();
    options = options != null ? options : new HashMap<String, Object>();



    if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
      throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
    }
    if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
      throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
    }
    if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
      throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
    }
    if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
      throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
    }


    String url = String.format("%s%s/api_request_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());

    TypeReference<List<ApiRequestLog>> typeReference = new TypeReference<List<ApiRequestLog>>() {};
    return FilesClient.requestList(url, RequestMethods.GET, typeReference, parameters, options);
  }

  public static ListIterator<ApiRequestLog> all() throws RuntimeException {
    return all(null, null);
  }

  public static ListIterator<ApiRequestLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
    return list(parameters, options);
  }

}
