/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class App
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="app_type")
    public String appType;
    @JsonProperty(value="documentation_links")
    public Map<String, String> documentationLinks;
    @JsonProperty(value="extended_description")
    public String extendedDescription;
    @JsonProperty(value="extended_description_for_marketing_site")
    public String extendedDescriptionForMarketingSite;
    @JsonProperty(value="external_homepage_url")
    public String externalHomepageUrl;
    @JsonProperty(value="featured")
    public Boolean featured;
    @JsonProperty(value="folder_behavior_type")
    public String folderBehaviorType;
    @JsonProperty(value="icon_url")
    public String iconUrl;
    @JsonProperty(value="logo_thumbnail_url")
    public String logoThumbnailUrl;
    @JsonProperty(value="logo_url")
    public String logoUrl;
    @JsonProperty(value="marketing_intro")
    public String marketingIntro;
    @JsonProperty(value="marketing_youtube_url")
    public String marketingYoutubeUrl;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="package_manager_install_command")
    public String packageManagerInstallCommand;
    @JsonProperty(value="remote_server_type")
    public String remoteServerType;
    @JsonProperty(value="screenshot_list_urls")
    public String[] screenshotListUrls;
    @JsonProperty(value="sdk_installation_instructions_link")
    public String sdkInstallationInstructionsLink;
    @JsonProperty(value="short_description")
    public String shortDescription;
    @JsonProperty(value="sso_strategy_type")
    public String ssoStrategyType;
    @JsonProperty(value="siem_type")
    public String siemType;
    @JsonProperty(value="tutorial_youtube_url")
    public String tutorialYoutubeUrl;

    public App() {
        this(null, null);
    }

    public App(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public App(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<App> list() throws RuntimeException {
        return App.list(null, null);
    }

    public static ListIterator<App> list(HashMap<String, Object> parameters) throws RuntimeException {
        return App.list(parameters, null);
    }

    public static ListIterator<App> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/apps", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<App>> typeReference = new TypeReference<List<App>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<App> all() throws RuntimeException {
        return App.all(null, null);
    }

    public static ListIterator<App> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return App.list(parameters, options);
    }

    public static Export createExport() throws RuntimeException {
        return App.createExport(null, null);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return App.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/apps/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public String getAppType() {
        return this.appType;
    }

    @Generated
    public Map<String, String> getDocumentationLinks() {
        return this.documentationLinks;
    }

    @Generated
    public String getExtendedDescription() {
        return this.extendedDescription;
    }

    @Generated
    public String getExtendedDescriptionForMarketingSite() {
        return this.extendedDescriptionForMarketingSite;
    }

    @Generated
    public String getExternalHomepageUrl() {
        return this.externalHomepageUrl;
    }

    @Generated
    public Boolean getFeatured() {
        return this.featured;
    }

    @Generated
    public String getFolderBehaviorType() {
        return this.folderBehaviorType;
    }

    @Generated
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Generated
    public String getLogoThumbnailUrl() {
        return this.logoThumbnailUrl;
    }

    @Generated
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Generated
    public String getMarketingIntro() {
        return this.marketingIntro;
    }

    @Generated
    public String getMarketingYoutubeUrl() {
        return this.marketingYoutubeUrl;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPackageManagerInstallCommand() {
        return this.packageManagerInstallCommand;
    }

    @Generated
    public String getRemoteServerType() {
        return this.remoteServerType;
    }

    @Generated
    public String[] getScreenshotListUrls() {
        return this.screenshotListUrls;
    }

    @Generated
    public String getSdkInstallationInstructionsLink() {
        return this.sdkInstallationInstructionsLink;
    }

    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Generated
    public String getSsoStrategyType() {
        return this.ssoStrategyType;
    }

    @Generated
    public String getSiemType() {
        return this.siemType;
    }

    @Generated
    public String getTutorialYoutubeUrl() {
        return this.tutorialYoutubeUrl;
    }
}

