/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class As2Partner
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="as2_station_id")
    public Long as2StationId;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="uri")
    public String uri;
    @JsonProperty(value="server_certificate")
    public String serverCertificate;
    @JsonProperty(value="http_auth_username")
    public String httpAuthUsername;
    @JsonProperty(value="additional_http_headers")
    public Map<String, String> additionalHttpHeaders;
    @JsonProperty(value="default_mime_type")
    public String defaultMimeType;
    @JsonProperty(value="mdn_validation_level")
    public String mdnValidationLevel;
    @JsonProperty(value="enable_dedicated_ips")
    public Boolean enableDedicatedIps;
    @JsonProperty(value="hex_public_certificate_serial")
    public String hexPublicCertificateSerial;
    @JsonProperty(value="public_certificate_md5")
    public String publicCertificateMd5;
    @JsonProperty(value="public_certificate_subject")
    public String publicCertificateSubject;
    @JsonProperty(value="public_certificate_issuer")
    public String publicCertificateIssuer;
    @JsonProperty(value="public_certificate_serial")
    public String publicCertificateSerial;
    @JsonProperty(value="public_certificate_not_before")
    public String publicCertificateNotBefore;
    @JsonProperty(value="public_certificate_not_after")
    public String publicCertificateNotAfter;
    @JsonProperty(value="http_auth_password")
    public String httpAuthPassword;
    @JsonProperty(value="public_certificate")
    public String publicCertificate;

    public As2Partner() {
        this(null, null);
    }

    public As2Partner(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public As2Partner(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public As2Partner update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return As2Partner.update(this.id, parameters, this.options);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        As2Partner.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        As2Partner.create(parameters, this.options);
    }

    public static ListIterator<As2Partner> list() throws RuntimeException {
        return As2Partner.list(null, null);
    }

    public static ListIterator<As2Partner> list(HashMap<String, Object> parameters) throws RuntimeException {
        return As2Partner.list(parameters, null);
    }

    public static ListIterator<As2Partner> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/as2_partners", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<As2Partner>> typeReference = new TypeReference<List<As2Partner>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<As2Partner> all() throws RuntimeException {
        return As2Partner.all(null, null);
    }

    public static ListIterator<As2Partner> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Partner.list(parameters, options);
    }

    public static As2Partner find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return As2Partner.find(id, parameters, null);
    }

    public static As2Partner find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Partner.find(null, parameters, options);
    }

    public static As2Partner find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/as2_partners/%s", urlParts);
        TypeReference<As2Partner> typeReference = new TypeReference<As2Partner>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static As2Partner get() throws RuntimeException {
        return As2Partner.get(null, null, null);
    }

    public static As2Partner get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Partner.find(id, parameters, options);
    }

    public static As2Partner create(HashMap<String, Object> parameters) throws RuntimeException {
        return As2Partner.create(parameters, null);
    }

    public static As2Partner create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("as2_station_id") || parameters.get("as2_station_id") == null) {
            throw new NullPointerException("Parameter missing: as2_station_id parameters[\"as2_station_id\"]");
        }
        if (!parameters.containsKey("name") || parameters.get("name") == null) {
            throw new NullPointerException("Parameter missing: name parameters[\"name\"]");
        }
        if (!parameters.containsKey("uri") || parameters.get("uri") == null) {
            throw new NullPointerException("Parameter missing: uri parameters[\"uri\"]");
        }
        if (!parameters.containsKey("public_certificate") || parameters.get("public_certificate") == null) {
            throw new NullPointerException("Parameter missing: public_certificate parameters[\"public_certificate\"]");
        }
        if (parameters.containsKey("enable_dedicated_ips") && !(parameters.get("enable_dedicated_ips") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: enable_dedicated_ips must be of type Boolean parameters[\"enable_dedicated_ips\"]");
        }
        if (parameters.containsKey("http_auth_username") && !(parameters.get("http_auth_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: http_auth_username must be of type String parameters[\"http_auth_username\"]");
        }
        if (parameters.containsKey("http_auth_password") && !(parameters.get("http_auth_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: http_auth_password must be of type String parameters[\"http_auth_password\"]");
        }
        if (parameters.containsKey("mdn_validation_level") && !(parameters.get("mdn_validation_level") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: mdn_validation_level must be of type String parameters[\"mdn_validation_level\"]");
        }
        if (parameters.containsKey("server_certificate") && !(parameters.get("server_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_certificate must be of type String parameters[\"server_certificate\"]");
        }
        if (parameters.containsKey("default_mime_type") && !(parameters.get("default_mime_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: default_mime_type must be of type String parameters[\"default_mime_type\"]");
        }
        if (parameters.containsKey("additional_http_headers") && !(parameters.get("additional_http_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_http_headers must be of type Map<String, String> parameters[\"additional_http_headers\"]");
        }
        if (parameters.containsKey("as2_station_id") && !(parameters.get("as2_station_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: as2_station_id must be of type Long parameters[\"as2_station_id\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("uri") && !(parameters.get("uri") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: uri must be of type String parameters[\"uri\"]");
        }
        if (parameters.containsKey("public_certificate") && !(parameters.get("public_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: public_certificate must be of type String parameters[\"public_certificate\"]");
        }
        String url = String.format("%s%s/as2_partners", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<As2Partner> typeReference = new TypeReference<As2Partner>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static Export createExport() throws RuntimeException {
        return As2Partner.createExport(null, null);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return As2Partner.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        options = options != null ? options : new HashMap<String, Object>();
        String url = String.format("%s%s/as2_partners/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static As2Partner update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return As2Partner.update(id, parameters, null);
    }

    public static As2Partner update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Partner.update(null, parameters, options);
    }

    public static As2Partner update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("enable_dedicated_ips") && !(parameters.get("enable_dedicated_ips") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: enable_dedicated_ips must be of type Boolean parameters[\"enable_dedicated_ips\"]");
        }
        if (parameters.containsKey("http_auth_username") && !(parameters.get("http_auth_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: http_auth_username must be of type String parameters[\"http_auth_username\"]");
        }
        if (parameters.containsKey("http_auth_password") && !(parameters.get("http_auth_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: http_auth_password must be of type String parameters[\"http_auth_password\"]");
        }
        if (parameters.containsKey("mdn_validation_level") && !(parameters.get("mdn_validation_level") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: mdn_validation_level must be of type String parameters[\"mdn_validation_level\"]");
        }
        if (parameters.containsKey("server_certificate") && !(parameters.get("server_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_certificate must be of type String parameters[\"server_certificate\"]");
        }
        if (parameters.containsKey("default_mime_type") && !(parameters.get("default_mime_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: default_mime_type must be of type String parameters[\"default_mime_type\"]");
        }
        if (parameters.containsKey("additional_http_headers") && !(parameters.get("additional_http_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_http_headers must be of type Map<String, String> parameters[\"additional_http_headers\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("uri") && !(parameters.get("uri") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: uri must be of type String parameters[\"uri\"]");
        }
        if (parameters.containsKey("public_certificate") && !(parameters.get("public_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: public_certificate must be of type String parameters[\"public_certificate\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/as2_partners/%s", urlParts);
        TypeReference<As2Partner> typeReference = new TypeReference<As2Partner>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        As2Partner.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        As2Partner.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/as2_partners/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        As2Partner.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        As2Partner.delete(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public Long getAs2StationId() {
        return this.as2StationId;
    }

    @JsonProperty(value="as2_station_id")
    @Generated
    public void setAs2StationId(Long as2StationId) {
        this.as2StationId = as2StationId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public String getServerCertificate() {
        return this.serverCertificate;
    }

    @JsonProperty(value="server_certificate")
    @Generated
    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    @Generated
    public String getHttpAuthUsername() {
        return this.httpAuthUsername;
    }

    @JsonProperty(value="http_auth_username")
    @Generated
    public void setHttpAuthUsername(String httpAuthUsername) {
        this.httpAuthUsername = httpAuthUsername;
    }

    @Generated
    public Map<String, String> getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    @JsonProperty(value="additional_http_headers")
    @Generated
    public void setAdditionalHttpHeaders(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders;
    }

    @Generated
    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    @JsonProperty(value="default_mime_type")
    @Generated
    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    @Generated
    public String getMdnValidationLevel() {
        return this.mdnValidationLevel;
    }

    @JsonProperty(value="mdn_validation_level")
    @Generated
    public void setMdnValidationLevel(String mdnValidationLevel) {
        this.mdnValidationLevel = mdnValidationLevel;
    }

    @Generated
    public Boolean getEnableDedicatedIps() {
        return this.enableDedicatedIps;
    }

    @JsonProperty(value="enable_dedicated_ips")
    @Generated
    public void setEnableDedicatedIps(Boolean enableDedicatedIps) {
        this.enableDedicatedIps = enableDedicatedIps;
    }

    @Generated
    public String getHexPublicCertificateSerial() {
        return this.hexPublicCertificateSerial;
    }

    @JsonProperty(value="hex_public_certificate_serial")
    @Generated
    public void setHexPublicCertificateSerial(String hexPublicCertificateSerial) {
        this.hexPublicCertificateSerial = hexPublicCertificateSerial;
    }

    @Generated
    public String getPublicCertificateMd5() {
        return this.publicCertificateMd5;
    }

    @JsonProperty(value="public_certificate_md5")
    @Generated
    public void setPublicCertificateMd5(String publicCertificateMd5) {
        this.publicCertificateMd5 = publicCertificateMd5;
    }

    @Generated
    public String getPublicCertificateSubject() {
        return this.publicCertificateSubject;
    }

    @JsonProperty(value="public_certificate_subject")
    @Generated
    public void setPublicCertificateSubject(String publicCertificateSubject) {
        this.publicCertificateSubject = publicCertificateSubject;
    }

    @Generated
    public String getPublicCertificateIssuer() {
        return this.publicCertificateIssuer;
    }

    @JsonProperty(value="public_certificate_issuer")
    @Generated
    public void setPublicCertificateIssuer(String publicCertificateIssuer) {
        this.publicCertificateIssuer = publicCertificateIssuer;
    }

    @Generated
    public String getPublicCertificateSerial() {
        return this.publicCertificateSerial;
    }

    @JsonProperty(value="public_certificate_serial")
    @Generated
    public void setPublicCertificateSerial(String publicCertificateSerial) {
        this.publicCertificateSerial = publicCertificateSerial;
    }

    @Generated
    public String getPublicCertificateNotBefore() {
        return this.publicCertificateNotBefore;
    }

    @JsonProperty(value="public_certificate_not_before")
    @Generated
    public void setPublicCertificateNotBefore(String publicCertificateNotBefore) {
        this.publicCertificateNotBefore = publicCertificateNotBefore;
    }

    @Generated
    public String getPublicCertificateNotAfter() {
        return this.publicCertificateNotAfter;
    }

    @JsonProperty(value="public_certificate_not_after")
    @Generated
    public void setPublicCertificateNotAfter(String publicCertificateNotAfter) {
        this.publicCertificateNotAfter = publicCertificateNotAfter;
    }

    @Generated
    public String getHttpAuthPassword() {
        return this.httpAuthPassword;
    }

    @JsonProperty(value="http_auth_password")
    @Generated
    public void setHttpAuthPassword(String httpAuthPassword) {
        this.httpAuthPassword = httpAuthPassword;
    }

    @Generated
    public String getPublicCertificate() {
        return this.publicCertificate;
    }

    @JsonProperty(value="public_certificate")
    @Generated
    public void setPublicCertificate(String publicCertificate) {
        this.publicCertificate = publicCertificate;
    }
}

