/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DnsRecord
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="domain")
    public String domain;
    @JsonProperty(value="rrtype")
    public String rrtype;
    @JsonProperty(value="value")
    public String value;

    public DnsRecord() {
        this(null, null);
    }

    public DnsRecord(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public DnsRecord(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<DnsRecord> list() throws RuntimeException {
        return DnsRecord.list(null, null);
    }

    public static ListIterator<DnsRecord> list(HashMap<String, Object> parameters) throws RuntimeException {
        return DnsRecord.list(parameters, null);
    }

    public static ListIterator<DnsRecord> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/dns_records", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<DnsRecord>> typeReference = new TypeReference<List<DnsRecord>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<DnsRecord> all() throws RuntimeException {
        return DnsRecord.all(null, null);
    }

    public static ListIterator<DnsRecord> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return DnsRecord.list(parameters, options);
    }

    public static Export createExport() throws RuntimeException {
        return DnsRecord.createExport(null, null);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return DnsRecord.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        options = options != null ? options : new HashMap<String, Object>();
        String url = String.format("%s%s/dns_records/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getRrtype() {
        return this.rrtype;
    }

    @Generated
    public String getValue() {
        return this.value;
    }
}

