/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Export
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="export_status")
    public String exportStatus;
    @JsonProperty(value="export_type")
    public String exportType;
    @JsonProperty(value="export_rows")
    public Long exportRows;
    @JsonProperty(value="download_uri")
    public String downloadUri;
    @JsonProperty(value="message")
    public String message;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="sort_by")
    public Map<String, String> sortBy;
    @JsonProperty(value="filter")
    public Map<String, String> filter;
    @JsonProperty(value="filter_prefix")
    public Map<String, String> filterPrefix;

    public Export() {
        this(null, null);
    }

    public Export(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Export(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Export.create(parameters, this.options);
    }

    public static ListIterator<Export> list() throws RuntimeException {
        return Export.list(null, null);
    }

    public static ListIterator<Export> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Export.list(parameters, null);
    }

    public static ListIterator<Export> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/exports", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Export>> typeReference = new TypeReference<List<Export>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Export> all() throws RuntimeException {
        return Export.all(null, null);
    }

    public static ListIterator<Export> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Export.list(parameters, options);
    }

    public static Export find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Export.find(id, parameters, null);
    }

    public static Export find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Export.find(null, parameters, options);
    }

    public static Export find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/exports/%s", urlParts);
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Export get() throws RuntimeException {
        return Export.get(null, null, null);
    }

    public static Export get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Export.find(id, parameters, options);
    }

    public static Export create() throws RuntimeException {
        return Export.create(null, null);
    }

    public static Export create(HashMap<String, Object> parameters) throws RuntimeException {
        return Export.create(parameters, null);
    }

    public static Export create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/exports/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public String getExportStatus() {
        return this.exportStatus;
    }

    @JsonProperty(value="export_status")
    @Generated
    public void setExportStatus(String exportStatus) {
        this.exportStatus = exportStatus;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @JsonProperty(value="export_type")
    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public Long getExportRows() {
        return this.exportRows;
    }

    @JsonProperty(value="export_rows")
    @Generated
    public void setExportRows(Long exportRows) {
        this.exportRows = exportRows;
    }

    @Generated
    public String getDownloadUri() {
        return this.downloadUri;
    }

    @JsonProperty(value="download_uri")
    @Generated
    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public Map<String, String> getSortBy() {
        return this.sortBy;
    }

    @JsonProperty(value="sort_by")
    @Generated
    public void setSortBy(Map<String, String> sortBy) {
        this.sortBy = sortBy;
    }

    @Generated
    public Map<String, String> getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @Generated
    public void setFilter(Map<String, String> filter) {
        this.filter = filter;
    }

    @Generated
    public Map<String, String> getFilterPrefix() {
        return this.filterPrefix;
    }

    @JsonProperty(value="filter_prefix")
    @Generated
    public void setFilterPrefix(Map<String, String> filterPrefix) {
        this.filterPrefix = filterPrefix;
    }
}

