/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GroupUser
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="group_name")
    public String groupName;
    @JsonProperty(value="group_id")
    public Long groupId;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="admin")
    public Boolean admin;
    @JsonProperty(value="usernames")
    public String usernames;
    @JsonProperty(value="id")
    public Long id;

    public GroupUser() {
        this(null, null);
    }

    public GroupUser(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public GroupUser(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public GroupUser update() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        return GroupUser.update(this.id, parameters, this.options);
    }

    public void delete() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        GroupUser.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete();
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        GroupUser.create(parameters, this.options);
    }

    public static ListIterator<GroupUser> list() throws RuntimeException {
        return GroupUser.list(null, null);
    }

    public static ListIterator<GroupUser> list(HashMap<String, Object> parameters) throws RuntimeException {
        return GroupUser.list(parameters, null);
    }

    public static ListIterator<GroupUser> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        String url = String.format("%s%s/group_users", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<GroupUser>> typeReference = new TypeReference<List<GroupUser>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<GroupUser> all() throws RuntimeException {
        return GroupUser.all(null, null);
    }

    public static ListIterator<GroupUser> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return GroupUser.list(parameters, options);
    }

    public static GroupUser create(HashMap<String, Object> parameters) throws RuntimeException {
        return GroupUser.create(parameters, null);
    }

    public static GroupUser create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("group_id") || parameters.get("group_id") == null) {
            throw new NullPointerException("Parameter missing: group_id parameters[\"group_id\"]");
        }
        if (!parameters.containsKey("user_id") || parameters.get("user_id") == null) {
            throw new NullPointerException("Parameter missing: user_id parameters[\"user_id\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("admin") && !(parameters.get("admin") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: admin must be of type Boolean parameters[\"admin\"]");
        }
        String url = String.format("%s%s/group_users", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<GroupUser> typeReference = new TypeReference<GroupUser>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static Export createExport() throws RuntimeException {
        return GroupUser.createExport(null, null);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return GroupUser.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        String url = String.format("%s%s/group_users/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static GroupUser update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return GroupUser.update(id, parameters, null);
    }

    public static GroupUser update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return GroupUser.update(null, parameters, options);
    }

    public static GroupUser update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!parameters.containsKey("group_id") || parameters.get("group_id") == null) {
            throw new NullPointerException("Parameter missing: group_id parameters[\"group_id\"]");
        }
        if (!parameters.containsKey("user_id") || parameters.get("user_id") == null) {
            throw new NullPointerException("Parameter missing: user_id parameters[\"user_id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        if (parameters.containsKey("admin") && !(parameters.get("admin") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: admin must be of type Boolean parameters[\"admin\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/group_users/%s", urlParts);
        TypeReference<GroupUser> typeReference = new TypeReference<GroupUser>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        GroupUser.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        GroupUser.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!parameters.containsKey("group_id") || parameters.get("group_id") == null) {
            throw new NullPointerException("Parameter missing: group_id parameters[\"group_id\"]");
        }
        if (!parameters.containsKey("user_id") || parameters.get("user_id") == null) {
            throw new NullPointerException("Parameter missing: user_id parameters[\"user_id\"]");
        }
        if (!(id instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long parameters[\"id\"]");
        }
        if (parameters.containsKey("group_id") && !(parameters.get("group_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: group_id must be of type Long parameters[\"group_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long parameters[\"user_id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/group_users/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        GroupUser.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        GroupUser.delete(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="group_name")
    @Generated
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Generated
    public Long getGroupId() {
        return this.groupId;
    }

    @JsonProperty(value="group_id")
    @Generated
    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_id")
    @Generated
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Generated
    public Boolean getAdmin() {
        return this.admin;
    }

    @JsonProperty(value="admin")
    @Generated
    public void setAdmin(Boolean admin) {
        this.admin = admin;
    }

    @Generated
    public String getUsernames() {
        return this.usernames;
    }

    @JsonProperty(value="usernames")
    @Generated
    public void setUsernames(String usernames) {
        this.usernames = usernames;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }
}

