/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OutboundConnectionLog
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="timestamp")
    public Date timestamp;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="client_ip")
    public String clientIp;
    @JsonProperty(value="src_remote_server_id")
    public String srcRemoteServerId;
    @JsonProperty(value="dest_remote_server_id")
    public String destRemoteServerId;
    @JsonProperty(value="operation")
    public String operation;
    @JsonProperty(value="error_message")
    public String errorMessage;
    @JsonProperty(value="error_operation")
    public String errorOperation;
    @JsonProperty(value="error_type")
    public String errorType;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="duration_ms")
    public Long durationMs;
    @JsonProperty(value="bytes_uploaded")
    public Long bytesUploaded;
    @JsonProperty(value="bytes_downloaded")
    public Long bytesDownloaded;
    @JsonProperty(value="list_count")
    public Long listCount;

    public OutboundConnectionLog() {
        this(null, null);
    }

    public OutboundConnectionLog(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public OutboundConnectionLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<OutboundConnectionLog> list() throws RuntimeException {
        return OutboundConnectionLog.list(null, null);
    }

    public static ListIterator<OutboundConnectionLog> list(HashMap<String, Object> parameters) throws RuntimeException {
        return OutboundConnectionLog.list(parameters, null);
    }

    public static ListIterator<OutboundConnectionLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/outbound_connection_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<OutboundConnectionLog>> typeReference = new TypeReference<List<OutboundConnectionLog>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<OutboundConnectionLog> all() throws RuntimeException {
        return OutboundConnectionLog.all(null, null);
    }

    public static ListIterator<OutboundConnectionLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return OutboundConnectionLog.list(parameters, options);
    }

    public static Export createExport() throws RuntimeException {
        return OutboundConnectionLog.createExport(null, null);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return OutboundConnectionLog.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/outbound_connection_logs/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getClientIp() {
        return this.clientIp;
    }

    @Generated
    public String getSrcRemoteServerId() {
        return this.srcRemoteServerId;
    }

    @Generated
    public String getDestRemoteServerId() {
        return this.destRemoteServerId;
    }

    @Generated
    public String getOperation() {
        return this.operation;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public String getErrorOperation() {
        return this.errorOperation;
    }

    @Generated
    public String getErrorType() {
        return this.errorType;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Long getDurationMs() {
        return this.durationMs;
    }

    @Generated
    public Long getBytesUploaded() {
        return this.bytesUploaded;
    }

    @Generated
    public Long getBytesDownloaded() {
        return this.bytesDownloaded;
    }

    @Generated
    public Long getListCount() {
        return this.listCount;
    }
}

