/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.Export;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebDavActionLog
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="timestamp")
    public Date timestamp;
    @JsonProperty(value="remote_ip")
    public String remoteIp;
    @JsonProperty(value="server_ip")
    public String serverIp;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="auth_ciphers")
    public String authCiphers;
    @JsonProperty(value="action_type")
    public String actionType;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="true_path")
    public String truePath;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="http_method")
    public String httpMethod;
    @JsonProperty(value="http_path")
    public String httpPath;
    @JsonProperty(value="http_response_code")
    public Long httpResponseCode;
    @JsonProperty(value="size")
    public Long size;
    @JsonProperty(value="entries_returned")
    public Long entriesReturned;
    @JsonProperty(value="success")
    public Boolean success;
    @JsonProperty(value="duration_ms")
    public Long durationMs;

    public WebDavActionLog() {
        this(null, null);
    }

    public WebDavActionLog(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public WebDavActionLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<WebDavActionLog> list() throws RuntimeException {
        return WebDavActionLog.list(null, null);
    }

    public static ListIterator<WebDavActionLog> list(HashMap<String, Object> parameters) throws RuntimeException {
        return WebDavActionLog.list(parameters, null);
    }

    public static ListIterator<WebDavActionLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long parameters[\"per_page\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/web_dav_action_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<WebDavActionLog>> typeReference = new TypeReference<List<WebDavActionLog>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<WebDavActionLog> all() throws RuntimeException {
        return WebDavActionLog.all(null, null);
    }

    public static ListIterator<WebDavActionLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return WebDavActionLog.list(parameters, options);
    }

    public static Export createExport() throws RuntimeException {
        return WebDavActionLog.createExport(null, null);
    }

    public static Export createExport(HashMap<String, Object> parameters) throws RuntimeException {
        return WebDavActionLog.createExport(parameters, null);
    }

    public static Export createExport(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/web_dav_action_logs/create_export", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Export> typeReference = new TypeReference<Export>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getRemoteIp() {
        return this.remoteIp;
    }

    @Generated
    public String getServerIp() {
        return this.serverIp;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getAuthCiphers() {
        return this.authCiphers;
    }

    @Generated
    public String getActionType() {
        return this.actionType;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getTruePath() {
        return this.truePath;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public String getHttpPath() {
        return this.httpPath;
    }

    @Generated
    public Long getHttpResponseCode() {
        return this.httpResponseCode;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public Long getEntriesReturned() {
        return this.entriesReturned;
    }

    @Generated
    public Boolean getSuccess() {
        return this.success;
    }

    @Generated
    public Long getDurationMs() {
        return this.durationMs;
    }
}

