/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Restore
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="earliest_date")
    public Date earliestDate;
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="dirs_restored")
    public Long dirsRestored;
    @JsonProperty(value="dirs_errored")
    public Long dirsErrored;
    @JsonProperty(value="dirs_total")
    public Long dirsTotal;
    @JsonProperty(value="files_restored")
    public Long filesRestored;
    @JsonProperty(value="files_errored")
    public Long filesErrored;
    @JsonProperty(value="files_total")
    public Long filesTotal;
    @JsonProperty(value="prefix")
    public String prefix;
    @JsonProperty(value="restore_in_place")
    public Boolean restoreInPlace;
    @JsonProperty(value="restore_deleted_permissions")
    public Boolean restoreDeletedPermissions;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="update_timestamps")
    public Boolean updateTimestamps;
    @JsonProperty(value="error_messages")
    public String[] errorMessages;

    public Restore() {
        this(null, null);
    }

    public Restore(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Restore(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Restore.create(parameters, this.options);
    }

    public static ListIterator<Restore> list() throws RuntimeException {
        return Restore.list(null, null);
    }

    public static ListIterator<Restore> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Restore.list(parameters, null);
    }

    public static ListIterator<Restore> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/restores", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Restore>> typeReference = new TypeReference<List<Restore>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Restore> all() throws RuntimeException {
        return Restore.all(null, null);
    }

    public static ListIterator<Restore> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Restore.list(parameters, options);
    }

    public static Restore create() throws RuntimeException {
        return Restore.create(null, null);
    }

    public static Restore create(HashMap<String, Object> parameters) throws RuntimeException {
        return Restore.create(parameters, null);
    }

    public static Restore create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("earliest_date") || parameters.get("earliest_date") == null) {
            throw new NullPointerException("Parameter missing: earliest_date parameters[\"earliest_date\"]");
        }
        if (parameters.containsKey("earliest_date") && !(parameters.get("earliest_date") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: earliest_date must be of type String parameters[\"earliest_date\"]");
        }
        if (parameters.containsKey("restore_deleted_permissions") && !(parameters.get("restore_deleted_permissions") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: restore_deleted_permissions must be of type Boolean parameters[\"restore_deleted_permissions\"]");
        }
        if (parameters.containsKey("restore_in_place") && !(parameters.get("restore_in_place") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: restore_in_place must be of type Boolean parameters[\"restore_in_place\"]");
        }
        if (parameters.containsKey("prefix") && !(parameters.get("prefix") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: prefix must be of type String parameters[\"prefix\"]");
        }
        String url = String.format("%s%s/restores", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Restore> typeReference = new TypeReference<Restore>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Date getEarliestDate() {
        return this.earliestDate;
    }

    @JsonProperty(value="earliest_date")
    @Generated
    public void setEarliestDate(Date earliestDate) {
        this.earliestDate = earliestDate;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public Long getDirsRestored() {
        return this.dirsRestored;
    }

    @JsonProperty(value="dirs_restored")
    @Generated
    public void setDirsRestored(Long dirsRestored) {
        this.dirsRestored = dirsRestored;
    }

    @Generated
    public Long getDirsErrored() {
        return this.dirsErrored;
    }

    @JsonProperty(value="dirs_errored")
    @Generated
    public void setDirsErrored(Long dirsErrored) {
        this.dirsErrored = dirsErrored;
    }

    @Generated
    public Long getDirsTotal() {
        return this.dirsTotal;
    }

    @JsonProperty(value="dirs_total")
    @Generated
    public void setDirsTotal(Long dirsTotal) {
        this.dirsTotal = dirsTotal;
    }

    @Generated
    public Long getFilesRestored() {
        return this.filesRestored;
    }

    @JsonProperty(value="files_restored")
    @Generated
    public void setFilesRestored(Long filesRestored) {
        this.filesRestored = filesRestored;
    }

    @Generated
    public Long getFilesErrored() {
        return this.filesErrored;
    }

    @JsonProperty(value="files_errored")
    @Generated
    public void setFilesErrored(Long filesErrored) {
        this.filesErrored = filesErrored;
    }

    @Generated
    public Long getFilesTotal() {
        return this.filesTotal;
    }

    @JsonProperty(value="files_total")
    @Generated
    public void setFilesTotal(Long filesTotal) {
        this.filesTotal = filesTotal;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty(value="prefix")
    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public Boolean getRestoreInPlace() {
        return this.restoreInPlace;
    }

    @JsonProperty(value="restore_in_place")
    @Generated
    public void setRestoreInPlace(Boolean restoreInPlace) {
        this.restoreInPlace = restoreInPlace;
    }

    @Generated
    public Boolean getRestoreDeletedPermissions() {
        return this.restoreDeletedPermissions;
    }

    @JsonProperty(value="restore_deleted_permissions")
    @Generated
    public void setRestoreDeletedPermissions(Boolean restoreDeletedPermissions) {
        this.restoreDeletedPermissions = restoreDeletedPermissions;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public Boolean getUpdateTimestamps() {
        return this.updateTimestamps;
    }

    @JsonProperty(value="update_timestamps")
    @Generated
    public void setUpdateTimestamps(Boolean updateTimestamps) {
        this.updateTimestamps = updateTimestamps;
    }

    @Generated
    public String[] getErrorMessages() {
        return this.errorMessages;
    }

    @JsonProperty(value="error_messages")
    @Generated
    public void setErrorMessages(String[] errorMessages) {
        this.errorMessages = errorMessages;
    }
}

