/*
 * Decompiled with CFR 0.152.
 */
package com.files.net;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.ListIterator;
import com.files.exceptions.ApiErrorException;
import com.files.net.FilesApiInterface;
import com.files.net.FilesHttpClient;
import com.files.net.FilesOkHttpInputStream;
import com.files.net.FilesResponse;
import com.files.net.HttpMethods;
import com.files.util.FilesInputStream;
import com.files.util.ModelUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesOkHttpApi
implements FilesApiInterface {
    private static final Logger log = LoggerFactory.getLogger(FilesOkHttpApi.class);
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).build();

    @Override
    public <T> ListIterator<T> apiRequestList(String url, HttpMethods.RequestMethods requestType, TypeReference<List<T>> clazz, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return new ListIterator<T>(url, requestType, clazz, parameters, options);
    }

    @Override
    public <T> T apiRequestItem(String url, HttpMethods.RequestMethods requestType, TypeReference<T> clazz, HashMap<String, Object> parameters, HashMap<String, Object> options) throws IllegalArgumentException, RuntimeException {
        FilesResponse response = this.apiRequest(url, requestType, parameters, options);
        if ("POST".equals(requestType.toString()) && parameters != null && "put".equals(parameters.getOrDefault("action", "").toString()) && "class com.files.models.FileUploadPart".equals(clazz.getType().toString())) {
            HashMap responseMap;
            try {
                responseMap = (HashMap)this.objectMapper.readValue(response.getBody(), HashMap.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            responseMap.replace("path", parameters.get("path"));
            return (T)this.objectMapper.convertValue((Object)responseMap, clazz);
        }
        try {
            return (T)this.objectMapper.readValue(response.getBody(), clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FilesResponse apiRequest(String url, HttpMethods.RequestMethods requestType, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        boolean requiresAuth;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Sending a %s request to %s with parameters: %s and options %s", new Object[]{requestType, url, parameters, options}));
        }
        Request.Builder request = new Request.Builder();
        switch (requestType) {
            case GET: 
            case HEAD: 
            case DELETE: {
                HttpUrl.Builder httpBuilder = HttpUrl.parse((String)url).newBuilder();
                if (parameters != null) {
                    parameters.forEach((key, value) -> {
                        if (value instanceof Map) {
                            ((Map)value).forEach((key2, value2) -> httpBuilder.addQueryParameter(key + "[" + key2 + "]", value2.toString()));
                        } else {
                            httpBuilder.addQueryParameter(key, value.toString());
                        }
                    });
                }
                request.url(httpBuilder.build().url());
                break;
            }
            default: {
                request.url(url);
            }
        }
        String body = null;
        if (parameters != null) {
            try {
                body = this.objectMapper.writeValueAsString(parameters);
            }
            catch (JsonProcessingException e) {
                throw new ApiErrorException.InvalidParameterException(e.getMessage());
            }
        }
        boolean bl = requiresAuth = !url.contains("sessions") || requestType != HttpMethods.RequestMethods.POST;
        if (requiresAuth) {
            if (options.containsKey("session_id")) {
                if (!(options.get("session_id") instanceof String)) {
                    throw new ApiErrorException.InvalidParameterException("Bad option: session_id must be of type String");
                }
                request.header("X-FilesApi-Auth", (String)options.get("session_id"));
            } else if (options.containsKey("api_key")) {
                if (!(options.get("api_key") instanceof String)) {
                    throw new ApiErrorException.InvalidParameterException("Bad option: api_key must be of type string");
                }
                request.header("X-FilesApi-Key", (String)options.get("api_key"));
            } else if (FilesClient.session != null && FilesClient.session.getId().length() > 0) {
                request.header("X-FilesApi-Auth", FilesClient.session.getId());
            } else if (FilesClient.apiKey != null && FilesClient.apiKey.length() > 0) {
                request.header("X-FilesApi-Key", FilesClient.apiKey);
            } else {
                throw new ApiErrorException.AuthenticationException(String.format("Authentication required for API request: %s %s", new Object[]{url, requestType}), null);
            }
        }
        if (FilesClient.language != null && !FilesClient.language.isEmpty()) {
            request.header("Accept-Language", FilesClient.language);
        }
        FilesOkHttpApi.updateRequestWithHttpMethod(request, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body), requestType);
        try {
            Response response = FilesHttpClient.getHttpClient().newCall(request.build()).execute();
            String responseBody = response.body().string();
            response.body().close();
            return new FilesResponse(response.code(), response.headers().toMultimap(), responseBody);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FilesInputStream getFileInputStream(String url, long start, long end) throws IOException {
        Request.Builder request = new Request.Builder();
        request.url(url);
        Response response = FilesHttpClient.getHttpClient().newCall(request.build()).execute();
        return new FilesOkHttpInputStream(response);
    }

    @Override
    public long putBuffer(String url, HttpMethods.RequestMethods requestType, String name, byte[] buffer, long length) throws IOException {
        MediaType type = MediaType.parse((String)"application/octet-stream");
        RequestBody body = RequestBody.create((MediaType)type, (byte[])buffer, (int)0, (int)((int)length));
        this.sendRequest(url, requestType, body);
        return 0L;
    }

    @Override
    public long putBufferedInputStream(String url, HttpMethods.RequestMethods requestType, String name, BufferedInputStream inputStream, long length) throws IOException {
        MediaType type = MediaType.parse((String)"application/octet-stream");
        RequestBody body = FilesOkHttpApi.create(type, inputStream, length);
        this.sendRequest(url, requestType, body);
        return 0L;
    }

    private Response sendRequest(String url, HttpMethods.RequestMethods requestType, RequestBody body) throws IOException {
        String uri = ModelUtils.forceMandatoryUriEncode(url);
        Request.Builder request = new Request.Builder().addHeader("Content-type", body.contentType().toString()).url(uri);
        FilesOkHttpApi.updateRequestWithHttpMethod(request, body, requestType);
        return FilesHttpClient.getHttpClient().newCall(request.build()).execute();
    }

    public static void updateRequestWithHttpMethod(Request.Builder request, RequestBody body, HttpMethods.RequestMethods requestType) {
        switch (requestType) {
            case DELETE: {
                request.delete(body);
                break;
            }
            case GET: {
                break;
            }
            case HEAD: {
                request.head();
                break;
            }
            case PATCH: {
                request.patch(body);
                break;
            }
            case POST: {
                request.post(body);
                break;
            }
            case PUT: {
                request.put(body);
                break;
            }
        }
    }

    public static RequestBody create(final MediaType contentType, final BufferedInputStream inputStream, final long length) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return length;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                Source source = Okio.source((InputStream)inputStream);
                sink.writeAll(source);
            }
        };
    }
}

