/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.models.FileAction;
import com.files.models.FileUploadPart;
import com.files.models.ModelInterface;
import com.files.models.Preview;
import com.files.net.HttpMethods;
import com.files.util.FilesInputStream;
import com.files.util.ModelUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class File
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="created_by_id")
    public Long createdById;
    @JsonProperty(value="created_by_api_key_id")
    public Long createdByApiKeyId;
    @JsonProperty(value="created_by_as2_incoming_message_id")
    public Long createdByAs2IncomingMessageId;
    @JsonProperty(value="created_by_automation_id")
    public Long createdByAutomationId;
    @JsonProperty(value="created_by_bundle_registration_id")
    public Long createdByBundleRegistrationId;
    @JsonProperty(value="created_by_inbox_id")
    public Long createdByInboxId;
    @JsonProperty(value="created_by_remote_server_id")
    public Long createdByRemoteServerId;
    @JsonProperty(value="created_by_remote_server_sync_id")
    public Long createdByRemoteServerSyncId;
    @JsonProperty(value="custom_metadata")
    public Map<String, String> customMetadata;
    @JsonProperty(value="display_name")
    public String displayName;
    @JsonProperty(value="type")
    public String type;
    @JsonProperty(value="size")
    public Long size;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="last_modified_by_id")
    public Long lastModifiedById;
    @JsonProperty(value="last_modified_by_api_key_id")
    public Long lastModifiedByApiKeyId;
    @JsonProperty(value="last_modified_by_automation_id")
    public Long lastModifiedByAutomationId;
    @JsonProperty(value="last_modified_by_bundle_registration_id")
    public Long lastModifiedByBundleRegistrationId;
    @JsonProperty(value="last_modified_by_remote_server_id")
    public Long lastModifiedByRemoteServerId;
    @JsonProperty(value="last_modified_by_remote_server_sync_id")
    public Long lastModifiedByRemoteServerSyncId;
    @JsonProperty(value="mtime")
    public Date mtime;
    @JsonProperty(value="provided_mtime")
    public Date providedMtime;
    @JsonProperty(value="crc32")
    public String crc32;
    @JsonProperty(value="md5")
    public String md5;
    @JsonProperty(value="sha1")
    public String sha1;
    @JsonProperty(value="sha256")
    public String sha256;
    @JsonProperty(value="mime_type")
    public String mimeType;
    @JsonProperty(value="region")
    public String region;
    @JsonProperty(value="permissions")
    public String permissions;
    @JsonProperty(value="subfolders_locked?")
    public Boolean subfoldersLocked;
    @JsonProperty(value="is_locked")
    public Boolean isLocked;
    @JsonProperty(value="download_uri")
    public String downloadUri;
    @JsonProperty(value="priority_color")
    public String priorityColor;
    @JsonProperty(value="preview_id")
    public Long previewId;
    @JsonProperty(value="preview")
    public Preview preview;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="length")
    public Long length;
    @JsonProperty(value="mkdir_parents")
    public Boolean mkdirParents;
    @JsonProperty(value="part")
    public Long part;
    @JsonProperty(value="parts")
    public Long parts;
    @JsonProperty(value="ref")
    public String ref;
    @JsonProperty(value="restart")
    public Long restart;
    @JsonProperty(value="structure")
    public String structure;
    @JsonProperty(value="with_rename")
    public Boolean withRename;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public FilesInputStream getInputStream() throws IOException {
        return this.getInputStream(0L, 0L);
    }

    public FilesInputStream getInputStream(long start) throws IOException {
        return this.getInputStream(start, 0L);
    }

    public FilesInputStream getInputStream(long start, long end) throws IOException {
        return FilesClient.getFileInputStream(this.downloadUri, start, end);
    }

    public void saveAsLocalFile(String path) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(path);
             FilesInputStream inputStream = this.getInputStream();){
            inputStream.transferTo(outputStream);
        }
    }

    public static File completeUpload(String path, HashMap<String, Object> parameters) throws IOException {
        return File.completeUpload(path, parameters, null);
    }

    public static File completeUpload(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws IOException {
        if (parameters == null) {
            parameters = new HashMap();
        }
        if (options == null) {
            options = new HashMap();
        }
        if (path != null) {
            parameters.put("path", path);
        }
        if (!parameters.containsKey("path") || parameters.get("path") == null) {
            throw new NullPointerException("Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("action")) {
            parameters.put("action", "put");
        }
        String url = String.format("%s%s/files/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(Long createdById) {
        this.createdById = createdById;
    }

    public Long getCreatedByApiKeyId() {
        return this.createdByApiKeyId;
    }

    public void setCreatedByApiKeyId(Long createdByApiKeyId) {
        this.createdByApiKeyId = createdByApiKeyId;
    }

    public Long getCreatedByAs2IncomingMessageId() {
        return this.createdByAs2IncomingMessageId;
    }

    public void setCreatedByAs2IncomingMessageId(Long createdByAs2IncomingMessageId) {
        this.createdByAs2IncomingMessageId = createdByAs2IncomingMessageId;
    }

    public Long getCreatedByAutomationId() {
        return this.createdByAutomationId;
    }

    public void setCreatedByAutomationId(Long createdByAutomationId) {
        this.createdByAutomationId = createdByAutomationId;
    }

    public Long getCreatedByBundleRegistrationId() {
        return this.createdByBundleRegistrationId;
    }

    public void setCreatedByBundleRegistrationId(Long createdByBundleRegistrationId) {
        this.createdByBundleRegistrationId = createdByBundleRegistrationId;
    }

    public Long getCreatedByInboxId() {
        return this.createdByInboxId;
    }

    public void setCreatedByInboxId(Long createdByInboxId) {
        this.createdByInboxId = createdByInboxId;
    }

    public Long getCreatedByRemoteServerId() {
        return this.createdByRemoteServerId;
    }

    public void setCreatedByRemoteServerId(Long createdByRemoteServerId) {
        this.createdByRemoteServerId = createdByRemoteServerId;
    }

    public Long getCreatedByRemoteServerSyncId() {
        return this.createdByRemoteServerSyncId;
    }

    public void setCreatedByRemoteServerSyncId(Long createdByRemoteServerSyncId) {
        this.createdByRemoteServerSyncId = createdByRemoteServerSyncId;
    }

    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Long getLastModifiedById() {
        return this.lastModifiedById;
    }

    public void setLastModifiedById(Long lastModifiedById) {
        this.lastModifiedById = lastModifiedById;
    }

    public Long getLastModifiedByApiKeyId() {
        return this.lastModifiedByApiKeyId;
    }

    public void setLastModifiedByApiKeyId(Long lastModifiedByApiKeyId) {
        this.lastModifiedByApiKeyId = lastModifiedByApiKeyId;
    }

    public Long getLastModifiedByAutomationId() {
        return this.lastModifiedByAutomationId;
    }

    public void setLastModifiedByAutomationId(Long lastModifiedByAutomationId) {
        this.lastModifiedByAutomationId = lastModifiedByAutomationId;
    }

    public Long getLastModifiedByBundleRegistrationId() {
        return this.lastModifiedByBundleRegistrationId;
    }

    public void setLastModifiedByBundleRegistrationId(Long lastModifiedByBundleRegistrationId) {
        this.lastModifiedByBundleRegistrationId = lastModifiedByBundleRegistrationId;
    }

    public Long getLastModifiedByRemoteServerId() {
        return this.lastModifiedByRemoteServerId;
    }

    public void setLastModifiedByRemoteServerId(Long lastModifiedByRemoteServerId) {
        this.lastModifiedByRemoteServerId = lastModifiedByRemoteServerId;
    }

    public Long getLastModifiedByRemoteServerSyncId() {
        return this.lastModifiedByRemoteServerSyncId;
    }

    public void setLastModifiedByRemoteServerSyncId(Long lastModifiedByRemoteServerSyncId) {
        this.lastModifiedByRemoteServerSyncId = lastModifiedByRemoteServerSyncId;
    }

    public Date getMtime() {
        return this.mtime;
    }

    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    public Date getProvidedMtime() {
        return this.providedMtime;
    }

    public void setProvidedMtime(Date providedMtime) {
        this.providedMtime = providedMtime;
    }

    public String getCrc32() {
        return this.crc32;
    }

    public void setCrc32(String crc32) {
        this.crc32 = crc32;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public Boolean getSubfoldersLocked() {
        return this.subfoldersLocked;
    }

    public void setSubfoldersLocked(Boolean subfoldersLocked) {
        this.subfoldersLocked = subfoldersLocked;
    }

    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public String getDownloadUri() {
        return this.downloadUri;
    }

    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    public String getPriorityColor() {
        return this.priorityColor;
    }

    public void setPriorityColor(String priorityColor) {
        this.priorityColor = priorityColor;
    }

    public Long getPreviewId() {
        return this.previewId;
    }

    public void setPreviewId(Long previewId) {
        this.previewId = previewId;
    }

    public Preview getPreview() {
        return this.preview;
    }

    public void setPreview(Preview preview) {
        this.preview = preview;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public Boolean getMkdirParents() {
        return this.mkdirParents;
    }

    public void setMkdirParents(Boolean mkdirParents) {
        this.mkdirParents = mkdirParents;
    }

    public Long getPart() {
        return this.part;
    }

    public void setPart(Long part) {
        this.part = part;
    }

    public Long getParts() {
        return this.parts;
    }

    public void setParts(Long parts) {
        this.parts = parts;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Long getRestart() {
        return this.restart;
    }

    public void setRestart(Long restart) {
        this.restart = restart;
    }

    public String getStructure() {
        return this.structure;
    }

    public void setStructure(String structure) {
        this.structure = structure;
    }

    public Boolean getWithRename() {
        return this.withRename;
    }

    public void setWithRename(Boolean withRename) {
        this.withRename = withRename;
    }

    public File download(HashMap<String, Object> parameters) throws IOException {
        return File.download(this.path, parameters, this.options);
    }

    public File update(HashMap<String, Object> parameters) throws IOException {
        return File.update(this.path, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        File.delete(this.path, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public FileAction copy(HashMap<String, Object> parameters) throws IOException {
        return File.copy(this.path, parameters, this.options);
    }

    public FileAction move(HashMap<String, Object> parameters) throws IOException {
        return File.move(this.path, parameters, this.options);
    }

    public FileUploadPart beginUpload(HashMap<String, Object> parameters) throws IOException {
        return File.beginUpload(this.path, parameters, this.options);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        File.create(parameters, this.options);
    }

    public static File download() throws RuntimeException {
        return File.download(null, null, null);
    }

    public static File download(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.download(path, parameters, null);
    }

    public static File download(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.download(null, parameters, options);
    }

    public static File download(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        if (parameters.containsKey("preview_size") && !(parameters.get("preview_size") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: preview_size must be of type String parameters[\"preview_size\"]");
        }
        if (parameters.containsKey("with_previews") && !(parameters.get("with_previews") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_previews must be of type Boolean parameters[\"with_previews\"]");
        }
        if (parameters.containsKey("with_priority_color") && !(parameters.get("with_priority_color") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_priority_color must be of type Boolean parameters[\"with_priority_color\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static FileUploadPart create() throws RuntimeException {
        return File.create(null, null, null);
    }

    public static FileUploadPart create(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.create(path, parameters, null);
    }

    public static FileUploadPart create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.create(null, parameters, options);
    }

    public static FileUploadPart create(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path != null && parameters.get("path") == null) {
            parameters.put("path", path);
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        if (parameters.containsKey("length") && !(parameters.get("length") instanceof Long) && !(parameters.get("length") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: length must be of type Long or Integer parameters[\"length\"]");
        }
        if (parameters.containsKey("mkdir_parents") && !(parameters.get("mkdir_parents") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mkdir_parents must be of type Boolean parameters[\"mkdir_parents\"]");
        }
        if (parameters.containsKey("part") && !(parameters.get("part") instanceof Long) && !(parameters.get("part") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: part must be of type Long or Integer parameters[\"part\"]");
        }
        if (parameters.containsKey("parts") && !(parameters.get("parts") instanceof Long) && !(parameters.get("parts") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: parts must be of type Long or Integer parameters[\"parts\"]");
        }
        if (parameters.containsKey("provided_mtime") && !(parameters.get("provided_mtime") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: provided_mtime must be of type String parameters[\"provided_mtime\"]");
        }
        if (parameters.containsKey("ref") && !(parameters.get("ref") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ref must be of type String parameters[\"ref\"]");
        }
        if (parameters.containsKey("restart") && !(parameters.get("restart") instanceof Long) && !(parameters.get("restart") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: restart must be of type Long or Integer parameters[\"restart\"]");
        }
        if (parameters.containsKey("size") && !(parameters.get("size") instanceof Long) && !(parameters.get("size") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: size must be of type Long or Integer parameters[\"size\"]");
        }
        if (parameters.containsKey("structure") && !(parameters.get("structure") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: structure must be of type String parameters[\"structure\"]");
        }
        if (parameters.containsKey("with_rename") && !(parameters.get("with_rename") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_rename must be of type Boolean parameters[\"with_rename\"]");
        }
        if (!parameters.containsKey("action")) {
            parameters.put("action", "put");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        TypeReference<FileUploadPart> typeReference = new TypeReference<FileUploadPart>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static File update() throws RuntimeException {
        return File.update(null, null, null);
    }

    public static File update(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.update(path, parameters, null);
    }

    public static File update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.update(null, parameters, options);
    }

    public static File update(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("custom_metadata") && !(parameters.get("custom_metadata") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: custom_metadata must be of type Map<String, String> parameters[\"custom_metadata\"]");
        }
        if (parameters.containsKey("provided_mtime") && !(parameters.get("provided_mtime") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: provided_mtime must be of type String parameters[\"provided_mtime\"]");
        }
        if (parameters.containsKey("priority_color") && !(parameters.get("priority_color") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: priority_color must be of type String parameters[\"priority_color\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        File.delete(null, null, null);
    }

    public static void delete(String path, HashMap<String, Object> parameters) throws RuntimeException {
        File.delete(path, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        File.delete(null, parameters, options);
    }

    public static void delete(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        File.destroy(null, null, null);
    }

    public static void destroy(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        File.delete(path, parameters, options);
    }

    public static File find() throws RuntimeException {
        return File.find(null, null, null);
    }

    public static File find(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.find(path, parameters, null);
    }

    public static File find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.find(null, parameters, options);
    }

    public static File find(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("preview_size") && !(parameters.get("preview_size") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: preview_size must be of type String parameters[\"preview_size\"]");
        }
        if (parameters.containsKey("with_previews") && !(parameters.get("with_previews") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_previews must be of type Boolean parameters[\"with_previews\"]");
        }
        if (parameters.containsKey("with_priority_color") && !(parameters.get("with_priority_color") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_priority_color must be of type Boolean parameters[\"with_priority_color\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/metadata/%s", urlParts);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static File get() throws RuntimeException {
        return File.get(null, null, null);
    }

    public static File get(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.find(path, parameters, options);
    }

    public static FileAction copy() throws RuntimeException {
        return File.copy(null, null, null);
    }

    public static FileAction copy(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.copy(path, parameters, null);
    }

    public static FileAction copy(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.copy(null, parameters, options);
    }

    public static FileAction copy(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("destination") || parameters.get("destination") == null) {
            throw new NullPointerException("Parameter missing: destination parameters[\"destination\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("destination") && !(parameters.get("destination") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination must be of type String parameters[\"destination\"]");
        }
        if (parameters.containsKey("structure") && !(parameters.get("structure") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: structure must be of type Boolean parameters[\"structure\"]");
        }
        if (parameters.containsKey("overwrite") && !(parameters.get("overwrite") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: overwrite must be of type Boolean parameters[\"overwrite\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/copy/%s", urlParts);
        TypeReference<FileAction> typeReference = new TypeReference<FileAction>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static FileAction move() throws RuntimeException {
        return File.move(null, null, null);
    }

    public static FileAction move(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.move(path, parameters, null);
    }

    public static FileAction move(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.move(null, parameters, options);
    }

    public static FileAction move(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("destination") || parameters.get("destination") == null) {
            throw new NullPointerException("Parameter missing: destination parameters[\"destination\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("destination") && !(parameters.get("destination") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination must be of type String parameters[\"destination\"]");
        }
        if (parameters.containsKey("overwrite") && !(parameters.get("overwrite") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: overwrite must be of type Boolean parameters[\"overwrite\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/move/%s", urlParts);
        TypeReference<FileAction> typeReference = new TypeReference<FileAction>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static FileUploadPart beginUpload() throws RuntimeException {
        return File.beginUpload(null, null, null);
    }

    public static FileUploadPart beginUpload(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.beginUpload(path, parameters, null);
    }

    public static FileUploadPart beginUpload(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.beginUpload(null, parameters, options);
    }

    public static FileUploadPart beginUpload(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("mkdir_parents") && !(parameters.get("mkdir_parents") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mkdir_parents must be of type Boolean parameters[\"mkdir_parents\"]");
        }
        if (parameters.containsKey("part") && !(parameters.get("part") instanceof Long) && !(parameters.get("part") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: part must be of type Long or Integer parameters[\"part\"]");
        }
        if (parameters.containsKey("parts") && !(parameters.get("parts") instanceof Long) && !(parameters.get("parts") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: parts must be of type Long or Integer parameters[\"parts\"]");
        }
        if (parameters.containsKey("ref") && !(parameters.get("ref") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ref must be of type String parameters[\"ref\"]");
        }
        if (parameters.containsKey("restart") && !(parameters.get("restart") instanceof Long) && !(parameters.get("restart") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: restart must be of type Long or Integer parameters[\"restart\"]");
        }
        if (parameters.containsKey("size") && !(parameters.get("size") instanceof Long) && !(parameters.get("size") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: size must be of type Long or Integer parameters[\"size\"]");
        }
        if (parameters.containsKey("with_rename") && !(parameters.get("with_rename") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_rename must be of type Boolean parameters[\"with_rename\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/begin_upload/%s", urlParts);
        TypeReference<FileUploadPart> typeReference = new TypeReference<FileUploadPart>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }
}

