/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SettingsChange
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="changes")
    public String[] changes;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="api_key_id")
    public Long apiKeyId;
    @JsonProperty(value="user_is_files_support")
    public Boolean userIsFilesSupport;
    @JsonProperty(value="user_is_from_parent_site")
    public Boolean userIsFromParentSite;
    @JsonProperty(value="username")
    public String username;

    public SettingsChange() {
        this(null, null);
    }

    public SettingsChange(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public SettingsChange(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<SettingsChange> list() throws RuntimeException {
        return SettingsChange.list(null, null);
    }

    public static ListIterator<SettingsChange> list(HashMap<String, Object> parameters) throws RuntimeException {
        return SettingsChange.list(parameters, null);
    }

    public static ListIterator<SettingsChange> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        String url = String.format("%s%s/settings_changes", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<SettingsChange>> typeReference = new TypeReference<List<SettingsChange>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<SettingsChange> all() throws RuntimeException {
        return SettingsChange.all(null, null);
    }

    public static ListIterator<SettingsChange> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SettingsChange.list(parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public String[] getChanges() {
        return this.changes;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public Long getApiKeyId() {
        return this.apiKeyId;
    }

    @Generated
    public Boolean getUserIsFilesSupport() {
        return this.userIsFilesSupport;
    }

    @Generated
    public Boolean getUserIsFromParentSite() {
        return this.userIsFromParentSite;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }
}

