/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.models.FileAction;
import com.files.models.FileUploadPart;
import com.files.models.ModelInterface;
import com.files.models.Preview;
import com.files.net.HttpMethods;
import com.files.util.FilesInputStream;
import com.files.util.ModelUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class File
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="created_by_id")
    public Long createdById;
    @JsonProperty(value="created_by_api_key_id")
    public Long createdByApiKeyId;
    @JsonProperty(value="created_by_as2_incoming_message_id")
    public Long createdByAs2IncomingMessageId;
    @JsonProperty(value="created_by_automation_id")
    public Long createdByAutomationId;
    @JsonProperty(value="created_by_bundle_registration_id")
    public Long createdByBundleRegistrationId;
    @JsonProperty(value="created_by_inbox_id")
    public Long createdByInboxId;
    @JsonProperty(value="created_by_remote_server_id")
    public Long createdByRemoteServerId;
    @JsonProperty(value="created_by_remote_server_sync_id")
    public Long createdByRemoteServerSyncId;
    @JsonProperty(value="custom_metadata")
    public Map<String, String> customMetadata;
    @JsonProperty(value="display_name")
    public String displayName;
    @JsonProperty(value="type")
    public String type;
    @JsonProperty(value="size")
    public Long size;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="last_modified_by_id")
    public Long lastModifiedById;
    @JsonProperty(value="last_modified_by_api_key_id")
    public Long lastModifiedByApiKeyId;
    @JsonProperty(value="last_modified_by_automation_id")
    public Long lastModifiedByAutomationId;
    @JsonProperty(value="last_modified_by_bundle_registration_id")
    public Long lastModifiedByBundleRegistrationId;
    @JsonProperty(value="last_modified_by_remote_server_id")
    public Long lastModifiedByRemoteServerId;
    @JsonProperty(value="last_modified_by_remote_server_sync_id")
    public Long lastModifiedByRemoteServerSyncId;
    @JsonProperty(value="mtime")
    public Date mtime;
    @JsonProperty(value="provided_mtime")
    public Date providedMtime;
    @JsonProperty(value="crc32")
    public String crc32;
    @JsonProperty(value="md5")
    public String md5;
    @JsonProperty(value="sha1")
    public String sha1;
    @JsonProperty(value="sha256")
    public String sha256;
    @JsonProperty(value="mime_type")
    public String mimeType;
    @JsonProperty(value="region")
    public String region;
    @JsonProperty(value="permissions")
    public String permissions;
    @JsonProperty(value="subfolders_locked?")
    public Boolean subfoldersLocked;
    @JsonProperty(value="is_locked")
    public Boolean isLocked;
    @JsonProperty(value="download_uri")
    public String downloadUri;
    @JsonProperty(value="priority_color")
    public String priorityColor;
    @JsonProperty(value="preview_id")
    public Long previewId;
    @JsonProperty(value="preview")
    public Preview preview;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="length")
    public Long length;
    @JsonProperty(value="mkdir_parents")
    public Boolean mkdirParents;
    @JsonProperty(value="part")
    public Long part;
    @JsonProperty(value="parts")
    public Long parts;
    @JsonProperty(value="ref")
    public String ref;
    @JsonProperty(value="restart")
    public Long restart;
    @JsonProperty(value="structure")
    public String structure;
    @JsonProperty(value="with_rename")
    public Boolean withRename;

    public FilesInputStream getInputStream() throws IOException {
        return this.getInputStream(0L, 0L);
    }

    public FilesInputStream getInputStream(long start) throws IOException {
        return this.getInputStream(start, 0L);
    }

    public FilesInputStream getInputStream(long start, long end) throws IOException {
        return FilesClient.getFileInputStream(this.downloadUri, start, end);
    }

    public void saveAsLocalFile(String path) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(path);
             FilesInputStream inputStream = this.getInputStream();){
            inputStream.transferTo(outputStream);
        }
    }

    public static File completeUpload(String path, HashMap<String, Object> parameters) throws IOException {
        return File.completeUpload(path, parameters, null);
    }

    public static File completeUpload(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws IOException {
        if (parameters == null) {
            parameters = new HashMap();
        }
        if (options == null) {
            options = new HashMap();
        }
        if (path != null) {
            parameters.put("path", path);
        }
        if (!parameters.containsKey("path") || parameters.get("path") == null) {
            throw new NullPointerException("Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("action")) {
            parameters.put("action", "put");
        }
        String url = String.format("%s%s/files/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public File download(HashMap<String, Object> parameters) throws IOException {
        return File.download(this.path, parameters, this.options);
    }

    public File update(HashMap<String, Object> parameters) throws IOException {
        return File.update(this.path, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        File.delete(this.path, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public FileAction copy(HashMap<String, Object> parameters) throws IOException {
        return File.copy(this.path, parameters, this.options);
    }

    public FileAction move(HashMap<String, Object> parameters) throws IOException {
        return File.move(this.path, parameters, this.options);
    }

    public FileUploadPart beginUpload(HashMap<String, Object> parameters) throws IOException {
        return File.beginUpload(this.path, parameters, this.options);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        File.create(parameters, this.options);
    }

    public static File download() throws RuntimeException {
        return File.download(null, null, null);
    }

    public static File download(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.download(path, parameters, null);
    }

    public static File download(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.download(null, parameters, options);
    }

    public static File download(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        if (parameters.containsKey("preview_size") && !(parameters.get("preview_size") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: preview_size must be of type String parameters[\"preview_size\"]");
        }
        if (parameters.containsKey("with_previews") && !(parameters.get("with_previews") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_previews must be of type Boolean parameters[\"with_previews\"]");
        }
        if (parameters.containsKey("with_priority_color") && !(parameters.get("with_priority_color") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_priority_color must be of type Boolean parameters[\"with_priority_color\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static FileUploadPart create() throws RuntimeException {
        return File.create(null, null, null);
    }

    public static FileUploadPart create(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.create(path, parameters, null);
    }

    public static FileUploadPart create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.create(null, parameters, options);
    }

    public static FileUploadPart create(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path != null && parameters.get("path") == null) {
            parameters.put("path", path);
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        if (parameters.containsKey("length") && !(parameters.get("length") instanceof Long) && !(parameters.get("length") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: length must be of type Long or Integer parameters[\"length\"]");
        }
        if (parameters.containsKey("mkdir_parents") && !(parameters.get("mkdir_parents") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mkdir_parents must be of type Boolean parameters[\"mkdir_parents\"]");
        }
        if (parameters.containsKey("part") && !(parameters.get("part") instanceof Long) && !(parameters.get("part") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: part must be of type Long or Integer parameters[\"part\"]");
        }
        if (parameters.containsKey("parts") && !(parameters.get("parts") instanceof Long) && !(parameters.get("parts") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: parts must be of type Long or Integer parameters[\"parts\"]");
        }
        if (parameters.containsKey("provided_mtime") && !(parameters.get("provided_mtime") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: provided_mtime must be of type String parameters[\"provided_mtime\"]");
        }
        if (parameters.containsKey("ref") && !(parameters.get("ref") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ref must be of type String parameters[\"ref\"]");
        }
        if (parameters.containsKey("restart") && !(parameters.get("restart") instanceof Long) && !(parameters.get("restart") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: restart must be of type Long or Integer parameters[\"restart\"]");
        }
        if (parameters.containsKey("size") && !(parameters.get("size") instanceof Long) && !(parameters.get("size") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: size must be of type Long or Integer parameters[\"size\"]");
        }
        if (parameters.containsKey("structure") && !(parameters.get("structure") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: structure must be of type String parameters[\"structure\"]");
        }
        if (parameters.containsKey("with_rename") && !(parameters.get("with_rename") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_rename must be of type Boolean parameters[\"with_rename\"]");
        }
        if (!parameters.containsKey("action")) {
            parameters.put("action", "put");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        TypeReference<FileUploadPart> typeReference = new TypeReference<FileUploadPart>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static File update() throws RuntimeException {
        return File.update(null, null, null);
    }

    public static File update(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.update(path, parameters, null);
    }

    public static File update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.update(null, parameters, options);
    }

    public static File update(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("custom_metadata") && !(parameters.get("custom_metadata") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: custom_metadata must be of type Map<String, String> parameters[\"custom_metadata\"]");
        }
        if (parameters.containsKey("provided_mtime") && !(parameters.get("provided_mtime") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: provided_mtime must be of type String parameters[\"provided_mtime\"]");
        }
        if (parameters.containsKey("priority_color") && !(parameters.get("priority_color") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: priority_color must be of type String parameters[\"priority_color\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        File.delete(null, null, null);
    }

    public static void delete(String path, HashMap<String, Object> parameters) throws RuntimeException {
        File.delete(path, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        File.delete(null, parameters, options);
    }

    public static void delete(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/files/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        File.destroy(null, null, null);
    }

    public static void destroy(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        File.delete(path, parameters, options);
    }

    public static File find() throws RuntimeException {
        return File.find(null, null, null);
    }

    public static File find(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.find(path, parameters, null);
    }

    public static File find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.find(null, parameters, options);
    }

    public static File find(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("preview_size") && !(parameters.get("preview_size") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: preview_size must be of type String parameters[\"preview_size\"]");
        }
        if (parameters.containsKey("with_previews") && !(parameters.get("with_previews") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_previews must be of type Boolean parameters[\"with_previews\"]");
        }
        if (parameters.containsKey("with_priority_color") && !(parameters.get("with_priority_color") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_priority_color must be of type Boolean parameters[\"with_priority_color\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/metadata/%s", urlParts);
        TypeReference<File> typeReference = new TypeReference<File>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static File get() throws RuntimeException {
        return File.get(null, null, null);
    }

    public static File get(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.find(path, parameters, options);
    }

    public static FileAction copy() throws RuntimeException {
        return File.copy(null, null, null);
    }

    public static FileAction copy(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.copy(path, parameters, null);
    }

    public static FileAction copy(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.copy(null, parameters, options);
    }

    public static FileAction copy(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("destination") || parameters.get("destination") == null) {
            throw new NullPointerException("Parameter missing: destination parameters[\"destination\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("destination") && !(parameters.get("destination") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination must be of type String parameters[\"destination\"]");
        }
        if (parameters.containsKey("structure") && !(parameters.get("structure") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: structure must be of type Boolean parameters[\"structure\"]");
        }
        if (parameters.containsKey("overwrite") && !(parameters.get("overwrite") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: overwrite must be of type Boolean parameters[\"overwrite\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/copy/%s", urlParts);
        TypeReference<FileAction> typeReference = new TypeReference<FileAction>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static FileAction move() throws RuntimeException {
        return File.move(null, null, null);
    }

    public static FileAction move(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.move(path, parameters, null);
    }

    public static FileAction move(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.move(null, parameters, options);
    }

    public static FileAction move(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("destination") || parameters.get("destination") == null) {
            throw new NullPointerException("Parameter missing: destination parameters[\"destination\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("destination") && !(parameters.get("destination") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination must be of type String parameters[\"destination\"]");
        }
        if (parameters.containsKey("overwrite") && !(parameters.get("overwrite") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: overwrite must be of type Boolean parameters[\"overwrite\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/move/%s", urlParts);
        TypeReference<FileAction> typeReference = new TypeReference<FileAction>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static FileUploadPart beginUpload() throws RuntimeException {
        return File.beginUpload(null, null, null);
    }

    public static FileUploadPart beginUpload(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return File.beginUpload(path, parameters, null);
    }

    public static FileUploadPart beginUpload(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return File.beginUpload(null, parameters, options);
    }

    public static FileUploadPart beginUpload(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("mkdir_parents") && !(parameters.get("mkdir_parents") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mkdir_parents must be of type Boolean parameters[\"mkdir_parents\"]");
        }
        if (parameters.containsKey("part") && !(parameters.get("part") instanceof Long) && !(parameters.get("part") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: part must be of type Long or Integer parameters[\"part\"]");
        }
        if (parameters.containsKey("parts") && !(parameters.get("parts") instanceof Long) && !(parameters.get("parts") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: parts must be of type Long or Integer parameters[\"parts\"]");
        }
        if (parameters.containsKey("ref") && !(parameters.get("ref") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ref must be of type String parameters[\"ref\"]");
        }
        if (parameters.containsKey("restart") && !(parameters.get("restart") instanceof Long) && !(parameters.get("restart") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: restart must be of type Long or Integer parameters[\"restart\"]");
        }
        if (parameters.containsKey("size") && !(parameters.get("size") instanceof Long) && !(parameters.get("size") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: size must be of type Long or Integer parameters[\"size\"]");
        }
        if (parameters.containsKey("with_rename") && !(parameters.get("with_rename") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_rename must be of type Boolean parameters[\"with_rename\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/file_actions/begin_upload/%s", urlParts);
        TypeReference<FileUploadPart> typeReference = new TypeReference<FileUploadPart>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public Long getCreatedById() {
        return this.createdById;
    }

    @JsonProperty(value="created_by_id")
    @Generated
    public void setCreatedById(Long createdById) {
        this.createdById = createdById;
    }

    @Generated
    public Long getCreatedByApiKeyId() {
        return this.createdByApiKeyId;
    }

    @JsonProperty(value="created_by_api_key_id")
    @Generated
    public void setCreatedByApiKeyId(Long createdByApiKeyId) {
        this.createdByApiKeyId = createdByApiKeyId;
    }

    @Generated
    public Long getCreatedByAs2IncomingMessageId() {
        return this.createdByAs2IncomingMessageId;
    }

    @JsonProperty(value="created_by_as2_incoming_message_id")
    @Generated
    public void setCreatedByAs2IncomingMessageId(Long createdByAs2IncomingMessageId) {
        this.createdByAs2IncomingMessageId = createdByAs2IncomingMessageId;
    }

    @Generated
    public Long getCreatedByAutomationId() {
        return this.createdByAutomationId;
    }

    @JsonProperty(value="created_by_automation_id")
    @Generated
    public void setCreatedByAutomationId(Long createdByAutomationId) {
        this.createdByAutomationId = createdByAutomationId;
    }

    @Generated
    public Long getCreatedByBundleRegistrationId() {
        return this.createdByBundleRegistrationId;
    }

    @JsonProperty(value="created_by_bundle_registration_id")
    @Generated
    public void setCreatedByBundleRegistrationId(Long createdByBundleRegistrationId) {
        this.createdByBundleRegistrationId = createdByBundleRegistrationId;
    }

    @Generated
    public Long getCreatedByInboxId() {
        return this.createdByInboxId;
    }

    @JsonProperty(value="created_by_inbox_id")
    @Generated
    public void setCreatedByInboxId(Long createdByInboxId) {
        this.createdByInboxId = createdByInboxId;
    }

    @Generated
    public Long getCreatedByRemoteServerId() {
        return this.createdByRemoteServerId;
    }

    @JsonProperty(value="created_by_remote_server_id")
    @Generated
    public void setCreatedByRemoteServerId(Long createdByRemoteServerId) {
        this.createdByRemoteServerId = createdByRemoteServerId;
    }

    @Generated
    public Long getCreatedByRemoteServerSyncId() {
        return this.createdByRemoteServerSyncId;
    }

    @JsonProperty(value="created_by_remote_server_sync_id")
    @Generated
    public void setCreatedByRemoteServerSyncId(Long createdByRemoteServerSyncId) {
        this.createdByRemoteServerSyncId = createdByRemoteServerSyncId;
    }

    @Generated
    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="custom_metadata")
    @Generated
    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="display_name")
    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Long getLastModifiedById() {
        return this.lastModifiedById;
    }

    @JsonProperty(value="last_modified_by_id")
    @Generated
    public void setLastModifiedById(Long lastModifiedById) {
        this.lastModifiedById = lastModifiedById;
    }

    @Generated
    public Long getLastModifiedByApiKeyId() {
        return this.lastModifiedByApiKeyId;
    }

    @JsonProperty(value="last_modified_by_api_key_id")
    @Generated
    public void setLastModifiedByApiKeyId(Long lastModifiedByApiKeyId) {
        this.lastModifiedByApiKeyId = lastModifiedByApiKeyId;
    }

    @Generated
    public Long getLastModifiedByAutomationId() {
        return this.lastModifiedByAutomationId;
    }

    @JsonProperty(value="last_modified_by_automation_id")
    @Generated
    public void setLastModifiedByAutomationId(Long lastModifiedByAutomationId) {
        this.lastModifiedByAutomationId = lastModifiedByAutomationId;
    }

    @Generated
    public Long getLastModifiedByBundleRegistrationId() {
        return this.lastModifiedByBundleRegistrationId;
    }

    @JsonProperty(value="last_modified_by_bundle_registration_id")
    @Generated
    public void setLastModifiedByBundleRegistrationId(Long lastModifiedByBundleRegistrationId) {
        this.lastModifiedByBundleRegistrationId = lastModifiedByBundleRegistrationId;
    }

    @Generated
    public Long getLastModifiedByRemoteServerId() {
        return this.lastModifiedByRemoteServerId;
    }

    @JsonProperty(value="last_modified_by_remote_server_id")
    @Generated
    public void setLastModifiedByRemoteServerId(Long lastModifiedByRemoteServerId) {
        this.lastModifiedByRemoteServerId = lastModifiedByRemoteServerId;
    }

    @Generated
    public Long getLastModifiedByRemoteServerSyncId() {
        return this.lastModifiedByRemoteServerSyncId;
    }

    @JsonProperty(value="last_modified_by_remote_server_sync_id")
    @Generated
    public void setLastModifiedByRemoteServerSyncId(Long lastModifiedByRemoteServerSyncId) {
        this.lastModifiedByRemoteServerSyncId = lastModifiedByRemoteServerSyncId;
    }

    @Generated
    public Date getMtime() {
        return this.mtime;
    }

    @JsonProperty(value="mtime")
    @Generated
    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    @Generated
    public Date getProvidedMtime() {
        return this.providedMtime;
    }

    @JsonProperty(value="provided_mtime")
    @Generated
    public void setProvidedMtime(Date providedMtime) {
        this.providedMtime = providedMtime;
    }

    @Generated
    public String getCrc32() {
        return this.crc32;
    }

    @JsonProperty(value="crc32")
    @Generated
    public void setCrc32(String crc32) {
        this.crc32 = crc32;
    }

    @Generated
    public String getMd5() {
        return this.md5;
    }

    @JsonProperty(value="md5")
    @Generated
    public void setMd5(String md5) {
        this.md5 = md5;
    }

    @Generated
    public String getSha1() {
        return this.sha1;
    }

    @JsonProperty(value="sha1")
    @Generated
    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    @Generated
    public String getSha256() {
        return this.sha256;
    }

    @JsonProperty(value="sha256")
    @Generated
    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonProperty(value="mime_type")
    @Generated
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @JsonProperty(value="region")
    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public String getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @Generated
    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    @Generated
    public Boolean getSubfoldersLocked() {
        return this.subfoldersLocked;
    }

    @JsonProperty(value="subfolders_locked?")
    @Generated
    public void setSubfoldersLocked(Boolean subfoldersLocked) {
        this.subfoldersLocked = subfoldersLocked;
    }

    @Generated
    public Boolean getIsLocked() {
        return this.isLocked;
    }

    @JsonProperty(value="is_locked")
    @Generated
    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    @Generated
    public String getDownloadUri() {
        return this.downloadUri;
    }

    @JsonProperty(value="download_uri")
    @Generated
    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    @Generated
    public String getPriorityColor() {
        return this.priorityColor;
    }

    @JsonProperty(value="priority_color")
    @Generated
    public void setPriorityColor(String priorityColor) {
        this.priorityColor = priorityColor;
    }

    @Generated
    public Long getPreviewId() {
        return this.previewId;
    }

    @JsonProperty(value="preview_id")
    @Generated
    public void setPreviewId(Long previewId) {
        this.previewId = previewId;
    }

    @Generated
    public Preview getPreview() {
        return this.preview;
    }

    @JsonProperty(value="preview")
    @Generated
    public void setPreview(Preview preview) {
        this.preview = preview;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @JsonProperty(value="action")
    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public Long getLength() {
        return this.length;
    }

    @JsonProperty(value="length")
    @Generated
    public void setLength(Long length) {
        this.length = length;
    }

    @Generated
    public Boolean getMkdirParents() {
        return this.mkdirParents;
    }

    @JsonProperty(value="mkdir_parents")
    @Generated
    public void setMkdirParents(Boolean mkdirParents) {
        this.mkdirParents = mkdirParents;
    }

    @Generated
    public Long getPart() {
        return this.part;
    }

    @JsonProperty(value="part")
    @Generated
    public void setPart(Long part) {
        this.part = part;
    }

    @Generated
    public Long getParts() {
        return this.parts;
    }

    @JsonProperty(value="parts")
    @Generated
    public void setParts(Long parts) {
        this.parts = parts;
    }

    @Generated
    public String getRef() {
        return this.ref;
    }

    @JsonProperty(value="ref")
    @Generated
    public void setRef(String ref) {
        this.ref = ref;
    }

    @Generated
    public Long getRestart() {
        return this.restart;
    }

    @JsonProperty(value="restart")
    @Generated
    public void setRestart(Long restart) {
        this.restart = restart;
    }

    @Generated
    public String getStructure() {
        return this.structure;
    }

    @JsonProperty(value="structure")
    @Generated
    public void setStructure(String structure) {
        this.structure = structure;
    }

    @Generated
    public Boolean getWithRename() {
        return this.withRename;
    }

    @JsonProperty(value="with_rename")
    @Generated
    public void setWithRename(Boolean withRename) {
        this.withRename = withRename;
    }
}

