/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HistoryExportResult
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="created_at")
    public Long createdAt;
    @JsonProperty(value="created_at_iso8601")
    public String createdAtIso8601;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="file_id")
    public Long fileId;
    @JsonProperty(value="parent_id")
    public Long parentId;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="folder")
    public String folder;
    @JsonProperty(value="src")
    public String src;
    @JsonProperty(value="destination")
    public String destination;
    @JsonProperty(value="ip")
    public String ip;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="user_is_from_parent_site")
    public Boolean userIsFromParentSite;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="failure_type")
    public String failureType;
    @JsonProperty(value="interface")
    public String interfaceName;
    @JsonProperty(value="target_id")
    public Long targetId;
    @JsonProperty(value="target_name")
    public String targetName;
    @JsonProperty(value="target_permission")
    public String targetPermission;
    @JsonProperty(value="target_recursive")
    public Boolean targetRecursive;
    @JsonProperty(value="target_expires_at")
    public Long targetExpiresAt;
    @JsonProperty(value="target_expires_at_iso8601")
    public String targetExpiresAtIso8601;
    @JsonProperty(value="target_permission_set")
    public String targetPermissionSet;
    @JsonProperty(value="target_platform")
    public String targetPlatform;
    @JsonProperty(value="target_username")
    public String targetUsername;
    @JsonProperty(value="target_user_id")
    public Long targetUserId;

    public HistoryExportResult() {
        this(null, null);
    }

    public HistoryExportResult(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public HistoryExportResult(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<HistoryExportResult> list() throws RuntimeException {
        return HistoryExportResult.list(null, null);
    }

    public static ListIterator<HistoryExportResult> list(HashMap<String, Object> parameters) throws RuntimeException {
        return HistoryExportResult.list(parameters, null);
    }

    public static ListIterator<HistoryExportResult> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("history_export_id") || parameters.get("history_export_id") == null) {
            throw new NullPointerException("Parameter missing: history_export_id parameters[\"history_export_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("history_export_id") && !(parameters.get("history_export_id") instanceof Long) && !(parameters.get("history_export_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: history_export_id must be of type Long or Integer parameters[\"history_export_id\"]");
        }
        String url = String.format("%s%s/history_export_results", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<HistoryExportResult>> typeReference = new TypeReference<List<HistoryExportResult>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<HistoryExportResult> all() throws RuntimeException {
        return HistoryExportResult.all(null, null);
    }

    public static ListIterator<HistoryExportResult> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return HistoryExportResult.list(parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getCreatedAtIso8601() {
        return this.createdAtIso8601;
    }

    @Generated
    public Long getUserId() {
        return this.userId;
    }

    @Generated
    public Long getFileId() {
        return this.fileId;
    }

    @Generated
    public Long getParentId() {
        return this.parentId;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getFolder() {
        return this.folder;
    }

    @Generated
    public String getSrc() {
        return this.src;
    }

    @Generated
    public String getDestination() {
        return this.destination;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public Boolean getUserIsFromParentSite() {
        return this.userIsFromParentSite;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getFailureType() {
        return this.failureType;
    }

    @Generated
    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Generated
    public Long getTargetId() {
        return this.targetId;
    }

    @Generated
    public String getTargetName() {
        return this.targetName;
    }

    @Generated
    public String getTargetPermission() {
        return this.targetPermission;
    }

    @Generated
    public Boolean getTargetRecursive() {
        return this.targetRecursive;
    }

    @Generated
    public Long getTargetExpiresAt() {
        return this.targetExpiresAt;
    }

    @Generated
    public String getTargetExpiresAtIso8601() {
        return this.targetExpiresAtIso8601;
    }

    @Generated
    public String getTargetPermissionSet() {
        return this.targetPermissionSet;
    }

    @Generated
    public String getTargetPlatform() {
        return this.targetPlatform;
    }

    @Generated
    public String getTargetUsername() {
        return this.targetUsername;
    }

    @Generated
    public Long getTargetUserId() {
        return this.targetUserId;
    }
}

