/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AutomationRun
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="automation_id")
    public Long automationId;
    @JsonProperty(value="completed_at")
    public Date completedAt;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="retry_at")
    public Date retryAt;
    @JsonProperty(value="retried_at")
    public Date retriedAt;
    @JsonProperty(value="retried_in_run_id")
    public Long retriedInRunId;
    @JsonProperty(value="retry_of_run_id")
    public Long retryOfRunId;
    @JsonProperty(value="runtime")
    public Double runtime;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="successful_operations")
    public Long successfulOperations;
    @JsonProperty(value="failed_operations")
    public Long failedOperations;
    @JsonProperty(value="status_messages_url")
    public String statusMessagesUrl;

    public AutomationRun() {
        this(null, null);
    }

    public AutomationRun(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public AutomationRun(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public static ListIterator<AutomationRun> list() throws RuntimeException {
        return AutomationRun.list(null, null);
    }

    public static ListIterator<AutomationRun> list(HashMap<String, Object> parameters) throws RuntimeException {
        return AutomationRun.list(parameters, null);
    }

    public static ListIterator<AutomationRun> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("automation_id") || parameters.get("automation_id") == null) {
            throw new NullPointerException("Parameter missing: automation_id parameters[\"automation_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("automation_id") && !(parameters.get("automation_id") instanceof Long) && !(parameters.get("automation_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: automation_id must be of type Long or Integer parameters[\"automation_id\"]");
        }
        String url = String.format("%s%s/automation_runs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<AutomationRun>> typeReference = new TypeReference<List<AutomationRun>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<AutomationRun> all() throws RuntimeException {
        return AutomationRun.all(null, null);
    }

    public static ListIterator<AutomationRun> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return AutomationRun.list(parameters, options);
    }

    public static AutomationRun find() throws RuntimeException {
        return AutomationRun.find(null, null, null);
    }

    public static AutomationRun find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return AutomationRun.find(id, parameters, null);
    }

    public static AutomationRun find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return AutomationRun.find(null, parameters, options);
    }

    public static AutomationRun find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/automation_runs/%s", urlParts);
        TypeReference<AutomationRun> typeReference = new TypeReference<AutomationRun>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static AutomationRun get() throws RuntimeException {
        return AutomationRun.get(null, null, null);
    }

    public static AutomationRun get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return AutomationRun.find(id, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getAutomationId() {
        return this.automationId;
    }

    @Generated
    public Date getCompletedAt() {
        return this.completedAt;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getRetryAt() {
        return this.retryAt;
    }

    @Generated
    public Date getRetriedAt() {
        return this.retriedAt;
    }

    @Generated
    public Long getRetriedInRunId() {
        return this.retriedInRunId;
    }

    @Generated
    public Long getRetryOfRunId() {
        return this.retryOfRunId;
    }

    @Generated
    public Double getRuntime() {
        return this.runtime;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public Long getSuccessfulOperations() {
        return this.successfulOperations;
    }

    @Generated
    public Long getFailedOperations() {
        return this.failedOperations;
    }

    @Generated
    public String getStatusMessagesUrl() {
        return this.statusMessagesUrl;
    }
}

