/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SsoStrategy
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="protocol")
    public String protocol;
    @JsonProperty(value="provider")
    public String provider;
    @JsonProperty(value="label")
    public String label;
    @JsonProperty(value="logo_url")
    public String logoUrl;
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="user_count")
    public Long userCount;
    @JsonProperty(value="saml_provider_cert_fingerprint")
    public String samlProviderCertFingerprint;
    @JsonProperty(value="saml_provider_issuer_url")
    public String samlProviderIssuerUrl;
    @JsonProperty(value="saml_provider_metadata_content")
    public String samlProviderMetadataContent;
    @JsonProperty(value="saml_provider_metadata_url")
    public String samlProviderMetadataUrl;
    @JsonProperty(value="saml_provider_slo_target_url")
    public String samlProviderSloTargetUrl;
    @JsonProperty(value="saml_provider_sso_target_url")
    public String samlProviderSsoTargetUrl;
    @JsonProperty(value="scim_authentication_method")
    public String scimAuthenticationMethod;
    @JsonProperty(value="scim_username")
    public String scimUsername;
    @JsonProperty(value="scim_oauth_access_token")
    public String scimOauthAccessToken;
    @JsonProperty(value="scim_oauth_access_token_expires_at")
    public String scimOauthAccessTokenExpiresAt;
    @JsonProperty(value="subdomain")
    public String subdomain;
    @JsonProperty(value="provision_users")
    public Boolean provisionUsers;
    @JsonProperty(value="provision_groups")
    public Boolean provisionGroups;
    @JsonProperty(value="deprovision_users")
    public Boolean deprovisionUsers;
    @JsonProperty(value="deprovision_groups")
    public Boolean deprovisionGroups;
    @JsonProperty(value="deprovision_behavior")
    public String deprovisionBehavior;
    @JsonProperty(value="provision_group_default")
    public String provisionGroupDefault;
    @JsonProperty(value="provision_group_exclusion")
    public String provisionGroupExclusion;
    @JsonProperty(value="provision_group_inclusion")
    public String provisionGroupInclusion;
    @JsonProperty(value="provision_group_required")
    public String provisionGroupRequired;
    @JsonProperty(value="provision_email_signup_groups")
    public String provisionEmailSignupGroups;
    @JsonProperty(value="provision_readonly_site_admin_groups")
    public String provisionReadonlySiteAdminGroups;
    @JsonProperty(value="provision_site_admin_groups")
    public String provisionSiteAdminGroups;
    @JsonProperty(value="provision_group_admin_groups")
    public String provisionGroupAdminGroups;
    @JsonProperty(value="provision_attachments_permission")
    public Boolean provisionAttachmentsPermission;
    @JsonProperty(value="provision_dav_permission")
    public Boolean provisionDavPermission;
    @JsonProperty(value="provision_ftp_permission")
    public Boolean provisionFtpPermission;
    @JsonProperty(value="provision_sftp_permission")
    public Boolean provisionSftpPermission;
    @JsonProperty(value="provision_time_zone")
    public String provisionTimeZone;
    @JsonProperty(value="provision_company")
    public String provisionCompany;
    @JsonProperty(value="provision_require_2fa")
    public String provisionRequire2fa;
    @JsonProperty(value="provider_identifier")
    public String providerIdentifier;
    @JsonProperty(value="ldap_base_dn")
    public String ldapBaseDn;
    @JsonProperty(value="ldap_domain")
    public String ldapDomain;
    @JsonProperty(value="enabled")
    public Boolean enabled;
    @JsonProperty(value="ldap_host")
    public String ldapHost;
    @JsonProperty(value="ldap_host_2")
    public String ldapHost2;
    @JsonProperty(value="ldap_host_3")
    public String ldapHost3;
    @JsonProperty(value="ldap_port")
    public Long ldapPort;
    @JsonProperty(value="ldap_secure")
    public Boolean ldapSecure;
    @JsonProperty(value="ldap_username")
    public String ldapUsername;
    @JsonProperty(value="ldap_username_field")
    public String ldapUsernameField;

    public SsoStrategy() {
        this(null, null);
    }

    public SsoStrategy(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public SsoStrategy(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public void sync(HashMap<String, Object> parameters) throws IOException {
        SsoStrategy.sync(this.id, parameters, this.options);
    }

    public static ListIterator<SsoStrategy> list() throws RuntimeException {
        return SsoStrategy.list(null, null);
    }

    public static ListIterator<SsoStrategy> list(HashMap<String, Object> parameters) throws RuntimeException {
        return SsoStrategy.list(parameters, null);
    }

    public static ListIterator<SsoStrategy> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        String url = String.format("%s%s/sso_strategies", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<SsoStrategy>> typeReference = new TypeReference<List<SsoStrategy>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<SsoStrategy> all() throws RuntimeException {
        return SsoStrategy.all(null, null);
    }

    public static ListIterator<SsoStrategy> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SsoStrategy.list(parameters, options);
    }

    public static SsoStrategy find() throws RuntimeException {
        return SsoStrategy.find(null, null, null);
    }

    public static SsoStrategy find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return SsoStrategy.find(id, parameters, null);
    }

    public static SsoStrategy find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SsoStrategy.find(null, parameters, options);
    }

    public static SsoStrategy find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/sso_strategies/%s", urlParts);
        TypeReference<SsoStrategy> typeReference = new TypeReference<SsoStrategy>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static SsoStrategy get() throws RuntimeException {
        return SsoStrategy.get(null, null, null);
    }

    public static SsoStrategy get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SsoStrategy.find(id, parameters, options);
    }

    public static void sync() throws RuntimeException {
        SsoStrategy.sync(null, null, null);
    }

    public static void sync(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        SsoStrategy.sync(id, parameters, null);
    }

    public static void sync(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        SsoStrategy.sync(null, parameters, options);
    }

    public static void sync(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/sso_strategies/%s/sync", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    @Override
    @Generated
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getUserCount() {
        return this.userCount;
    }

    @Generated
    public String getSamlProviderCertFingerprint() {
        return this.samlProviderCertFingerprint;
    }

    @Generated
    public String getSamlProviderIssuerUrl() {
        return this.samlProviderIssuerUrl;
    }

    @Generated
    public String getSamlProviderMetadataContent() {
        return this.samlProviderMetadataContent;
    }

    @Generated
    public String getSamlProviderMetadataUrl() {
        return this.samlProviderMetadataUrl;
    }

    @Generated
    public String getSamlProviderSloTargetUrl() {
        return this.samlProviderSloTargetUrl;
    }

    @Generated
    public String getSamlProviderSsoTargetUrl() {
        return this.samlProviderSsoTargetUrl;
    }

    @Generated
    public String getScimAuthenticationMethod() {
        return this.scimAuthenticationMethod;
    }

    @Generated
    public String getScimUsername() {
        return this.scimUsername;
    }

    @Generated
    public String getScimOauthAccessToken() {
        return this.scimOauthAccessToken;
    }

    @Generated
    public String getScimOauthAccessTokenExpiresAt() {
        return this.scimOauthAccessTokenExpiresAt;
    }

    @Generated
    public String getSubdomain() {
        return this.subdomain;
    }

    @Generated
    public Boolean getProvisionUsers() {
        return this.provisionUsers;
    }

    @Generated
    public Boolean getProvisionGroups() {
        return this.provisionGroups;
    }

    @Generated
    public Boolean getDeprovisionUsers() {
        return this.deprovisionUsers;
    }

    @Generated
    public Boolean getDeprovisionGroups() {
        return this.deprovisionGroups;
    }

    @Generated
    public String getDeprovisionBehavior() {
        return this.deprovisionBehavior;
    }

    @Generated
    public String getProvisionGroupDefault() {
        return this.provisionGroupDefault;
    }

    @Generated
    public String getProvisionGroupExclusion() {
        return this.provisionGroupExclusion;
    }

    @Generated
    public String getProvisionGroupInclusion() {
        return this.provisionGroupInclusion;
    }

    @Generated
    public String getProvisionGroupRequired() {
        return this.provisionGroupRequired;
    }

    @Generated
    public String getProvisionEmailSignupGroups() {
        return this.provisionEmailSignupGroups;
    }

    @Generated
    public String getProvisionReadonlySiteAdminGroups() {
        return this.provisionReadonlySiteAdminGroups;
    }

    @Generated
    public String getProvisionSiteAdminGroups() {
        return this.provisionSiteAdminGroups;
    }

    @Generated
    public String getProvisionGroupAdminGroups() {
        return this.provisionGroupAdminGroups;
    }

    @Generated
    public Boolean getProvisionAttachmentsPermission() {
        return this.provisionAttachmentsPermission;
    }

    @Generated
    public Boolean getProvisionDavPermission() {
        return this.provisionDavPermission;
    }

    @Generated
    public Boolean getProvisionFtpPermission() {
        return this.provisionFtpPermission;
    }

    @Generated
    public Boolean getProvisionSftpPermission() {
        return this.provisionSftpPermission;
    }

    @Generated
    public String getProvisionTimeZone() {
        return this.provisionTimeZone;
    }

    @Generated
    public String getProvisionCompany() {
        return this.provisionCompany;
    }

    @Generated
    public String getProvisionRequire2fa() {
        return this.provisionRequire2fa;
    }

    @Generated
    public String getProviderIdentifier() {
        return this.providerIdentifier;
    }

    @Generated
    public String getLdapBaseDn() {
        return this.ldapBaseDn;
    }

    @Generated
    public String getLdapDomain() {
        return this.ldapDomain;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getLdapHost() {
        return this.ldapHost;
    }

    @Generated
    public String getLdapHost2() {
        return this.ldapHost2;
    }

    @Generated
    public String getLdapHost3() {
        return this.ldapHost3;
    }

    @Generated
    public Long getLdapPort() {
        return this.ldapPort;
    }

    @Generated
    public Boolean getLdapSecure() {
        return this.ldapSecure;
    }

    @Generated
    public String getLdapUsername() {
        return this.ldapUsername;
    }

    @Generated
    public String getLdapUsernameField() {
        return this.ldapUsernameField;
    }
}

