/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.models.Image;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Style
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="logo")
    public Image logo;
    @JsonProperty(value="thumbnail")
    public Image thumbnail;
    @JsonProperty(value="file")
    public byte[] file;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Style() {
        this(null, null);
    }

    public Style(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Style(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Image getLogo() {
        return this.logo;
    }

    public void setLogo(Image logo) {
        this.logo = logo;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image thumbnail) {
        this.thumbnail = thumbnail;
    }

    public byte[] getFile() {
        return this.file;
    }

    public void setFile(byte[] file) {
        this.file = file;
    }

    public Style update(HashMap<String, Object> parameters) throws IOException {
        return Style.update(this.path, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        Style.delete(this.path, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        Style.update();
    }

    public static Style find() throws RuntimeException {
        return Style.find(null, null, null);
    }

    public static Style find(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Style.find(path, parameters, null);
    }

    public static Style find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Style.find(null, parameters, options);
    }

    public static Style find(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        String url = String.format("%s%s/styles/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(path));
        TypeReference<Style> typeReference = new TypeReference<Style>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Style get() throws RuntimeException {
        return Style.get(null, null, null);
    }

    public static Style get(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Style.find(path, parameters, options);
    }

    public static Style update() throws RuntimeException {
        return Style.update(null, null, null);
    }

    public static Style update(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Style.update(path, parameters, null);
    }

    public static Style update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Style.update(null, parameters, options);
    }

    public static Style update(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("file") || parameters.get("file") == null) {
            throw new NullPointerException("Parameter missing: file parameters[\"file\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("file") && !(parameters.get("file") instanceof byte[])) {
            throw new IllegalArgumentException("Bad parameter: file must be of type byte[] parameters[\"file\"]");
        }
        String url = String.format("%s%s/styles/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(path));
        TypeReference<Style> typeReference = new TypeReference<Style>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        Style.delete(null, null, null);
    }

    public static void delete(String path, HashMap<String, Object> parameters) throws RuntimeException {
        Style.delete(path, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Style.delete(null, parameters, options);
    }

    public static void delete(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        String url = String.format("%s%s/styles/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(path));
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Style.destroy(null, null, null);
    }

    public static void destroy(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Style.delete(path, parameters, options);
    }
}

