/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SiemHttpDestination
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="destination_type")
    public String destinationType;
    @JsonProperty(value="destination_url")
    public String destinationUrl;
    @JsonProperty(value="file_destination_path")
    public String fileDestinationPath;
    @JsonProperty(value="file_format")
    public String fileFormat;
    @JsonProperty(value="file_interval_minutes")
    public Long fileIntervalMinutes;
    @JsonProperty(value="additional_headers")
    public Map<String, String> additionalHeaders;
    @JsonProperty(value="sending_active")
    public Boolean sendingActive;
    @JsonProperty(value="generic_payload_type")
    public String genericPayloadType;
    @JsonProperty(value="splunk_token_masked")
    public String splunkTokenMasked;
    @JsonProperty(value="azure_dcr_immutable_id")
    public String azureDcrImmutableId;
    @JsonProperty(value="azure_stream_name")
    public String azureStreamName;
    @JsonProperty(value="azure_oauth_client_credentials_tenant_id")
    public String azureOauthClientCredentialsTenantId;
    @JsonProperty(value="azure_oauth_client_credentials_client_id")
    public String azureOauthClientCredentialsClientId;
    @JsonProperty(value="azure_oauth_client_credentials_client_secret_masked")
    public String azureOauthClientCredentialsClientSecretMasked;
    @JsonProperty(value="qradar_username")
    public String qradarUsername;
    @JsonProperty(value="qradar_password_masked")
    public String qradarPasswordMasked;
    @JsonProperty(value="solar_winds_token_masked")
    public String solarWindsTokenMasked;
    @JsonProperty(value="new_relic_api_key_masked")
    public String newRelicApiKeyMasked;
    @JsonProperty(value="datadog_api_key_masked")
    public String datadogApiKeyMasked;
    @JsonProperty(value="sftp_action_send_enabled")
    public Boolean sftpActionSendEnabled;
    @JsonProperty(value="sftp_action_entries_sent")
    public Long sftpActionEntriesSent;
    @JsonProperty(value="ftp_action_send_enabled")
    public Boolean ftpActionSendEnabled;
    @JsonProperty(value="ftp_action_entries_sent")
    public Long ftpActionEntriesSent;
    @JsonProperty(value="web_dav_action_send_enabled")
    public Boolean webDavActionSendEnabled;
    @JsonProperty(value="web_dav_action_entries_sent")
    public Long webDavActionEntriesSent;
    @JsonProperty(value="sync_send_enabled")
    public Boolean syncSendEnabled;
    @JsonProperty(value="sync_entries_sent")
    public Long syncEntriesSent;
    @JsonProperty(value="outbound_connection_send_enabled")
    public Boolean outboundConnectionSendEnabled;
    @JsonProperty(value="outbound_connection_entries_sent")
    public Long outboundConnectionEntriesSent;
    @JsonProperty(value="automation_send_enabled")
    public Boolean automationSendEnabled;
    @JsonProperty(value="automation_entries_sent")
    public Long automationEntriesSent;
    @JsonProperty(value="api_request_send_enabled")
    public Boolean apiRequestSendEnabled;
    @JsonProperty(value="api_request_entries_sent")
    public Long apiRequestEntriesSent;
    @JsonProperty(value="public_hosting_request_send_enabled")
    public Boolean publicHostingRequestSendEnabled;
    @JsonProperty(value="public_hosting_request_entries_sent")
    public Long publicHostingRequestEntriesSent;
    @JsonProperty(value="email_send_enabled")
    public Boolean emailSendEnabled;
    @JsonProperty(value="email_entries_sent")
    public Long emailEntriesSent;
    @JsonProperty(value="exavault_api_request_send_enabled")
    public Boolean exavaultApiRequestSendEnabled;
    @JsonProperty(value="exavault_api_request_entries_sent")
    public Long exavaultApiRequestEntriesSent;
    @JsonProperty(value="settings_change_send_enabled")
    public Boolean settingsChangeSendEnabled;
    @JsonProperty(value="settings_change_entries_sent")
    public Long settingsChangeEntriesSent;
    @JsonProperty(value="last_http_call_target_type")
    public String lastHttpCallTargetType;
    @JsonProperty(value="last_http_call_success")
    public Boolean lastHttpCallSuccess;
    @JsonProperty(value="last_http_call_response_code")
    public Long lastHttpCallResponseCode;
    @JsonProperty(value="last_http_call_response_body")
    public String lastHttpCallResponseBody;
    @JsonProperty(value="last_http_call_error_message")
    public String lastHttpCallErrorMessage;
    @JsonProperty(value="last_http_call_time")
    public String lastHttpCallTime;
    @JsonProperty(value="last_http_call_duration_ms")
    public Long lastHttpCallDurationMs;
    @JsonProperty(value="most_recent_http_call_success_time")
    public String mostRecentHttpCallSuccessTime;
    @JsonProperty(value="connection_test_entry")
    public String connectionTestEntry;
    @JsonProperty(value="splunk_token")
    public String splunkToken;
    @JsonProperty(value="azure_oauth_client_credentials_client_secret")
    public String azureOauthClientCredentialsClientSecret;
    @JsonProperty(value="qradar_password")
    public String qradarPassword;
    @JsonProperty(value="solar_winds_token")
    public String solarWindsToken;
    @JsonProperty(value="new_relic_api_key")
    public String newRelicApiKey;
    @JsonProperty(value="datadog_api_key")
    public String datadogApiKey;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public SiemHttpDestination() {
        this(null, null);
    }

    public SiemHttpDestination(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public SiemHttpDestination(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    public void setDestinationUrl(String destinationUrl) {
        this.destinationUrl = destinationUrl;
    }

    public String getFileDestinationPath() {
        return this.fileDestinationPath;
    }

    public void setFileDestinationPath(String fileDestinationPath) {
        this.fileDestinationPath = fileDestinationPath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Long getFileIntervalMinutes() {
        return this.fileIntervalMinutes;
    }

    public void setFileIntervalMinutes(Long fileIntervalMinutes) {
        this.fileIntervalMinutes = fileIntervalMinutes;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public Boolean getSendingActive() {
        return this.sendingActive;
    }

    public void setSendingActive(Boolean sendingActive) {
        this.sendingActive = sendingActive;
    }

    public String getGenericPayloadType() {
        return this.genericPayloadType;
    }

    public void setGenericPayloadType(String genericPayloadType) {
        this.genericPayloadType = genericPayloadType;
    }

    public String getSplunkTokenMasked() {
        return this.splunkTokenMasked;
    }

    public void setSplunkTokenMasked(String splunkTokenMasked) {
        this.splunkTokenMasked = splunkTokenMasked;
    }

    public String getAzureDcrImmutableId() {
        return this.azureDcrImmutableId;
    }

    public void setAzureDcrImmutableId(String azureDcrImmutableId) {
        this.azureDcrImmutableId = azureDcrImmutableId;
    }

    public String getAzureStreamName() {
        return this.azureStreamName;
    }

    public void setAzureStreamName(String azureStreamName) {
        this.azureStreamName = azureStreamName;
    }

    public String getAzureOauthClientCredentialsTenantId() {
        return this.azureOauthClientCredentialsTenantId;
    }

    public void setAzureOauthClientCredentialsTenantId(String azureOauthClientCredentialsTenantId) {
        this.azureOauthClientCredentialsTenantId = azureOauthClientCredentialsTenantId;
    }

    public String getAzureOauthClientCredentialsClientId() {
        return this.azureOauthClientCredentialsClientId;
    }

    public void setAzureOauthClientCredentialsClientId(String azureOauthClientCredentialsClientId) {
        this.azureOauthClientCredentialsClientId = azureOauthClientCredentialsClientId;
    }

    public String getAzureOauthClientCredentialsClientSecretMasked() {
        return this.azureOauthClientCredentialsClientSecretMasked;
    }

    public void setAzureOauthClientCredentialsClientSecretMasked(String azureOauthClientCredentialsClientSecretMasked) {
        this.azureOauthClientCredentialsClientSecretMasked = azureOauthClientCredentialsClientSecretMasked;
    }

    public String getQradarUsername() {
        return this.qradarUsername;
    }

    public void setQradarUsername(String qradarUsername) {
        this.qradarUsername = qradarUsername;
    }

    public String getQradarPasswordMasked() {
        return this.qradarPasswordMasked;
    }

    public void setQradarPasswordMasked(String qradarPasswordMasked) {
        this.qradarPasswordMasked = qradarPasswordMasked;
    }

    public String getSolarWindsTokenMasked() {
        return this.solarWindsTokenMasked;
    }

    public void setSolarWindsTokenMasked(String solarWindsTokenMasked) {
        this.solarWindsTokenMasked = solarWindsTokenMasked;
    }

    public String getNewRelicApiKeyMasked() {
        return this.newRelicApiKeyMasked;
    }

    public void setNewRelicApiKeyMasked(String newRelicApiKeyMasked) {
        this.newRelicApiKeyMasked = newRelicApiKeyMasked;
    }

    public String getDatadogApiKeyMasked() {
        return this.datadogApiKeyMasked;
    }

    public void setDatadogApiKeyMasked(String datadogApiKeyMasked) {
        this.datadogApiKeyMasked = datadogApiKeyMasked;
    }

    public Boolean getSftpActionSendEnabled() {
        return this.sftpActionSendEnabled;
    }

    public void setSftpActionSendEnabled(Boolean sftpActionSendEnabled) {
        this.sftpActionSendEnabled = sftpActionSendEnabled;
    }

    public Long getSftpActionEntriesSent() {
        return this.sftpActionEntriesSent;
    }

    public void setSftpActionEntriesSent(Long sftpActionEntriesSent) {
        this.sftpActionEntriesSent = sftpActionEntriesSent;
    }

    public Boolean getFtpActionSendEnabled() {
        return this.ftpActionSendEnabled;
    }

    public void setFtpActionSendEnabled(Boolean ftpActionSendEnabled) {
        this.ftpActionSendEnabled = ftpActionSendEnabled;
    }

    public Long getFtpActionEntriesSent() {
        return this.ftpActionEntriesSent;
    }

    public void setFtpActionEntriesSent(Long ftpActionEntriesSent) {
        this.ftpActionEntriesSent = ftpActionEntriesSent;
    }

    public Boolean getWebDavActionSendEnabled() {
        return this.webDavActionSendEnabled;
    }

    public void setWebDavActionSendEnabled(Boolean webDavActionSendEnabled) {
        this.webDavActionSendEnabled = webDavActionSendEnabled;
    }

    public Long getWebDavActionEntriesSent() {
        return this.webDavActionEntriesSent;
    }

    public void setWebDavActionEntriesSent(Long webDavActionEntriesSent) {
        this.webDavActionEntriesSent = webDavActionEntriesSent;
    }

    public Boolean getSyncSendEnabled() {
        return this.syncSendEnabled;
    }

    public void setSyncSendEnabled(Boolean syncSendEnabled) {
        this.syncSendEnabled = syncSendEnabled;
    }

    public Long getSyncEntriesSent() {
        return this.syncEntriesSent;
    }

    public void setSyncEntriesSent(Long syncEntriesSent) {
        this.syncEntriesSent = syncEntriesSent;
    }

    public Boolean getOutboundConnectionSendEnabled() {
        return this.outboundConnectionSendEnabled;
    }

    public void setOutboundConnectionSendEnabled(Boolean outboundConnectionSendEnabled) {
        this.outboundConnectionSendEnabled = outboundConnectionSendEnabled;
    }

    public Long getOutboundConnectionEntriesSent() {
        return this.outboundConnectionEntriesSent;
    }

    public void setOutboundConnectionEntriesSent(Long outboundConnectionEntriesSent) {
        this.outboundConnectionEntriesSent = outboundConnectionEntriesSent;
    }

    public Boolean getAutomationSendEnabled() {
        return this.automationSendEnabled;
    }

    public void setAutomationSendEnabled(Boolean automationSendEnabled) {
        this.automationSendEnabled = automationSendEnabled;
    }

    public Long getAutomationEntriesSent() {
        return this.automationEntriesSent;
    }

    public void setAutomationEntriesSent(Long automationEntriesSent) {
        this.automationEntriesSent = automationEntriesSent;
    }

    public Boolean getApiRequestSendEnabled() {
        return this.apiRequestSendEnabled;
    }

    public void setApiRequestSendEnabled(Boolean apiRequestSendEnabled) {
        this.apiRequestSendEnabled = apiRequestSendEnabled;
    }

    public Long getApiRequestEntriesSent() {
        return this.apiRequestEntriesSent;
    }

    public void setApiRequestEntriesSent(Long apiRequestEntriesSent) {
        this.apiRequestEntriesSent = apiRequestEntriesSent;
    }

    public Boolean getPublicHostingRequestSendEnabled() {
        return this.publicHostingRequestSendEnabled;
    }

    public void setPublicHostingRequestSendEnabled(Boolean publicHostingRequestSendEnabled) {
        this.publicHostingRequestSendEnabled = publicHostingRequestSendEnabled;
    }

    public Long getPublicHostingRequestEntriesSent() {
        return this.publicHostingRequestEntriesSent;
    }

    public void setPublicHostingRequestEntriesSent(Long publicHostingRequestEntriesSent) {
        this.publicHostingRequestEntriesSent = publicHostingRequestEntriesSent;
    }

    public Boolean getEmailSendEnabled() {
        return this.emailSendEnabled;
    }

    public void setEmailSendEnabled(Boolean emailSendEnabled) {
        this.emailSendEnabled = emailSendEnabled;
    }

    public Long getEmailEntriesSent() {
        return this.emailEntriesSent;
    }

    public void setEmailEntriesSent(Long emailEntriesSent) {
        this.emailEntriesSent = emailEntriesSent;
    }

    public Boolean getExavaultApiRequestSendEnabled() {
        return this.exavaultApiRequestSendEnabled;
    }

    public void setExavaultApiRequestSendEnabled(Boolean exavaultApiRequestSendEnabled) {
        this.exavaultApiRequestSendEnabled = exavaultApiRequestSendEnabled;
    }

    public Long getExavaultApiRequestEntriesSent() {
        return this.exavaultApiRequestEntriesSent;
    }

    public void setExavaultApiRequestEntriesSent(Long exavaultApiRequestEntriesSent) {
        this.exavaultApiRequestEntriesSent = exavaultApiRequestEntriesSent;
    }

    public Boolean getSettingsChangeSendEnabled() {
        return this.settingsChangeSendEnabled;
    }

    public void setSettingsChangeSendEnabled(Boolean settingsChangeSendEnabled) {
        this.settingsChangeSendEnabled = settingsChangeSendEnabled;
    }

    public Long getSettingsChangeEntriesSent() {
        return this.settingsChangeEntriesSent;
    }

    public void setSettingsChangeEntriesSent(Long settingsChangeEntriesSent) {
        this.settingsChangeEntriesSent = settingsChangeEntriesSent;
    }

    public String getLastHttpCallTargetType() {
        return this.lastHttpCallTargetType;
    }

    public void setLastHttpCallTargetType(String lastHttpCallTargetType) {
        this.lastHttpCallTargetType = lastHttpCallTargetType;
    }

    public Boolean getLastHttpCallSuccess() {
        return this.lastHttpCallSuccess;
    }

    public void setLastHttpCallSuccess(Boolean lastHttpCallSuccess) {
        this.lastHttpCallSuccess = lastHttpCallSuccess;
    }

    public Long getLastHttpCallResponseCode() {
        return this.lastHttpCallResponseCode;
    }

    public void setLastHttpCallResponseCode(Long lastHttpCallResponseCode) {
        this.lastHttpCallResponseCode = lastHttpCallResponseCode;
    }

    public String getLastHttpCallResponseBody() {
        return this.lastHttpCallResponseBody;
    }

    public void setLastHttpCallResponseBody(String lastHttpCallResponseBody) {
        this.lastHttpCallResponseBody = lastHttpCallResponseBody;
    }

    public String getLastHttpCallErrorMessage() {
        return this.lastHttpCallErrorMessage;
    }

    public void setLastHttpCallErrorMessage(String lastHttpCallErrorMessage) {
        this.lastHttpCallErrorMessage = lastHttpCallErrorMessage;
    }

    public String getLastHttpCallTime() {
        return this.lastHttpCallTime;
    }

    public void setLastHttpCallTime(String lastHttpCallTime) {
        this.lastHttpCallTime = lastHttpCallTime;
    }

    public Long getLastHttpCallDurationMs() {
        return this.lastHttpCallDurationMs;
    }

    public void setLastHttpCallDurationMs(Long lastHttpCallDurationMs) {
        this.lastHttpCallDurationMs = lastHttpCallDurationMs;
    }

    public String getMostRecentHttpCallSuccessTime() {
        return this.mostRecentHttpCallSuccessTime;
    }

    public void setMostRecentHttpCallSuccessTime(String mostRecentHttpCallSuccessTime) {
        this.mostRecentHttpCallSuccessTime = mostRecentHttpCallSuccessTime;
    }

    public String getConnectionTestEntry() {
        return this.connectionTestEntry;
    }

    public void setConnectionTestEntry(String connectionTestEntry) {
        this.connectionTestEntry = connectionTestEntry;
    }

    public String getSplunkToken() {
        return this.splunkToken;
    }

    public void setSplunkToken(String splunkToken) {
        this.splunkToken = splunkToken;
    }

    public String getAzureOauthClientCredentialsClientSecret() {
        return this.azureOauthClientCredentialsClientSecret;
    }

    public void setAzureOauthClientCredentialsClientSecret(String azureOauthClientCredentialsClientSecret) {
        this.azureOauthClientCredentialsClientSecret = azureOauthClientCredentialsClientSecret;
    }

    public String getQradarPassword() {
        return this.qradarPassword;
    }

    public void setQradarPassword(String qradarPassword) {
        this.qradarPassword = qradarPassword;
    }

    public String getSolarWindsToken() {
        return this.solarWindsToken;
    }

    public void setSolarWindsToken(String solarWindsToken) {
        this.solarWindsToken = solarWindsToken;
    }

    public String getNewRelicApiKey() {
        return this.newRelicApiKey;
    }

    public void setNewRelicApiKey(String newRelicApiKey) {
        this.newRelicApiKey = newRelicApiKey;
    }

    public String getDatadogApiKey() {
        return this.datadogApiKey;
    }

    public void setDatadogApiKey(String datadogApiKey) {
        this.datadogApiKey = datadogApiKey;
    }

    public SiemHttpDestination update(HashMap<String, Object> parameters) throws IOException {
        return SiemHttpDestination.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        SiemHttpDestination.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        SiemHttpDestination.create(parameters, this.options);
    }

    public static ListIterator<SiemHttpDestination> list() throws RuntimeException {
        return SiemHttpDestination.list(null, null);
    }

    public static ListIterator<SiemHttpDestination> list(HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.list(parameters, null);
    }

    public static ListIterator<SiemHttpDestination> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/siem_http_destinations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<SiemHttpDestination>> typeReference = new TypeReference<List<SiemHttpDestination>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<SiemHttpDestination> all() throws RuntimeException {
        return SiemHttpDestination.all(null, null);
    }

    public static ListIterator<SiemHttpDestination> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.list(parameters, options);
    }

    public static SiemHttpDestination find() throws RuntimeException {
        return SiemHttpDestination.find(null, null, null);
    }

    public static SiemHttpDestination find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.find(id, parameters, null);
    }

    public static SiemHttpDestination find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.find(null, parameters, options);
    }

    public static SiemHttpDestination find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/siem_http_destinations/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<SiemHttpDestination> typeReference = new TypeReference<SiemHttpDestination>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static SiemHttpDestination get() throws RuntimeException {
        return SiemHttpDestination.get(null, null, null);
    }

    public static SiemHttpDestination get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.find(id, parameters, options);
    }

    public static SiemHttpDestination create() throws RuntimeException {
        return SiemHttpDestination.create(null, null);
    }

    public static SiemHttpDestination create(HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.create(parameters, null);
    }

    public static SiemHttpDestination create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("destination_type") || parameters.get("destination_type") == null) {
            throw new NullPointerException("Parameter missing: destination_type parameters[\"destination_type\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("additional_headers") && !(parameters.get("additional_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_headers must be of type Map<String, String> parameters[\"additional_headers\"]");
        }
        if (parameters.containsKey("sending_active") && !(parameters.get("sending_active") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sending_active must be of type Boolean parameters[\"sending_active\"]");
        }
        if (parameters.containsKey("generic_payload_type") && !(parameters.get("generic_payload_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generic_payload_type must be of type String parameters[\"generic_payload_type\"]");
        }
        if (parameters.containsKey("file_destination_path") && !(parameters.get("file_destination_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: file_destination_path must be of type String parameters[\"file_destination_path\"]");
        }
        if (parameters.containsKey("file_format") && !(parameters.get("file_format") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: file_format must be of type String parameters[\"file_format\"]");
        }
        if (parameters.containsKey("file_interval_minutes") && !(parameters.get("file_interval_minutes") instanceof Long) && !(parameters.get("file_interval_minutes") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: file_interval_minutes must be of type Long or Integer parameters[\"file_interval_minutes\"]");
        }
        if (parameters.containsKey("splunk_token") && !(parameters.get("splunk_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: splunk_token must be of type String parameters[\"splunk_token\"]");
        }
        if (parameters.containsKey("azure_dcr_immutable_id") && !(parameters.get("azure_dcr_immutable_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_dcr_immutable_id must be of type String parameters[\"azure_dcr_immutable_id\"]");
        }
        if (parameters.containsKey("azure_stream_name") && !(parameters.get("azure_stream_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_stream_name must be of type String parameters[\"azure_stream_name\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_tenant_id") && !(parameters.get("azure_oauth_client_credentials_tenant_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_tenant_id must be of type String parameters[\"azure_oauth_client_credentials_tenant_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_id") && !(parameters.get("azure_oauth_client_credentials_client_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_id must be of type String parameters[\"azure_oauth_client_credentials_client_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_secret") && !(parameters.get("azure_oauth_client_credentials_client_secret") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_secret must be of type String parameters[\"azure_oauth_client_credentials_client_secret\"]");
        }
        if (parameters.containsKey("qradar_username") && !(parameters.get("qradar_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_username must be of type String parameters[\"qradar_username\"]");
        }
        if (parameters.containsKey("qradar_password") && !(parameters.get("qradar_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_password must be of type String parameters[\"qradar_password\"]");
        }
        if (parameters.containsKey("solar_winds_token") && !(parameters.get("solar_winds_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: solar_winds_token must be of type String parameters[\"solar_winds_token\"]");
        }
        if (parameters.containsKey("new_relic_api_key") && !(parameters.get("new_relic_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: new_relic_api_key must be of type String parameters[\"new_relic_api_key\"]");
        }
        if (parameters.containsKey("datadog_api_key") && !(parameters.get("datadog_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: datadog_api_key must be of type String parameters[\"datadog_api_key\"]");
        }
        if (parameters.containsKey("sftp_action_send_enabled") && !(parameters.get("sftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_action_send_enabled must be of type Boolean parameters[\"sftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("ftp_action_send_enabled") && !(parameters.get("ftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_action_send_enabled must be of type Boolean parameters[\"ftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("web_dav_action_send_enabled") && !(parameters.get("web_dav_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: web_dav_action_send_enabled must be of type Boolean parameters[\"web_dav_action_send_enabled\"]");
        }
        if (parameters.containsKey("sync_send_enabled") && !(parameters.get("sync_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sync_send_enabled must be of type Boolean parameters[\"sync_send_enabled\"]");
        }
        if (parameters.containsKey("outbound_connection_send_enabled") && !(parameters.get("outbound_connection_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: outbound_connection_send_enabled must be of type Boolean parameters[\"outbound_connection_send_enabled\"]");
        }
        if (parameters.containsKey("automation_send_enabled") && !(parameters.get("automation_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: automation_send_enabled must be of type Boolean parameters[\"automation_send_enabled\"]");
        }
        if (parameters.containsKey("api_request_send_enabled") && !(parameters.get("api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: api_request_send_enabled must be of type Boolean parameters[\"api_request_send_enabled\"]");
        }
        if (parameters.containsKey("public_hosting_request_send_enabled") && !(parameters.get("public_hosting_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: public_hosting_request_send_enabled must be of type Boolean parameters[\"public_hosting_request_send_enabled\"]");
        }
        if (parameters.containsKey("email_send_enabled") && !(parameters.get("email_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: email_send_enabled must be of type Boolean parameters[\"email_send_enabled\"]");
        }
        if (parameters.containsKey("exavault_api_request_send_enabled") && !(parameters.get("exavault_api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: exavault_api_request_send_enabled must be of type Boolean parameters[\"exavault_api_request_send_enabled\"]");
        }
        if (parameters.containsKey("settings_change_send_enabled") && !(parameters.get("settings_change_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: settings_change_send_enabled must be of type Boolean parameters[\"settings_change_send_enabled\"]");
        }
        if (parameters.containsKey("destination_type") && !(parameters.get("destination_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_type must be of type String parameters[\"destination_type\"]");
        }
        if (parameters.containsKey("destination_url") && !(parameters.get("destination_url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_url must be of type String parameters[\"destination_url\"]");
        }
        String url = String.format("%s%s/siem_http_destinations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<SiemHttpDestination> typeReference = new TypeReference<SiemHttpDestination>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void sendTestEntry() throws RuntimeException {
        SiemHttpDestination.sendTestEntry(null, null);
    }

    public static void sendTestEntry(HashMap<String, Object> parameters) throws RuntimeException {
        SiemHttpDestination.sendTestEntry(parameters, null);
    }

    public static void sendTestEntry(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("siem_http_destination_id") && !(parameters.get("siem_http_destination_id") instanceof Long) && !(parameters.get("siem_http_destination_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: siem_http_destination_id must be of type Long or Integer parameters[\"siem_http_destination_id\"]");
        }
        if (parameters.containsKey("destination_type") && !(parameters.get("destination_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_type must be of type String parameters[\"destination_type\"]");
        }
        if (parameters.containsKey("destination_url") && !(parameters.get("destination_url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_url must be of type String parameters[\"destination_url\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("additional_headers") && !(parameters.get("additional_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_headers must be of type Map<String, String> parameters[\"additional_headers\"]");
        }
        if (parameters.containsKey("sending_active") && !(parameters.get("sending_active") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sending_active must be of type Boolean parameters[\"sending_active\"]");
        }
        if (parameters.containsKey("generic_payload_type") && !(parameters.get("generic_payload_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generic_payload_type must be of type String parameters[\"generic_payload_type\"]");
        }
        if (parameters.containsKey("file_destination_path") && !(parameters.get("file_destination_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: file_destination_path must be of type String parameters[\"file_destination_path\"]");
        }
        if (parameters.containsKey("file_format") && !(parameters.get("file_format") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: file_format must be of type String parameters[\"file_format\"]");
        }
        if (parameters.containsKey("file_interval_minutes") && !(parameters.get("file_interval_minutes") instanceof Long) && !(parameters.get("file_interval_minutes") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: file_interval_minutes must be of type Long or Integer parameters[\"file_interval_minutes\"]");
        }
        if (parameters.containsKey("splunk_token") && !(parameters.get("splunk_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: splunk_token must be of type String parameters[\"splunk_token\"]");
        }
        if (parameters.containsKey("azure_dcr_immutable_id") && !(parameters.get("azure_dcr_immutable_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_dcr_immutable_id must be of type String parameters[\"azure_dcr_immutable_id\"]");
        }
        if (parameters.containsKey("azure_stream_name") && !(parameters.get("azure_stream_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_stream_name must be of type String parameters[\"azure_stream_name\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_tenant_id") && !(parameters.get("azure_oauth_client_credentials_tenant_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_tenant_id must be of type String parameters[\"azure_oauth_client_credentials_tenant_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_id") && !(parameters.get("azure_oauth_client_credentials_client_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_id must be of type String parameters[\"azure_oauth_client_credentials_client_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_secret") && !(parameters.get("azure_oauth_client_credentials_client_secret") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_secret must be of type String parameters[\"azure_oauth_client_credentials_client_secret\"]");
        }
        if (parameters.containsKey("qradar_username") && !(parameters.get("qradar_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_username must be of type String parameters[\"qradar_username\"]");
        }
        if (parameters.containsKey("qradar_password") && !(parameters.get("qradar_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_password must be of type String parameters[\"qradar_password\"]");
        }
        if (parameters.containsKey("solar_winds_token") && !(parameters.get("solar_winds_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: solar_winds_token must be of type String parameters[\"solar_winds_token\"]");
        }
        if (parameters.containsKey("new_relic_api_key") && !(parameters.get("new_relic_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: new_relic_api_key must be of type String parameters[\"new_relic_api_key\"]");
        }
        if (parameters.containsKey("datadog_api_key") && !(parameters.get("datadog_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: datadog_api_key must be of type String parameters[\"datadog_api_key\"]");
        }
        if (parameters.containsKey("sftp_action_send_enabled") && !(parameters.get("sftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_action_send_enabled must be of type Boolean parameters[\"sftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("ftp_action_send_enabled") && !(parameters.get("ftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_action_send_enabled must be of type Boolean parameters[\"ftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("web_dav_action_send_enabled") && !(parameters.get("web_dav_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: web_dav_action_send_enabled must be of type Boolean parameters[\"web_dav_action_send_enabled\"]");
        }
        if (parameters.containsKey("sync_send_enabled") && !(parameters.get("sync_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sync_send_enabled must be of type Boolean parameters[\"sync_send_enabled\"]");
        }
        if (parameters.containsKey("outbound_connection_send_enabled") && !(parameters.get("outbound_connection_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: outbound_connection_send_enabled must be of type Boolean parameters[\"outbound_connection_send_enabled\"]");
        }
        if (parameters.containsKey("automation_send_enabled") && !(parameters.get("automation_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: automation_send_enabled must be of type Boolean parameters[\"automation_send_enabled\"]");
        }
        if (parameters.containsKey("api_request_send_enabled") && !(parameters.get("api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: api_request_send_enabled must be of type Boolean parameters[\"api_request_send_enabled\"]");
        }
        if (parameters.containsKey("public_hosting_request_send_enabled") && !(parameters.get("public_hosting_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: public_hosting_request_send_enabled must be of type Boolean parameters[\"public_hosting_request_send_enabled\"]");
        }
        if (parameters.containsKey("email_send_enabled") && !(parameters.get("email_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: email_send_enabled must be of type Boolean parameters[\"email_send_enabled\"]");
        }
        if (parameters.containsKey("exavault_api_request_send_enabled") && !(parameters.get("exavault_api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: exavault_api_request_send_enabled must be of type Boolean parameters[\"exavault_api_request_send_enabled\"]");
        }
        if (parameters.containsKey("settings_change_send_enabled") && !(parameters.get("settings_change_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: settings_change_send_enabled must be of type Boolean parameters[\"settings_change_send_enabled\"]");
        }
        String url = String.format("%s%s/siem_http_destinations/send_test_entry", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static SiemHttpDestination update() throws RuntimeException {
        return SiemHttpDestination.update(null, null, null);
    }

    public static SiemHttpDestination update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return SiemHttpDestination.update(id, parameters, null);
    }

    public static SiemHttpDestination update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SiemHttpDestination.update(null, parameters, options);
    }

    public static SiemHttpDestination update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("additional_headers") && !(parameters.get("additional_headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: additional_headers must be of type Map<String, String> parameters[\"additional_headers\"]");
        }
        if (parameters.containsKey("sending_active") && !(parameters.get("sending_active") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sending_active must be of type Boolean parameters[\"sending_active\"]");
        }
        if (parameters.containsKey("generic_payload_type") && !(parameters.get("generic_payload_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generic_payload_type must be of type String parameters[\"generic_payload_type\"]");
        }
        if (parameters.containsKey("file_destination_path") && !(parameters.get("file_destination_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: file_destination_path must be of type String parameters[\"file_destination_path\"]");
        }
        if (parameters.containsKey("file_format") && !(parameters.get("file_format") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: file_format must be of type String parameters[\"file_format\"]");
        }
        if (parameters.containsKey("file_interval_minutes") && !(parameters.get("file_interval_minutes") instanceof Long) && !(parameters.get("file_interval_minutes") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: file_interval_minutes must be of type Long or Integer parameters[\"file_interval_minutes\"]");
        }
        if (parameters.containsKey("splunk_token") && !(parameters.get("splunk_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: splunk_token must be of type String parameters[\"splunk_token\"]");
        }
        if (parameters.containsKey("azure_dcr_immutable_id") && !(parameters.get("azure_dcr_immutable_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_dcr_immutable_id must be of type String parameters[\"azure_dcr_immutable_id\"]");
        }
        if (parameters.containsKey("azure_stream_name") && !(parameters.get("azure_stream_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_stream_name must be of type String parameters[\"azure_stream_name\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_tenant_id") && !(parameters.get("azure_oauth_client_credentials_tenant_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_tenant_id must be of type String parameters[\"azure_oauth_client_credentials_tenant_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_id") && !(parameters.get("azure_oauth_client_credentials_client_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_id must be of type String parameters[\"azure_oauth_client_credentials_client_id\"]");
        }
        if (parameters.containsKey("azure_oauth_client_credentials_client_secret") && !(parameters.get("azure_oauth_client_credentials_client_secret") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_oauth_client_credentials_client_secret must be of type String parameters[\"azure_oauth_client_credentials_client_secret\"]");
        }
        if (parameters.containsKey("qradar_username") && !(parameters.get("qradar_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_username must be of type String parameters[\"qradar_username\"]");
        }
        if (parameters.containsKey("qradar_password") && !(parameters.get("qradar_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: qradar_password must be of type String parameters[\"qradar_password\"]");
        }
        if (parameters.containsKey("solar_winds_token") && !(parameters.get("solar_winds_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: solar_winds_token must be of type String parameters[\"solar_winds_token\"]");
        }
        if (parameters.containsKey("new_relic_api_key") && !(parameters.get("new_relic_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: new_relic_api_key must be of type String parameters[\"new_relic_api_key\"]");
        }
        if (parameters.containsKey("datadog_api_key") && !(parameters.get("datadog_api_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: datadog_api_key must be of type String parameters[\"datadog_api_key\"]");
        }
        if (parameters.containsKey("sftp_action_send_enabled") && !(parameters.get("sftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sftp_action_send_enabled must be of type Boolean parameters[\"sftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("ftp_action_send_enabled") && !(parameters.get("ftp_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ftp_action_send_enabled must be of type Boolean parameters[\"ftp_action_send_enabled\"]");
        }
        if (parameters.containsKey("web_dav_action_send_enabled") && !(parameters.get("web_dav_action_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: web_dav_action_send_enabled must be of type Boolean parameters[\"web_dav_action_send_enabled\"]");
        }
        if (parameters.containsKey("sync_send_enabled") && !(parameters.get("sync_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: sync_send_enabled must be of type Boolean parameters[\"sync_send_enabled\"]");
        }
        if (parameters.containsKey("outbound_connection_send_enabled") && !(parameters.get("outbound_connection_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: outbound_connection_send_enabled must be of type Boolean parameters[\"outbound_connection_send_enabled\"]");
        }
        if (parameters.containsKey("automation_send_enabled") && !(parameters.get("automation_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: automation_send_enabled must be of type Boolean parameters[\"automation_send_enabled\"]");
        }
        if (parameters.containsKey("api_request_send_enabled") && !(parameters.get("api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: api_request_send_enabled must be of type Boolean parameters[\"api_request_send_enabled\"]");
        }
        if (parameters.containsKey("public_hosting_request_send_enabled") && !(parameters.get("public_hosting_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: public_hosting_request_send_enabled must be of type Boolean parameters[\"public_hosting_request_send_enabled\"]");
        }
        if (parameters.containsKey("email_send_enabled") && !(parameters.get("email_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: email_send_enabled must be of type Boolean parameters[\"email_send_enabled\"]");
        }
        if (parameters.containsKey("exavault_api_request_send_enabled") && !(parameters.get("exavault_api_request_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: exavault_api_request_send_enabled must be of type Boolean parameters[\"exavault_api_request_send_enabled\"]");
        }
        if (parameters.containsKey("settings_change_send_enabled") && !(parameters.get("settings_change_send_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: settings_change_send_enabled must be of type Boolean parameters[\"settings_change_send_enabled\"]");
        }
        if (parameters.containsKey("destination_type") && !(parameters.get("destination_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_type must be of type String parameters[\"destination_type\"]");
        }
        if (parameters.containsKey("destination_url") && !(parameters.get("destination_url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination_url must be of type String parameters[\"destination_url\"]");
        }
        String url = String.format("%s%s/siem_http_destinations/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<SiemHttpDestination> typeReference = new TypeReference<SiemHttpDestination>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        SiemHttpDestination.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        SiemHttpDestination.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        SiemHttpDestination.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/siem_http_destinations/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        SiemHttpDestination.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        SiemHttpDestination.delete(id, parameters, options);
    }
}

