/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class As2OutgoingMessage
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="as2_partner_id")
    public Long as2PartnerId;
    @JsonProperty(value="as2_station_id")
    public Long as2StationId;
    @JsonProperty(value="uuid")
    public String uuid;
    @JsonProperty(value="http_headers")
    public Map<String, String> httpHeaders;
    @JsonProperty(value="processing_result")
    public String processingResult;
    @JsonProperty(value="processing_result_description")
    public String processingResultDescription;
    @JsonProperty(value="mic")
    public String mic;
    @JsonProperty(value="mic_sha_256")
    public String micSha256;
    @JsonProperty(value="as2_to")
    public String as2To;
    @JsonProperty(value="as2_from")
    public String as2From;
    @JsonProperty(value="date")
    public String date;
    @JsonProperty(value="message_id")
    public String messageId;
    @JsonProperty(value="body_size")
    public String bodySize;
    @JsonProperty(value="attachment_filename")
    public String attachmentFilename;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="http_response_code")
    public String httpResponseCode;
    @JsonProperty(value="http_response_headers")
    public Map<String, String> httpResponseHeaders;
    @JsonProperty(value="http_transmission_duration")
    public Double httpTransmissionDuration;
    @JsonProperty(value="mdn_received")
    public Boolean mdnReceived;
    @JsonProperty(value="mdn_valid")
    public Boolean mdnValid;
    @JsonProperty(value="mdn_signature_verified")
    public Boolean mdnSignatureVerified;
    @JsonProperty(value="mdn_message_id_matched")
    public Boolean mdnMessageIdMatched;
    @JsonProperty(value="mdn_mic_matched")
    public Boolean mdnMicMatched;
    @JsonProperty(value="mdn_processing_success")
    public Boolean mdnProcessingSuccess;
    @JsonProperty(value="raw_uri")
    public String rawUri;
    @JsonProperty(value="smime_uri")
    public String smimeUri;
    @JsonProperty(value="smime_signed_uri")
    public String smimeSignedUri;
    @JsonProperty(value="encrypted_uri")
    public String encryptedUri;
    @JsonProperty(value="mdn_response_uri")
    public String mdnResponseUri;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public As2OutgoingMessage() {
        this(null, null);
    }

    public As2OutgoingMessage(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public As2OutgoingMessage(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getAs2PartnerId() {
        return this.as2PartnerId;
    }

    public Long getAs2StationId() {
        return this.as2StationId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getProcessingResult() {
        return this.processingResult;
    }

    public String getProcessingResultDescription() {
        return this.processingResultDescription;
    }

    public String getMic() {
        return this.mic;
    }

    public String getMicSha256() {
        return this.micSha256;
    }

    public String getAs2To() {
        return this.as2To;
    }

    public String getAs2From() {
        return this.as2From;
    }

    public String getDate() {
        return this.date;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getBodySize() {
        return this.bodySize;
    }

    public String getAttachmentFilename() {
        return this.attachmentFilename;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public Map<String, String> getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    public Double getHttpTransmissionDuration() {
        return this.httpTransmissionDuration;
    }

    public Boolean getMdnReceived() {
        return this.mdnReceived;
    }

    public Boolean getMdnValid() {
        return this.mdnValid;
    }

    public Boolean getMdnSignatureVerified() {
        return this.mdnSignatureVerified;
    }

    public Boolean getMdnMessageIdMatched() {
        return this.mdnMessageIdMatched;
    }

    public Boolean getMdnMicMatched() {
        return this.mdnMicMatched;
    }

    public Boolean getMdnProcessingSuccess() {
        return this.mdnProcessingSuccess;
    }

    public String getRawUri() {
        return this.rawUri;
    }

    public String getSmimeUri() {
        return this.smimeUri;
    }

    public String getSmimeSignedUri() {
        return this.smimeSignedUri;
    }

    public String getEncryptedUri() {
        return this.encryptedUri;
    }

    public String getMdnResponseUri() {
        return this.mdnResponseUri;
    }

    public static ListIterator<As2OutgoingMessage> list() throws RuntimeException {
        return As2OutgoingMessage.list(null, null);
    }

    public static ListIterator<As2OutgoingMessage> list(HashMap<String, Object> parameters) throws RuntimeException {
        return As2OutgoingMessage.list(parameters, null);
    }

    public static ListIterator<As2OutgoingMessage> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        if (parameters.containsKey("as2_partner_id") && !(parameters.get("as2_partner_id") instanceof Long) && !(parameters.get("as2_partner_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: as2_partner_id must be of type Long or Integer parameters[\"as2_partner_id\"]");
        }
        String url = String.format("%s%s/as2_outgoing_messages", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<As2OutgoingMessage>> typeReference = new TypeReference<List<As2OutgoingMessage>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<As2OutgoingMessage> all() throws RuntimeException {
        return As2OutgoingMessage.all(null, null);
    }

    public static ListIterator<As2OutgoingMessage> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2OutgoingMessage.list(parameters, options);
    }
}

