/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.models.RemoteServerConfigurationFile;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RemoteServer
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="disabled")
    public Boolean disabled;
    @JsonProperty(value="authentication_method")
    public String authenticationMethod;
    @JsonProperty(value="hostname")
    public String hostname;
    @JsonProperty(value="remote_home_path")
    public String remoteHomePath;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="description")
    public String description;
    @JsonProperty(value="port")
    public Long port;
    @JsonProperty(value="buffer_uploads")
    public String bufferUploads;
    @JsonProperty(value="max_connections")
    public Long maxConnections;
    @JsonProperty(value="pin_to_site_region")
    public Boolean pinToSiteRegion;
    @JsonProperty(value="pinned_region")
    public String pinnedRegion;
    @JsonProperty(value="s3_bucket")
    public String s3Bucket;
    @JsonProperty(value="s3_region")
    public String s3Region;
    @JsonProperty(value="aws_access_key")
    public String awsAccessKey;
    @JsonProperty(value="server_certificate")
    public String serverCertificate;
    @JsonProperty(value="server_host_key")
    public String serverHostKey;
    @JsonProperty(value="server_type")
    public String serverType;
    @JsonProperty(value="ssl")
    public String ssl;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="google_cloud_storage_bucket")
    public String googleCloudStorageBucket;
    @JsonProperty(value="google_cloud_storage_project_id")
    public String googleCloudStorageProjectId;
    @JsonProperty(value="google_cloud_storage_s3_compatible_access_key")
    public String googleCloudStorageS3CompatibleAccessKey;
    @JsonProperty(value="backblaze_b2_s3_endpoint")
    public String backblazeB2S3Endpoint;
    @JsonProperty(value="backblaze_b2_bucket")
    public String backblazeB2Bucket;
    @JsonProperty(value="wasabi_bucket")
    public String wasabiBucket;
    @JsonProperty(value="wasabi_region")
    public String wasabiRegion;
    @JsonProperty(value="wasabi_access_key")
    public String wasabiAccessKey;
    @JsonProperty(value="auth_status")
    public String authStatus;
    @JsonProperty(value="auth_account_name")
    public String authAccountName;
    @JsonProperty(value="one_drive_account_type")
    public String oneDriveAccountType;
    @JsonProperty(value="azure_blob_storage_account")
    public String azureBlobStorageAccount;
    @JsonProperty(value="azure_blob_storage_container")
    public String azureBlobStorageContainer;
    @JsonProperty(value="azure_blob_storage_hierarchical_namespace")
    public Boolean azureBlobStorageHierarchicalNamespace;
    @JsonProperty(value="azure_blob_storage_dns_suffix")
    public String azureBlobStorageDnsSuffix;
    @JsonProperty(value="azure_files_storage_account")
    public String azureFilesStorageAccount;
    @JsonProperty(value="azure_files_storage_share_name")
    public String azureFilesStorageShareName;
    @JsonProperty(value="azure_files_storage_dns_suffix")
    public String azureFilesStorageDnsSuffix;
    @JsonProperty(value="s3_compatible_bucket")
    public String s3CompatibleBucket;
    @JsonProperty(value="s3_compatible_endpoint")
    public String s3CompatibleEndpoint;
    @JsonProperty(value="s3_compatible_region")
    public String s3CompatibleRegion;
    @JsonProperty(value="s3_compatible_access_key")
    public String s3CompatibleAccessKey;
    @JsonProperty(value="enable_dedicated_ips")
    public Boolean enableDedicatedIps;
    @JsonProperty(value="files_agent_permission_set")
    public String filesAgentPermissionSet;
    @JsonProperty(value="files_agent_root")
    public String filesAgentRoot;
    @JsonProperty(value="files_agent_api_token")
    public String filesAgentApiToken;
    @JsonProperty(value="files_agent_version")
    public String filesAgentVersion;
    @JsonProperty(value="filebase_bucket")
    public String filebaseBucket;
    @JsonProperty(value="filebase_access_key")
    public String filebaseAccessKey;
    @JsonProperty(value="cloudflare_bucket")
    public String cloudflareBucket;
    @JsonProperty(value="cloudflare_access_key")
    public String cloudflareAccessKey;
    @JsonProperty(value="cloudflare_endpoint")
    public String cloudflareEndpoint;
    @JsonProperty(value="dropbox_teams")
    public Boolean dropboxTeams;
    @JsonProperty(value="linode_bucket")
    public String linodeBucket;
    @JsonProperty(value="linode_access_key")
    public String linodeAccessKey;
    @JsonProperty(value="linode_region")
    public String linodeRegion;
    @JsonProperty(value="supports_versioning")
    public Boolean supportsVersioning;
    @JsonProperty(value="password")
    public String password;
    @JsonProperty(value="private_key")
    public String privateKey;
    @JsonProperty(value="private_key_passphrase")
    public String privateKeyPassphrase;
    @JsonProperty(value="reset_authentication")
    public Boolean resetAuthentication;
    @JsonProperty(value="ssl_certificate")
    public String sslCertificate;
    @JsonProperty(value="aws_secret_key")
    public String awsSecretKey;
    @JsonProperty(value="azure_blob_storage_access_key")
    public String azureBlobStorageAccessKey;
    @JsonProperty(value="azure_blob_storage_sas_token")
    public String azureBlobStorageSasToken;
    @JsonProperty(value="azure_files_storage_access_key")
    public String azureFilesStorageAccessKey;
    @JsonProperty(value="azure_files_storage_sas_token")
    public String azureFilesStorageSasToken;
    @JsonProperty(value="backblaze_b2_application_key")
    public String backblazeB2ApplicationKey;
    @JsonProperty(value="backblaze_b2_key_id")
    public String backblazeB2KeyId;
    @JsonProperty(value="cloudflare_secret_key")
    public String cloudflareSecretKey;
    @JsonProperty(value="filebase_secret_key")
    public String filebaseSecretKey;
    @JsonProperty(value="google_cloud_storage_credentials_json")
    public String googleCloudStorageCredentialsJson;
    @JsonProperty(value="google_cloud_storage_s3_compatible_secret_key")
    public String googleCloudStorageS3CompatibleSecretKey;
    @JsonProperty(value="linode_secret_key")
    public String linodeSecretKey;
    @JsonProperty(value="s3_compatible_secret_key")
    public String s3CompatibleSecretKey;
    @JsonProperty(value="wasabi_secret_key")
    public String wasabiSecretKey;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public RemoteServer() {
        this(null, null);
    }

    public RemoteServer(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public RemoteServer(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getRemoteHomePath() {
        return this.remoteHomePath;
    }

    public void setRemoteHomePath(String remoteHomePath) {
        this.remoteHomePath = remoteHomePath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getPort() {
        return this.port;
    }

    public void setPort(Long port) {
        this.port = port;
    }

    public String getBufferUploads() {
        return this.bufferUploads;
    }

    public void setBufferUploads(String bufferUploads) {
        this.bufferUploads = bufferUploads;
    }

    public Long getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Long maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Boolean getPinToSiteRegion() {
        return this.pinToSiteRegion;
    }

    public void setPinToSiteRegion(Boolean pinToSiteRegion) {
        this.pinToSiteRegion = pinToSiteRegion;
    }

    public String getPinnedRegion() {
        return this.pinnedRegion;
    }

    public void setPinnedRegion(String pinnedRegion) {
        this.pinnedRegion = pinnedRegion;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Region() {
        return this.s3Region;
    }

    public void setS3Region(String s3Region) {
        this.s3Region = s3Region;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public String getServerHostKey() {
        return this.serverHostKey;
    }

    public void setServerHostKey(String serverHostKey) {
        this.serverHostKey = serverHostKey;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public String getSsl() {
        return this.ssl;
    }

    public void setSsl(String ssl) {
        this.ssl = ssl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getGoogleCloudStorageBucket() {
        return this.googleCloudStorageBucket;
    }

    public void setGoogleCloudStorageBucket(String googleCloudStorageBucket) {
        this.googleCloudStorageBucket = googleCloudStorageBucket;
    }

    public String getGoogleCloudStorageProjectId() {
        return this.googleCloudStorageProjectId;
    }

    public void setGoogleCloudStorageProjectId(String googleCloudStorageProjectId) {
        this.googleCloudStorageProjectId = googleCloudStorageProjectId;
    }

    public String getGoogleCloudStorageS3CompatibleAccessKey() {
        return this.googleCloudStorageS3CompatibleAccessKey;
    }

    public void setGoogleCloudStorageS3CompatibleAccessKey(String googleCloudStorageS3CompatibleAccessKey) {
        this.googleCloudStorageS3CompatibleAccessKey = googleCloudStorageS3CompatibleAccessKey;
    }

    public String getBackblazeB2S3Endpoint() {
        return this.backblazeB2S3Endpoint;
    }

    public void setBackblazeB2S3Endpoint(String backblazeB2S3Endpoint) {
        this.backblazeB2S3Endpoint = backblazeB2S3Endpoint;
    }

    public String getBackblazeB2Bucket() {
        return this.backblazeB2Bucket;
    }

    public void setBackblazeB2Bucket(String backblazeB2Bucket) {
        this.backblazeB2Bucket = backblazeB2Bucket;
    }

    public String getWasabiBucket() {
        return this.wasabiBucket;
    }

    public void setWasabiBucket(String wasabiBucket) {
        this.wasabiBucket = wasabiBucket;
    }

    public String getWasabiRegion() {
        return this.wasabiRegion;
    }

    public void setWasabiRegion(String wasabiRegion) {
        this.wasabiRegion = wasabiRegion;
    }

    public String getWasabiAccessKey() {
        return this.wasabiAccessKey;
    }

    public void setWasabiAccessKey(String wasabiAccessKey) {
        this.wasabiAccessKey = wasabiAccessKey;
    }

    public String getAuthStatus() {
        return this.authStatus;
    }

    public void setAuthStatus(String authStatus) {
        this.authStatus = authStatus;
    }

    public String getAuthAccountName() {
        return this.authAccountName;
    }

    public void setAuthAccountName(String authAccountName) {
        this.authAccountName = authAccountName;
    }

    public String getOneDriveAccountType() {
        return this.oneDriveAccountType;
    }

    public void setOneDriveAccountType(String oneDriveAccountType) {
        this.oneDriveAccountType = oneDriveAccountType;
    }

    public String getAzureBlobStorageAccount() {
        return this.azureBlobStorageAccount;
    }

    public void setAzureBlobStorageAccount(String azureBlobStorageAccount) {
        this.azureBlobStorageAccount = azureBlobStorageAccount;
    }

    public String getAzureBlobStorageContainer() {
        return this.azureBlobStorageContainer;
    }

    public void setAzureBlobStorageContainer(String azureBlobStorageContainer) {
        this.azureBlobStorageContainer = azureBlobStorageContainer;
    }

    public Boolean getAzureBlobStorageHierarchicalNamespace() {
        return this.azureBlobStorageHierarchicalNamespace;
    }

    public void setAzureBlobStorageHierarchicalNamespace(Boolean azureBlobStorageHierarchicalNamespace) {
        this.azureBlobStorageHierarchicalNamespace = azureBlobStorageHierarchicalNamespace;
    }

    public String getAzureBlobStorageDnsSuffix() {
        return this.azureBlobStorageDnsSuffix;
    }

    public void setAzureBlobStorageDnsSuffix(String azureBlobStorageDnsSuffix) {
        this.azureBlobStorageDnsSuffix = azureBlobStorageDnsSuffix;
    }

    public String getAzureFilesStorageAccount() {
        return this.azureFilesStorageAccount;
    }

    public void setAzureFilesStorageAccount(String azureFilesStorageAccount) {
        this.azureFilesStorageAccount = azureFilesStorageAccount;
    }

    public String getAzureFilesStorageShareName() {
        return this.azureFilesStorageShareName;
    }

    public void setAzureFilesStorageShareName(String azureFilesStorageShareName) {
        this.azureFilesStorageShareName = azureFilesStorageShareName;
    }

    public String getAzureFilesStorageDnsSuffix() {
        return this.azureFilesStorageDnsSuffix;
    }

    public void setAzureFilesStorageDnsSuffix(String azureFilesStorageDnsSuffix) {
        this.azureFilesStorageDnsSuffix = azureFilesStorageDnsSuffix;
    }

    public String getS3CompatibleBucket() {
        return this.s3CompatibleBucket;
    }

    public void setS3CompatibleBucket(String s3CompatibleBucket) {
        this.s3CompatibleBucket = s3CompatibleBucket;
    }

    public String getS3CompatibleEndpoint() {
        return this.s3CompatibleEndpoint;
    }

    public void setS3CompatibleEndpoint(String s3CompatibleEndpoint) {
        this.s3CompatibleEndpoint = s3CompatibleEndpoint;
    }

    public String getS3CompatibleRegion() {
        return this.s3CompatibleRegion;
    }

    public void setS3CompatibleRegion(String s3CompatibleRegion) {
        this.s3CompatibleRegion = s3CompatibleRegion;
    }

    public String getS3CompatibleAccessKey() {
        return this.s3CompatibleAccessKey;
    }

    public void setS3CompatibleAccessKey(String s3CompatibleAccessKey) {
        this.s3CompatibleAccessKey = s3CompatibleAccessKey;
    }

    public Boolean getEnableDedicatedIps() {
        return this.enableDedicatedIps;
    }

    public void setEnableDedicatedIps(Boolean enableDedicatedIps) {
        this.enableDedicatedIps = enableDedicatedIps;
    }

    public String getFilesAgentPermissionSet() {
        return this.filesAgentPermissionSet;
    }

    public void setFilesAgentPermissionSet(String filesAgentPermissionSet) {
        this.filesAgentPermissionSet = filesAgentPermissionSet;
    }

    public String getFilesAgentRoot() {
        return this.filesAgentRoot;
    }

    public void setFilesAgentRoot(String filesAgentRoot) {
        this.filesAgentRoot = filesAgentRoot;
    }

    public String getFilesAgentApiToken() {
        return this.filesAgentApiToken;
    }

    public void setFilesAgentApiToken(String filesAgentApiToken) {
        this.filesAgentApiToken = filesAgentApiToken;
    }

    public String getFilesAgentVersion() {
        return this.filesAgentVersion;
    }

    public void setFilesAgentVersion(String filesAgentVersion) {
        this.filesAgentVersion = filesAgentVersion;
    }

    public String getFilebaseBucket() {
        return this.filebaseBucket;
    }

    public void setFilebaseBucket(String filebaseBucket) {
        this.filebaseBucket = filebaseBucket;
    }

    public String getFilebaseAccessKey() {
        return this.filebaseAccessKey;
    }

    public void setFilebaseAccessKey(String filebaseAccessKey) {
        this.filebaseAccessKey = filebaseAccessKey;
    }

    public String getCloudflareBucket() {
        return this.cloudflareBucket;
    }

    public void setCloudflareBucket(String cloudflareBucket) {
        this.cloudflareBucket = cloudflareBucket;
    }

    public String getCloudflareAccessKey() {
        return this.cloudflareAccessKey;
    }

    public void setCloudflareAccessKey(String cloudflareAccessKey) {
        this.cloudflareAccessKey = cloudflareAccessKey;
    }

    public String getCloudflareEndpoint() {
        return this.cloudflareEndpoint;
    }

    public void setCloudflareEndpoint(String cloudflareEndpoint) {
        this.cloudflareEndpoint = cloudflareEndpoint;
    }

    public Boolean getDropboxTeams() {
        return this.dropboxTeams;
    }

    public void setDropboxTeams(Boolean dropboxTeams) {
        this.dropboxTeams = dropboxTeams;
    }

    public String getLinodeBucket() {
        return this.linodeBucket;
    }

    public void setLinodeBucket(String linodeBucket) {
        this.linodeBucket = linodeBucket;
    }

    public String getLinodeAccessKey() {
        return this.linodeAccessKey;
    }

    public void setLinodeAccessKey(String linodeAccessKey) {
        this.linodeAccessKey = linodeAccessKey;
    }

    public String getLinodeRegion() {
        return this.linodeRegion;
    }

    public void setLinodeRegion(String linodeRegion) {
        this.linodeRegion = linodeRegion;
    }

    public Boolean getSupportsVersioning() {
        return this.supportsVersioning;
    }

    public void setSupportsVersioning(Boolean supportsVersioning) {
        this.supportsVersioning = supportsVersioning;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public Boolean getResetAuthentication() {
        return this.resetAuthentication;
    }

    public void setResetAuthentication(Boolean resetAuthentication) {
        this.resetAuthentication = resetAuthentication;
    }

    public String getSslCertificate() {
        return this.sslCertificate;
    }

    public void setSslCertificate(String sslCertificate) {
        this.sslCertificate = sslCertificate;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getAzureBlobStorageAccessKey() {
        return this.azureBlobStorageAccessKey;
    }

    public void setAzureBlobStorageAccessKey(String azureBlobStorageAccessKey) {
        this.azureBlobStorageAccessKey = azureBlobStorageAccessKey;
    }

    public String getAzureBlobStorageSasToken() {
        return this.azureBlobStorageSasToken;
    }

    public void setAzureBlobStorageSasToken(String azureBlobStorageSasToken) {
        this.azureBlobStorageSasToken = azureBlobStorageSasToken;
    }

    public String getAzureFilesStorageAccessKey() {
        return this.azureFilesStorageAccessKey;
    }

    public void setAzureFilesStorageAccessKey(String azureFilesStorageAccessKey) {
        this.azureFilesStorageAccessKey = azureFilesStorageAccessKey;
    }

    public String getAzureFilesStorageSasToken() {
        return this.azureFilesStorageSasToken;
    }

    public void setAzureFilesStorageSasToken(String azureFilesStorageSasToken) {
        this.azureFilesStorageSasToken = azureFilesStorageSasToken;
    }

    public String getBackblazeB2ApplicationKey() {
        return this.backblazeB2ApplicationKey;
    }

    public void setBackblazeB2ApplicationKey(String backblazeB2ApplicationKey) {
        this.backblazeB2ApplicationKey = backblazeB2ApplicationKey;
    }

    public String getBackblazeB2KeyId() {
        return this.backblazeB2KeyId;
    }

    public void setBackblazeB2KeyId(String backblazeB2KeyId) {
        this.backblazeB2KeyId = backblazeB2KeyId;
    }

    public String getCloudflareSecretKey() {
        return this.cloudflareSecretKey;
    }

    public void setCloudflareSecretKey(String cloudflareSecretKey) {
        this.cloudflareSecretKey = cloudflareSecretKey;
    }

    public String getFilebaseSecretKey() {
        return this.filebaseSecretKey;
    }

    public void setFilebaseSecretKey(String filebaseSecretKey) {
        this.filebaseSecretKey = filebaseSecretKey;
    }

    public String getGoogleCloudStorageCredentialsJson() {
        return this.googleCloudStorageCredentialsJson;
    }

    public void setGoogleCloudStorageCredentialsJson(String googleCloudStorageCredentialsJson) {
        this.googleCloudStorageCredentialsJson = googleCloudStorageCredentialsJson;
    }

    public String getGoogleCloudStorageS3CompatibleSecretKey() {
        return this.googleCloudStorageS3CompatibleSecretKey;
    }

    public void setGoogleCloudStorageS3CompatibleSecretKey(String googleCloudStorageS3CompatibleSecretKey) {
        this.googleCloudStorageS3CompatibleSecretKey = googleCloudStorageS3CompatibleSecretKey;
    }

    public String getLinodeSecretKey() {
        return this.linodeSecretKey;
    }

    public void setLinodeSecretKey(String linodeSecretKey) {
        this.linodeSecretKey = linodeSecretKey;
    }

    public String getS3CompatibleSecretKey() {
        return this.s3CompatibleSecretKey;
    }

    public void setS3CompatibleSecretKey(String s3CompatibleSecretKey) {
        this.s3CompatibleSecretKey = s3CompatibleSecretKey;
    }

    public String getWasabiSecretKey() {
        return this.wasabiSecretKey;
    }

    public void setWasabiSecretKey(String wasabiSecretKey) {
        this.wasabiSecretKey = wasabiSecretKey;
    }

    public RemoteServerConfigurationFile configurationFile(HashMap<String, Object> parameters) throws IOException {
        return RemoteServer.configurationFile(this.id, parameters, this.options);
    }

    public RemoteServer update(HashMap<String, Object> parameters) throws IOException {
        return RemoteServer.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        RemoteServer.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        RemoteServer.create(parameters, this.options);
    }

    public static ListIterator<RemoteServer> list() throws RuntimeException {
        return RemoteServer.list(null, null);
    }

    public static ListIterator<RemoteServer> list(HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteServer.list(parameters, null);
    }

    public static ListIterator<RemoteServer> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/remote_servers", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<RemoteServer>> typeReference = new TypeReference<List<RemoteServer>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<RemoteServer> all() throws RuntimeException {
        return RemoteServer.all(null, null);
    }

    public static ListIterator<RemoteServer> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteServer.list(parameters, options);
    }

    public static RemoteServer find() throws RuntimeException {
        return RemoteServer.find(null, null, null);
    }

    public static RemoteServer find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteServer.find(id, parameters, null);
    }

    public static RemoteServer find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteServer.find(null, parameters, options);
    }

    public static RemoteServer find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/remote_servers/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<RemoteServer> typeReference = new TypeReference<RemoteServer>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static RemoteServer get() throws RuntimeException {
        return RemoteServer.get(null, null, null);
    }

    public static RemoteServer get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteServer.find(id, parameters, options);
    }

    public static RemoteServerConfigurationFile findConfigurationFile() throws RuntimeException {
        return RemoteServer.findConfigurationFile(null, null, null);
    }

    public static RemoteServerConfigurationFile findConfigurationFile(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteServer.findConfigurationFile(id, parameters, null);
    }

    public static RemoteServerConfigurationFile findConfigurationFile(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteServer.findConfigurationFile(null, parameters, options);
    }

    public static RemoteServerConfigurationFile findConfigurationFile(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/remote_servers/%s/configuration_file", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<RemoteServerConfigurationFile> typeReference = new TypeReference<RemoteServerConfigurationFile>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static RemoteServer create() throws RuntimeException {
        return RemoteServer.create(null, null);
    }

    public static RemoteServer create(HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteServer.create(parameters, null);
    }

    public static RemoteServer create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("password") && !(parameters.get("password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password must be of type String parameters[\"password\"]");
        }
        if (parameters.containsKey("private_key") && !(parameters.get("private_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key must be of type String parameters[\"private_key\"]");
        }
        if (parameters.containsKey("private_key_passphrase") && !(parameters.get("private_key_passphrase") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key_passphrase must be of type String parameters[\"private_key_passphrase\"]");
        }
        if (parameters.containsKey("reset_authentication") && !(parameters.get("reset_authentication") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: reset_authentication must be of type Boolean parameters[\"reset_authentication\"]");
        }
        if (parameters.containsKey("ssl_certificate") && !(parameters.get("ssl_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ssl_certificate must be of type String parameters[\"ssl_certificate\"]");
        }
        if (parameters.containsKey("aws_secret_key") && !(parameters.get("aws_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: aws_secret_key must be of type String parameters[\"aws_secret_key\"]");
        }
        if (parameters.containsKey("azure_blob_storage_access_key") && !(parameters.get("azure_blob_storage_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_access_key must be of type String parameters[\"azure_blob_storage_access_key\"]");
        }
        if (parameters.containsKey("azure_blob_storage_sas_token") && !(parameters.get("azure_blob_storage_sas_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_sas_token must be of type String parameters[\"azure_blob_storage_sas_token\"]");
        }
        if (parameters.containsKey("azure_files_storage_access_key") && !(parameters.get("azure_files_storage_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_access_key must be of type String parameters[\"azure_files_storage_access_key\"]");
        }
        if (parameters.containsKey("azure_files_storage_sas_token") && !(parameters.get("azure_files_storage_sas_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_sas_token must be of type String parameters[\"azure_files_storage_sas_token\"]");
        }
        if (parameters.containsKey("backblaze_b2_application_key") && !(parameters.get("backblaze_b2_application_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_application_key must be of type String parameters[\"backblaze_b2_application_key\"]");
        }
        if (parameters.containsKey("backblaze_b2_key_id") && !(parameters.get("backblaze_b2_key_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_key_id must be of type String parameters[\"backblaze_b2_key_id\"]");
        }
        if (parameters.containsKey("cloudflare_secret_key") && !(parameters.get("cloudflare_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_secret_key must be of type String parameters[\"cloudflare_secret_key\"]");
        }
        if (parameters.containsKey("filebase_secret_key") && !(parameters.get("filebase_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: filebase_secret_key must be of type String parameters[\"filebase_secret_key\"]");
        }
        if (parameters.containsKey("google_cloud_storage_credentials_json") && !(parameters.get("google_cloud_storage_credentials_json") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_credentials_json must be of type String parameters[\"google_cloud_storage_credentials_json\"]");
        }
        if (parameters.containsKey("google_cloud_storage_s3_compatible_secret_key") && !(parameters.get("google_cloud_storage_s3_compatible_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_s3_compatible_secret_key must be of type String parameters[\"google_cloud_storage_s3_compatible_secret_key\"]");
        }
        if (parameters.containsKey("linode_secret_key") && !(parameters.get("linode_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_secret_key must be of type String parameters[\"linode_secret_key\"]");
        }
        if (parameters.containsKey("s3_compatible_secret_key") && !(parameters.get("s3_compatible_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_secret_key must be of type String parameters[\"s3_compatible_secret_key\"]");
        }
        if (parameters.containsKey("wasabi_secret_key") && !(parameters.get("wasabi_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_secret_key must be of type String parameters[\"wasabi_secret_key\"]");
        }
        if (parameters.containsKey("aws_access_key") && !(parameters.get("aws_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: aws_access_key must be of type String parameters[\"aws_access_key\"]");
        }
        if (parameters.containsKey("azure_blob_storage_account") && !(parameters.get("azure_blob_storage_account") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_account must be of type String parameters[\"azure_blob_storage_account\"]");
        }
        if (parameters.containsKey("azure_blob_storage_container") && !(parameters.get("azure_blob_storage_container") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_container must be of type String parameters[\"azure_blob_storage_container\"]");
        }
        if (parameters.containsKey("azure_blob_storage_dns_suffix") && !(parameters.get("azure_blob_storage_dns_suffix") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_dns_suffix must be of type String parameters[\"azure_blob_storage_dns_suffix\"]");
        }
        if (parameters.containsKey("azure_blob_storage_hierarchical_namespace") && !(parameters.get("azure_blob_storage_hierarchical_namespace") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_hierarchical_namespace must be of type Boolean parameters[\"azure_blob_storage_hierarchical_namespace\"]");
        }
        if (parameters.containsKey("azure_files_storage_account") && !(parameters.get("azure_files_storage_account") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_account must be of type String parameters[\"azure_files_storage_account\"]");
        }
        if (parameters.containsKey("azure_files_storage_dns_suffix") && !(parameters.get("azure_files_storage_dns_suffix") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_dns_suffix must be of type String parameters[\"azure_files_storage_dns_suffix\"]");
        }
        if (parameters.containsKey("azure_files_storage_share_name") && !(parameters.get("azure_files_storage_share_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_share_name must be of type String parameters[\"azure_files_storage_share_name\"]");
        }
        if (parameters.containsKey("backblaze_b2_bucket") && !(parameters.get("backblaze_b2_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_bucket must be of type String parameters[\"backblaze_b2_bucket\"]");
        }
        if (parameters.containsKey("backblaze_b2_s3_endpoint") && !(parameters.get("backblaze_b2_s3_endpoint") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_s3_endpoint must be of type String parameters[\"backblaze_b2_s3_endpoint\"]");
        }
        if (parameters.containsKey("buffer_uploads") && !(parameters.get("buffer_uploads") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: buffer_uploads must be of type String parameters[\"buffer_uploads\"]");
        }
        if (parameters.containsKey("cloudflare_access_key") && !(parameters.get("cloudflare_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_access_key must be of type String parameters[\"cloudflare_access_key\"]");
        }
        if (parameters.containsKey("cloudflare_bucket") && !(parameters.get("cloudflare_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_bucket must be of type String parameters[\"cloudflare_bucket\"]");
        }
        if (parameters.containsKey("cloudflare_endpoint") && !(parameters.get("cloudflare_endpoint") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_endpoint must be of type String parameters[\"cloudflare_endpoint\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("dropbox_teams") && !(parameters.get("dropbox_teams") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: dropbox_teams must be of type Boolean parameters[\"dropbox_teams\"]");
        }
        if (parameters.containsKey("enable_dedicated_ips") && !(parameters.get("enable_dedicated_ips") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: enable_dedicated_ips must be of type Boolean parameters[\"enable_dedicated_ips\"]");
        }
        if (parameters.containsKey("filebase_access_key") && !(parameters.get("filebase_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: filebase_access_key must be of type String parameters[\"filebase_access_key\"]");
        }
        if (parameters.containsKey("filebase_bucket") && !(parameters.get("filebase_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: filebase_bucket must be of type String parameters[\"filebase_bucket\"]");
        }
        if (parameters.containsKey("files_agent_permission_set") && !(parameters.get("files_agent_permission_set") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: files_agent_permission_set must be of type String parameters[\"files_agent_permission_set\"]");
        }
        if (parameters.containsKey("files_agent_root") && !(parameters.get("files_agent_root") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: files_agent_root must be of type String parameters[\"files_agent_root\"]");
        }
        if (parameters.containsKey("files_agent_version") && !(parameters.get("files_agent_version") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: files_agent_version must be of type String parameters[\"files_agent_version\"]");
        }
        if (parameters.containsKey("google_cloud_storage_bucket") && !(parameters.get("google_cloud_storage_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_bucket must be of type String parameters[\"google_cloud_storage_bucket\"]");
        }
        if (parameters.containsKey("google_cloud_storage_project_id") && !(parameters.get("google_cloud_storage_project_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_project_id must be of type String parameters[\"google_cloud_storage_project_id\"]");
        }
        if (parameters.containsKey("google_cloud_storage_s3_compatible_access_key") && !(parameters.get("google_cloud_storage_s3_compatible_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_s3_compatible_access_key must be of type String parameters[\"google_cloud_storage_s3_compatible_access_key\"]");
        }
        if (parameters.containsKey("hostname") && !(parameters.get("hostname") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: hostname must be of type String parameters[\"hostname\"]");
        }
        if (parameters.containsKey("linode_access_key") && !(parameters.get("linode_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_access_key must be of type String parameters[\"linode_access_key\"]");
        }
        if (parameters.containsKey("linode_bucket") && !(parameters.get("linode_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_bucket must be of type String parameters[\"linode_bucket\"]");
        }
        if (parameters.containsKey("linode_region") && !(parameters.get("linode_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_region must be of type String parameters[\"linode_region\"]");
        }
        if (parameters.containsKey("max_connections") && !(parameters.get("max_connections") instanceof Long) && !(parameters.get("max_connections") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: max_connections must be of type Long or Integer parameters[\"max_connections\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("one_drive_account_type") && !(parameters.get("one_drive_account_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: one_drive_account_type must be of type String parameters[\"one_drive_account_type\"]");
        }
        if (parameters.containsKey("pin_to_site_region") && !(parameters.get("pin_to_site_region") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: pin_to_site_region must be of type Boolean parameters[\"pin_to_site_region\"]");
        }
        if (parameters.containsKey("port") && !(parameters.get("port") instanceof Long) && !(parameters.get("port") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: port must be of type Long or Integer parameters[\"port\"]");
        }
        if (parameters.containsKey("s3_bucket") && !(parameters.get("s3_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_bucket must be of type String parameters[\"s3_bucket\"]");
        }
        if (parameters.containsKey("s3_compatible_access_key") && !(parameters.get("s3_compatible_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_access_key must be of type String parameters[\"s3_compatible_access_key\"]");
        }
        if (parameters.containsKey("s3_compatible_bucket") && !(parameters.get("s3_compatible_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_bucket must be of type String parameters[\"s3_compatible_bucket\"]");
        }
        if (parameters.containsKey("s3_compatible_endpoint") && !(parameters.get("s3_compatible_endpoint") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_endpoint must be of type String parameters[\"s3_compatible_endpoint\"]");
        }
        if (parameters.containsKey("s3_compatible_region") && !(parameters.get("s3_compatible_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_region must be of type String parameters[\"s3_compatible_region\"]");
        }
        if (parameters.containsKey("s3_region") && !(parameters.get("s3_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_region must be of type String parameters[\"s3_region\"]");
        }
        if (parameters.containsKey("server_certificate") && !(parameters.get("server_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_certificate must be of type String parameters[\"server_certificate\"]");
        }
        if (parameters.containsKey("server_host_key") && !(parameters.get("server_host_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_host_key must be of type String parameters[\"server_host_key\"]");
        }
        if (parameters.containsKey("server_type") && !(parameters.get("server_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_type must be of type String parameters[\"server_type\"]");
        }
        if (parameters.containsKey("ssl") && !(parameters.get("ssl") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ssl must be of type String parameters[\"ssl\"]");
        }
        if (parameters.containsKey("username") && !(parameters.get("username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: username must be of type String parameters[\"username\"]");
        }
        if (parameters.containsKey("wasabi_access_key") && !(parameters.get("wasabi_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_access_key must be of type String parameters[\"wasabi_access_key\"]");
        }
        if (parameters.containsKey("wasabi_bucket") && !(parameters.get("wasabi_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_bucket must be of type String parameters[\"wasabi_bucket\"]");
        }
        if (parameters.containsKey("wasabi_region") && !(parameters.get("wasabi_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_region must be of type String parameters[\"wasabi_region\"]");
        }
        String url = String.format("%s%s/remote_servers", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<RemoteServer> typeReference = new TypeReference<RemoteServer>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static RemoteServerConfigurationFile configurationFile() throws RuntimeException {
        return RemoteServer.configurationFile(null, null, null);
    }

    public static RemoteServerConfigurationFile configurationFile(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteServer.configurationFile(id, parameters, null);
    }

    public static RemoteServerConfigurationFile configurationFile(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteServer.configurationFile(null, parameters, options);
    }

    public static RemoteServerConfigurationFile configurationFile(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("api_token") && !(parameters.get("api_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: api_token must be of type String parameters[\"api_token\"]");
        }
        if (parameters.containsKey("permission_set") && !(parameters.get("permission_set") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: permission_set must be of type String parameters[\"permission_set\"]");
        }
        if (parameters.containsKey("root") && !(parameters.get("root") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: root must be of type String parameters[\"root\"]");
        }
        if (parameters.containsKey("hostname") && !(parameters.get("hostname") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: hostname must be of type String parameters[\"hostname\"]");
        }
        if (parameters.containsKey("port") && !(parameters.get("port") instanceof Long) && !(parameters.get("port") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: port must be of type Long or Integer parameters[\"port\"]");
        }
        if (parameters.containsKey("status") && !(parameters.get("status") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: status must be of type String parameters[\"status\"]");
        }
        if (parameters.containsKey("config_version") && !(parameters.get("config_version") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: config_version must be of type String parameters[\"config_version\"]");
        }
        if (parameters.containsKey("private_key") && !(parameters.get("private_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key must be of type String parameters[\"private_key\"]");
        }
        if (parameters.containsKey("public_key") && !(parameters.get("public_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: public_key must be of type String parameters[\"public_key\"]");
        }
        if (parameters.containsKey("server_host_key") && !(parameters.get("server_host_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_host_key must be of type String parameters[\"server_host_key\"]");
        }
        if (parameters.containsKey("subdomain") && !(parameters.get("subdomain") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: subdomain must be of type String parameters[\"subdomain\"]");
        }
        String url = String.format("%s%s/remote_servers/%s/configuration_file", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<RemoteServerConfigurationFile> typeReference = new TypeReference<RemoteServerConfigurationFile>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static RemoteServer update() throws RuntimeException {
        return RemoteServer.update(null, null, null);
    }

    public static RemoteServer update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteServer.update(id, parameters, null);
    }

    public static RemoteServer update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteServer.update(null, parameters, options);
    }

    public static RemoteServer update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("password") && !(parameters.get("password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password must be of type String parameters[\"password\"]");
        }
        if (parameters.containsKey("private_key") && !(parameters.get("private_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key must be of type String parameters[\"private_key\"]");
        }
        if (parameters.containsKey("private_key_passphrase") && !(parameters.get("private_key_passphrase") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key_passphrase must be of type String parameters[\"private_key_passphrase\"]");
        }
        if (parameters.containsKey("reset_authentication") && !(parameters.get("reset_authentication") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: reset_authentication must be of type Boolean parameters[\"reset_authentication\"]");
        }
        if (parameters.containsKey("ssl_certificate") && !(parameters.get("ssl_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ssl_certificate must be of type String parameters[\"ssl_certificate\"]");
        }
        if (parameters.containsKey("aws_secret_key") && !(parameters.get("aws_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: aws_secret_key must be of type String parameters[\"aws_secret_key\"]");
        }
        if (parameters.containsKey("azure_blob_storage_access_key") && !(parameters.get("azure_blob_storage_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_access_key must be of type String parameters[\"azure_blob_storage_access_key\"]");
        }
        if (parameters.containsKey("azure_blob_storage_sas_token") && !(parameters.get("azure_blob_storage_sas_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_sas_token must be of type String parameters[\"azure_blob_storage_sas_token\"]");
        }
        if (parameters.containsKey("azure_files_storage_access_key") && !(parameters.get("azure_files_storage_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_access_key must be of type String parameters[\"azure_files_storage_access_key\"]");
        }
        if (parameters.containsKey("azure_files_storage_sas_token") && !(parameters.get("azure_files_storage_sas_token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_sas_token must be of type String parameters[\"azure_files_storage_sas_token\"]");
        }
        if (parameters.containsKey("backblaze_b2_application_key") && !(parameters.get("backblaze_b2_application_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_application_key must be of type String parameters[\"backblaze_b2_application_key\"]");
        }
        if (parameters.containsKey("backblaze_b2_key_id") && !(parameters.get("backblaze_b2_key_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_key_id must be of type String parameters[\"backblaze_b2_key_id\"]");
        }
        if (parameters.containsKey("cloudflare_secret_key") && !(parameters.get("cloudflare_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_secret_key must be of type String parameters[\"cloudflare_secret_key\"]");
        }
        if (parameters.containsKey("filebase_secret_key") && !(parameters.get("filebase_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: filebase_secret_key must be of type String parameters[\"filebase_secret_key\"]");
        }
        if (parameters.containsKey("google_cloud_storage_credentials_json") && !(parameters.get("google_cloud_storage_credentials_json") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_credentials_json must be of type String parameters[\"google_cloud_storage_credentials_json\"]");
        }
        if (parameters.containsKey("google_cloud_storage_s3_compatible_secret_key") && !(parameters.get("google_cloud_storage_s3_compatible_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_s3_compatible_secret_key must be of type String parameters[\"google_cloud_storage_s3_compatible_secret_key\"]");
        }
        if (parameters.containsKey("linode_secret_key") && !(parameters.get("linode_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_secret_key must be of type String parameters[\"linode_secret_key\"]");
        }
        if (parameters.containsKey("s3_compatible_secret_key") && !(parameters.get("s3_compatible_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_secret_key must be of type String parameters[\"s3_compatible_secret_key\"]");
        }
        if (parameters.containsKey("wasabi_secret_key") && !(parameters.get("wasabi_secret_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_secret_key must be of type String parameters[\"wasabi_secret_key\"]");
        }
        if (parameters.containsKey("aws_access_key") && !(parameters.get("aws_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: aws_access_key must be of type String parameters[\"aws_access_key\"]");
        }
        if (parameters.containsKey("azure_blob_storage_account") && !(parameters.get("azure_blob_storage_account") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_account must be of type String parameters[\"azure_blob_storage_account\"]");
        }
        if (parameters.containsKey("azure_blob_storage_container") && !(parameters.get("azure_blob_storage_container") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_container must be of type String parameters[\"azure_blob_storage_container\"]");
        }
        if (parameters.containsKey("azure_blob_storage_dns_suffix") && !(parameters.get("azure_blob_storage_dns_suffix") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_dns_suffix must be of type String parameters[\"azure_blob_storage_dns_suffix\"]");
        }
        if (parameters.containsKey("azure_blob_storage_hierarchical_namespace") && !(parameters.get("azure_blob_storage_hierarchical_namespace") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: azure_blob_storage_hierarchical_namespace must be of type Boolean parameters[\"azure_blob_storage_hierarchical_namespace\"]");
        }
        if (parameters.containsKey("azure_files_storage_account") && !(parameters.get("azure_files_storage_account") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_account must be of type String parameters[\"azure_files_storage_account\"]");
        }
        if (parameters.containsKey("azure_files_storage_dns_suffix") && !(parameters.get("azure_files_storage_dns_suffix") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_dns_suffix must be of type String parameters[\"azure_files_storage_dns_suffix\"]");
        }
        if (parameters.containsKey("azure_files_storage_share_name") && !(parameters.get("azure_files_storage_share_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: azure_files_storage_share_name must be of type String parameters[\"azure_files_storage_share_name\"]");
        }
        if (parameters.containsKey("backblaze_b2_bucket") && !(parameters.get("backblaze_b2_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_bucket must be of type String parameters[\"backblaze_b2_bucket\"]");
        }
        if (parameters.containsKey("backblaze_b2_s3_endpoint") && !(parameters.get("backblaze_b2_s3_endpoint") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: backblaze_b2_s3_endpoint must be of type String parameters[\"backblaze_b2_s3_endpoint\"]");
        }
        if (parameters.containsKey("buffer_uploads") && !(parameters.get("buffer_uploads") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: buffer_uploads must be of type String parameters[\"buffer_uploads\"]");
        }
        if (parameters.containsKey("cloudflare_access_key") && !(parameters.get("cloudflare_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_access_key must be of type String parameters[\"cloudflare_access_key\"]");
        }
        if (parameters.containsKey("cloudflare_bucket") && !(parameters.get("cloudflare_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_bucket must be of type String parameters[\"cloudflare_bucket\"]");
        }
        if (parameters.containsKey("cloudflare_endpoint") && !(parameters.get("cloudflare_endpoint") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cloudflare_endpoint must be of type String parameters[\"cloudflare_endpoint\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("dropbox_teams") && !(parameters.get("dropbox_teams") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: dropbox_teams must be of type Boolean parameters[\"dropbox_teams\"]");
        }
        if (parameters.containsKey("enable_dedicated_ips") && !(parameters.get("enable_dedicated_ips") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: enable_dedicated_ips must be of type Boolean parameters[\"enable_dedicated_ips\"]");
        }
        if (parameters.containsKey("filebase_access_key") && !(parameters.get("filebase_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: filebase_access_key must be of type String parameters[\"filebase_access_key\"]");
        }
        if (parameters.containsKey("filebase_bucket") && !(parameters.get("filebase_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: filebase_bucket must be of type String parameters[\"filebase_bucket\"]");
        }
        if (parameters.containsKey("files_agent_permission_set") && !(parameters.get("files_agent_permission_set") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: files_agent_permission_set must be of type String parameters[\"files_agent_permission_set\"]");
        }
        if (parameters.containsKey("files_agent_root") && !(parameters.get("files_agent_root") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: files_agent_root must be of type String parameters[\"files_agent_root\"]");
        }
        if (parameters.containsKey("files_agent_version") && !(parameters.get("files_agent_version") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: files_agent_version must be of type String parameters[\"files_agent_version\"]");
        }
        if (parameters.containsKey("google_cloud_storage_bucket") && !(parameters.get("google_cloud_storage_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_bucket must be of type String parameters[\"google_cloud_storage_bucket\"]");
        }
        if (parameters.containsKey("google_cloud_storage_project_id") && !(parameters.get("google_cloud_storage_project_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_project_id must be of type String parameters[\"google_cloud_storage_project_id\"]");
        }
        if (parameters.containsKey("google_cloud_storage_s3_compatible_access_key") && !(parameters.get("google_cloud_storage_s3_compatible_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: google_cloud_storage_s3_compatible_access_key must be of type String parameters[\"google_cloud_storage_s3_compatible_access_key\"]");
        }
        if (parameters.containsKey("hostname") && !(parameters.get("hostname") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: hostname must be of type String parameters[\"hostname\"]");
        }
        if (parameters.containsKey("linode_access_key") && !(parameters.get("linode_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_access_key must be of type String parameters[\"linode_access_key\"]");
        }
        if (parameters.containsKey("linode_bucket") && !(parameters.get("linode_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_bucket must be of type String parameters[\"linode_bucket\"]");
        }
        if (parameters.containsKey("linode_region") && !(parameters.get("linode_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: linode_region must be of type String parameters[\"linode_region\"]");
        }
        if (parameters.containsKey("max_connections") && !(parameters.get("max_connections") instanceof Long) && !(parameters.get("max_connections") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: max_connections must be of type Long or Integer parameters[\"max_connections\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("one_drive_account_type") && !(parameters.get("one_drive_account_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: one_drive_account_type must be of type String parameters[\"one_drive_account_type\"]");
        }
        if (parameters.containsKey("pin_to_site_region") && !(parameters.get("pin_to_site_region") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: pin_to_site_region must be of type Boolean parameters[\"pin_to_site_region\"]");
        }
        if (parameters.containsKey("port") && !(parameters.get("port") instanceof Long) && !(parameters.get("port") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: port must be of type Long or Integer parameters[\"port\"]");
        }
        if (parameters.containsKey("s3_bucket") && !(parameters.get("s3_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_bucket must be of type String parameters[\"s3_bucket\"]");
        }
        if (parameters.containsKey("s3_compatible_access_key") && !(parameters.get("s3_compatible_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_access_key must be of type String parameters[\"s3_compatible_access_key\"]");
        }
        if (parameters.containsKey("s3_compatible_bucket") && !(parameters.get("s3_compatible_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_bucket must be of type String parameters[\"s3_compatible_bucket\"]");
        }
        if (parameters.containsKey("s3_compatible_endpoint") && !(parameters.get("s3_compatible_endpoint") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_endpoint must be of type String parameters[\"s3_compatible_endpoint\"]");
        }
        if (parameters.containsKey("s3_compatible_region") && !(parameters.get("s3_compatible_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_compatible_region must be of type String parameters[\"s3_compatible_region\"]");
        }
        if (parameters.containsKey("s3_region") && !(parameters.get("s3_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: s3_region must be of type String parameters[\"s3_region\"]");
        }
        if (parameters.containsKey("server_certificate") && !(parameters.get("server_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_certificate must be of type String parameters[\"server_certificate\"]");
        }
        if (parameters.containsKey("server_host_key") && !(parameters.get("server_host_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_host_key must be of type String parameters[\"server_host_key\"]");
        }
        if (parameters.containsKey("server_type") && !(parameters.get("server_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: server_type must be of type String parameters[\"server_type\"]");
        }
        if (parameters.containsKey("ssl") && !(parameters.get("ssl") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: ssl must be of type String parameters[\"ssl\"]");
        }
        if (parameters.containsKey("username") && !(parameters.get("username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: username must be of type String parameters[\"username\"]");
        }
        if (parameters.containsKey("wasabi_access_key") && !(parameters.get("wasabi_access_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_access_key must be of type String parameters[\"wasabi_access_key\"]");
        }
        if (parameters.containsKey("wasabi_bucket") && !(parameters.get("wasabi_bucket") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_bucket must be of type String parameters[\"wasabi_bucket\"]");
        }
        if (parameters.containsKey("wasabi_region") && !(parameters.get("wasabi_region") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: wasabi_region must be of type String parameters[\"wasabi_region\"]");
        }
        String url = String.format("%s%s/remote_servers/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<RemoteServer> typeReference = new TypeReference<RemoteServer>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        RemoteServer.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        RemoteServer.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        RemoteServer.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/remote_servers/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        RemoteServer.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        RemoteServer.delete(id, parameters, options);
    }
}

