/*
 * Decompiled with CFR 0.152.
 */
package com.files.util;

import com.files.util.BufferPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.IntConsumer;

public class StreamTransfer {
    private static final int INITIAL_BUFFER_SIZE = Math.min(8192, BufferPool.T_BUFFER_SIZE);

    private StreamTransfer() {
    }

    public static long smartCopy(long knownSize, InputStream in, OutputStream out) throws IOException {
        return StreamTransfer.smartCopy(knownSize, in, out, null);
    }

    public static long smartCopy(long knownSize, InputStream in, OutputStream out, IntConsumer progressConsumer) throws IOException {
        return StreamTransfer.bufferedCopy(knownSize, in, out, progressConsumer);
    }

    public static long bufferedCopy(long knownSize, InputStream in, OutputStream out, IntConsumer progressConsumer) throws IOException {
        long total = 0L;
        try (BufferPool.Buffer b = BufferPool.needBuffer(INITIAL_BUFFER_SIZE);){
            int c;
            byte[] buffer = b.getBuffer();
            long remaining = Long.MAX_VALUE;
            while ((knownSize < 1L || (remaining = knownSize - total) > 0L) && (c = in.read(buffer, 0, (int)Math.min(remaining, (long)INITIAL_BUFFER_SIZE))) >= 0) {
                if (c > 0) {
                    out.write(buffer, 0, c);
                    total += (long)c;
                    if (progressConsumer == null) continue;
                    progressConsumer.accept(c);
                    continue;
                }
                Thread.yield();
            }
        }
        return total;
    }
}

