/*
 * Decompiled with CFR 0.152.
 */
package com.files;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesConfig {
    private static final Logger log = LoggerFactory.getLogger(FilesConfig.class);
    private static volatile FilesConfig instance;
    private final Properties properties = new Properties();

    protected FilesConfig() {
        try (InputStream file = FilesConfig.class.getResourceAsStream("/files-sdk.properties");){
            this.properties.load(file);
        }
        catch (IOException e) {
            log.warn("could not load configurator properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilesConfig getInstance() {
        if (instance != null) return instance;
        Class<FilesConfig> clazz = FilesConfig.class;
        synchronized (FilesConfig.class) {
            if (instance != null) return instance;
            instance = new FilesConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private int intProperty(String key, int defaultValue) {
        String strValue = this.properties.getProperty(key);
        if (this.isNullOrEmpty(strValue)) {
            return defaultValue;
        }
        return Integer.valueOf(strValue);
    }

    private boolean boolProperty(String key, boolean defaultValue) {
        String strValue = this.properties.getProperty(key);
        if (this.isNullOrEmpty(strValue)) {
            return defaultValue;
        }
        return Boolean.valueOf(strValue);
    }

    public boolean getAllowInsecureBackend(String def) {
        return this.boolProperty("allowInsecureBackend", false);
    }

    public String getApiBase() {
        return this.properties.getProperty("apiBase", String.format("/api/rest/v1", new Object[0]));
    }

    public String getApiRoot() {
        return this.properties.getProperty("apiRoot", "https://app.files.com");
    }

    public String getApiKey() {
        return this.properties.getProperty("apiKey", null);
    }

    public int getCachedBufferTinySize() {
        return this.intProperty("cachedBufferTinySize", 16384);
    }

    public int getCachedBufferSmallSize() {
        return this.intProperty("cachedBufferSmallSize", 0x100000);
    }

    public int getCachedBufferMediumSize() {
        return this.intProperty("cachedBufferMediumSize", 0x1000000);
    }

    public int getCachedBufferLargeSize() {
        return this.intProperty("cachedBufferLargeSize", 0x3000000);
    }

    public int getCachedBufferMaxBytes() {
        return this.intProperty("cachedBufferMaxBytes", (int)Math.min(Runtime.getRuntime().maxMemory() / 5L, 0x60000000L));
    }

    public boolean getHttpLoggingEnabled() {
        return this.boolProperty("httpLoggingEnabled", true);
    }

    public int getInitialRetryDelayMillis() {
        return this.intProperty("initialRetryDelayMillis", 500);
    }

    public int getMaximumRetrySeconds() {
        return this.intProperty("maximumRetrySeconds", 10);
    }

    public String getSdkVersion() {
        return this.properties.getProperty("sdkVersion", "0.0.1");
    }

    public String getUserAgent() {
        String defaultUserAgent = String.format("Files.com Java SDK v%s", this.getSdkVersion());
        return this.properties.getProperty("userAgent", defaultUserAgent);
    }

    public boolean getUpstreamHttp2Enabled() {
        return this.boolProperty("upstreamHttp2Enabled", true);
    }

    public boolean getUpstreamInsecureAllowed() {
        return this.boolProperty("upstreamInsecureAllowed", false);
    }

    public int getUpstreamMaxAttempts() {
        return this.intProperty("upstreamMaxAttempts", 5);
    }

    public int getUpstreamMaxConnections() {
        return this.intProperty("upstreamMaxConnections", 500);
    }

    public int getUpstreamTimeout() {
        return this.intProperty("upstreamTimeout", 5000);
    }

    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    private boolean isNullOrEmpty(String input) {
        return input == null || input.isEmpty();
    }
}

