/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.BundleRegistration;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BundleAction
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="bundle_registration")
    public BundleRegistration bundleRegistration;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="destination")
    public String destination;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="source")
    public String source;
    @JsonProperty(value="bundle_registration_id")
    public Long bundleRegistrationId;
    @JsonProperty(value="bundle_registration_name")
    public String bundleRegistrationName;
    @JsonProperty(value="bundle_registration_email")
    public String bundleRegistrationEmail;
    @JsonProperty(value="bundle_registration_ip")
    public String bundleRegistrationIp;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public BundleAction() {
        this(null, null);
    }

    public BundleAction(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public BundleAction(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getAction() {
        return this.action;
    }

    public BundleRegistration getBundleRegistration() {
        return this.bundleRegistration;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getPath() {
        return this.path;
    }

    public String getSource() {
        return this.source;
    }

    public Long getBundleRegistrationId() {
        return this.bundleRegistrationId;
    }

    public String getBundleRegistrationName() {
        return this.bundleRegistrationName;
    }

    public String getBundleRegistrationEmail() {
        return this.bundleRegistrationEmail;
    }

    public String getBundleRegistrationIp() {
        return this.bundleRegistrationIp;
    }

    public static ListIterator<BundleAction> list() throws RuntimeException {
        return BundleAction.list(null, null);
    }

    public static ListIterator<BundleAction> list(HashMap<String, Object> parameters) throws RuntimeException {
        return BundleAction.list(parameters, null);
    }

    public static ListIterator<BundleAction> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        String url = String.format("%s%s/bundle_actions", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<BundleAction>> typeReference = new TypeReference<List<BundleAction>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<BundleAction> all() throws RuntimeException {
        return BundleAction.all(null, null);
    }

    public static ListIterator<BundleAction> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return BundleAction.list(parameters, options);
    }
}

