/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RemoteMountBackend
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="canary_file_path")
    public String canaryFilePath;
    @JsonProperty(value="enabled")
    public Boolean enabled;
    @JsonProperty(value="fall")
    public Long fall;
    @JsonProperty(value="health_check_enabled")
    public Boolean healthCheckEnabled;
    @JsonProperty(value="health_check_type")
    public String healthCheckType;
    @JsonProperty(value="interval")
    public Long interval;
    @JsonProperty(value="min_free_cpu")
    public Double minFreeCpu;
    @JsonProperty(value="min_free_mem")
    public Double minFreeMem;
    @JsonProperty(value="priority")
    public Long priority;
    @JsonProperty(value="remote_path")
    public String remotePath;
    @JsonProperty(value="remote_server_id")
    public Long remoteServerId;
    @JsonProperty(value="remote_server_mount_id")
    public Long remoteServerMountId;
    @JsonProperty(value="rise")
    public Long rise;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="undergoing_maintenance")
    public Boolean undergoingMaintenance;
    @JsonProperty(value="id")
    public Long id;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public RemoteMountBackend() {
        this(null, null);
    }

    public RemoteMountBackend(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public RemoteMountBackend(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getCanaryFilePath() {
        return this.canaryFilePath;
    }

    public void setCanaryFilePath(String canaryFilePath) {
        this.canaryFilePath = canaryFilePath;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getFall() {
        return this.fall;
    }

    public void setFall(Long fall) {
        this.fall = fall;
    }

    public Boolean getHealthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public void setHealthCheckEnabled(Boolean healthCheckEnabled) {
        this.healthCheckEnabled = healthCheckEnabled;
    }

    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    public void setHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public Double getMinFreeCpu() {
        return this.minFreeCpu;
    }

    public void setMinFreeCpu(Double minFreeCpu) {
        this.minFreeCpu = minFreeCpu;
    }

    public Double getMinFreeMem() {
        return this.minFreeMem;
    }

    public void setMinFreeMem(Double minFreeMem) {
        this.minFreeMem = minFreeMem;
    }

    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public Long getRemoteServerId() {
        return this.remoteServerId;
    }

    public void setRemoteServerId(Long remoteServerId) {
        this.remoteServerId = remoteServerId;
    }

    public Long getRemoteServerMountId() {
        return this.remoteServerMountId;
    }

    public void setRemoteServerMountId(Long remoteServerMountId) {
        this.remoteServerMountId = remoteServerMountId;
    }

    public Long getRise() {
        return this.rise;
    }

    public void setRise(Long rise) {
        this.rise = rise;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getUndergoingMaintenance() {
        return this.undergoingMaintenance;
    }

    public void setUndergoingMaintenance(Boolean undergoingMaintenance) {
        this.undergoingMaintenance = undergoingMaintenance;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void resetStatus(HashMap<String, Object> parameters) throws IOException {
        RemoteMountBackend.resetStatus(this.id, parameters, this.options);
    }

    public RemoteMountBackend update(HashMap<String, Object> parameters) throws IOException {
        return RemoteMountBackend.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        RemoteMountBackend.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        RemoteMountBackend.create(parameters, this.options);
    }

    public static ListIterator<RemoteMountBackend> list() throws RuntimeException {
        return RemoteMountBackend.list(null, null);
    }

    public static ListIterator<RemoteMountBackend> list(HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteMountBackend.list(parameters, null);
    }

    public static ListIterator<RemoteMountBackend> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/remote_mount_backends", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<RemoteMountBackend>> typeReference = new TypeReference<List<RemoteMountBackend>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<RemoteMountBackend> all() throws RuntimeException {
        return RemoteMountBackend.all(null, null);
    }

    public static ListIterator<RemoteMountBackend> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteMountBackend.list(parameters, options);
    }

    public static RemoteMountBackend find() throws RuntimeException {
        return RemoteMountBackend.find(null, null, null);
    }

    public static RemoteMountBackend find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteMountBackend.find(id, parameters, null);
    }

    public static RemoteMountBackend find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteMountBackend.find(null, parameters, options);
    }

    public static RemoteMountBackend find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/remote_mount_backends/%s", urlParts);
        TypeReference<RemoteMountBackend> typeReference = new TypeReference<RemoteMountBackend>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static RemoteMountBackend get() throws RuntimeException {
        return RemoteMountBackend.get(null, null, null);
    }

    public static RemoteMountBackend get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteMountBackend.find(id, parameters, options);
    }

    public static RemoteMountBackend create() throws RuntimeException {
        return RemoteMountBackend.create(null, null);
    }

    public static RemoteMountBackend create(HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteMountBackend.create(parameters, null);
    }

    public static RemoteMountBackend create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("canary_file_path") || parameters.get("canary_file_path") == null) {
            throw new NullPointerException("Parameter missing: canary_file_path parameters[\"canary_file_path\"]");
        }
        if (!parameters.containsKey("remote_server_mount_id") || parameters.get("remote_server_mount_id") == null) {
            throw new NullPointerException("Parameter missing: remote_server_mount_id parameters[\"remote_server_mount_id\"]");
        }
        if (!parameters.containsKey("remote_server_id") || parameters.get("remote_server_id") == null) {
            throw new NullPointerException("Parameter missing: remote_server_id parameters[\"remote_server_id\"]");
        }
        if (parameters.containsKey("canary_file_path") && !(parameters.get("canary_file_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: canary_file_path must be of type String parameters[\"canary_file_path\"]");
        }
        if (parameters.containsKey("remote_server_mount_id") && !(parameters.get("remote_server_mount_id") instanceof Long) && !(parameters.get("remote_server_mount_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: remote_server_mount_id must be of type Long or Integer parameters[\"remote_server_mount_id\"]");
        }
        if (parameters.containsKey("remote_server_id") && !(parameters.get("remote_server_id") instanceof Long) && !(parameters.get("remote_server_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: remote_server_id must be of type Long or Integer parameters[\"remote_server_id\"]");
        }
        if (parameters.containsKey("enabled") && !(parameters.get("enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: enabled must be of type Boolean parameters[\"enabled\"]");
        }
        if (parameters.containsKey("fall") && !(parameters.get("fall") instanceof Long) && !(parameters.get("fall") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: fall must be of type Long or Integer parameters[\"fall\"]");
        }
        if (parameters.containsKey("health_check_enabled") && !(parameters.get("health_check_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: health_check_enabled must be of type Boolean parameters[\"health_check_enabled\"]");
        }
        if (parameters.containsKey("health_check_type") && !(parameters.get("health_check_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: health_check_type must be of type String parameters[\"health_check_type\"]");
        }
        if (parameters.containsKey("interval") && !(parameters.get("interval") instanceof Long) && !(parameters.get("interval") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: interval must be of type Long or Integer parameters[\"interval\"]");
        }
        if (parameters.containsKey("min_free_cpu") && !(parameters.get("min_free_cpu") instanceof Double)) {
            throw new IllegalArgumentException("Bad parameter: min_free_cpu must be of type Double parameters[\"min_free_cpu\"]");
        }
        if (parameters.containsKey("min_free_mem") && !(parameters.get("min_free_mem") instanceof Double)) {
            throw new IllegalArgumentException("Bad parameter: min_free_mem must be of type Double parameters[\"min_free_mem\"]");
        }
        if (parameters.containsKey("priority") && !(parameters.get("priority") instanceof Long) && !(parameters.get("priority") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: priority must be of type Long or Integer parameters[\"priority\"]");
        }
        if (parameters.containsKey("remote_path") && !(parameters.get("remote_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: remote_path must be of type String parameters[\"remote_path\"]");
        }
        if (parameters.containsKey("rise") && !(parameters.get("rise") instanceof Long) && !(parameters.get("rise") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: rise must be of type Long or Integer parameters[\"rise\"]");
        }
        String url = String.format("%s%s/remote_mount_backends", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<RemoteMountBackend> typeReference = new TypeReference<RemoteMountBackend>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void resetStatus() throws RuntimeException {
        RemoteMountBackend.resetStatus(null, null, null);
    }

    public static void resetStatus(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        RemoteMountBackend.resetStatus(id, parameters, null);
    }

    public static void resetStatus(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        RemoteMountBackend.resetStatus(null, parameters, options);
    }

    public static void resetStatus(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/remote_mount_backends/%s/reset_status", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static RemoteMountBackend update() throws RuntimeException {
        return RemoteMountBackend.update(null, null, null);
    }

    public static RemoteMountBackend update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return RemoteMountBackend.update(id, parameters, null);
    }

    public static RemoteMountBackend update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return RemoteMountBackend.update(null, parameters, options);
    }

    public static RemoteMountBackend update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!parameters.containsKey("canary_file_path") || parameters.get("canary_file_path") == null) {
            throw new NullPointerException("Parameter missing: canary_file_path parameters[\"canary_file_path\"]");
        }
        if (!parameters.containsKey("remote_server_mount_id") || parameters.get("remote_server_mount_id") == null) {
            throw new NullPointerException("Parameter missing: remote_server_mount_id parameters[\"remote_server_mount_id\"]");
        }
        if (!parameters.containsKey("remote_server_id") || parameters.get("remote_server_id") == null) {
            throw new NullPointerException("Parameter missing: remote_server_id parameters[\"remote_server_id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("canary_file_path") && !(parameters.get("canary_file_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: canary_file_path must be of type String parameters[\"canary_file_path\"]");
        }
        if (parameters.containsKey("remote_server_mount_id") && !(parameters.get("remote_server_mount_id") instanceof Long) && !(parameters.get("remote_server_mount_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: remote_server_mount_id must be of type Long or Integer parameters[\"remote_server_mount_id\"]");
        }
        if (parameters.containsKey("remote_server_id") && !(parameters.get("remote_server_id") instanceof Long) && !(parameters.get("remote_server_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: remote_server_id must be of type Long or Integer parameters[\"remote_server_id\"]");
        }
        if (parameters.containsKey("enabled") && !(parameters.get("enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: enabled must be of type Boolean parameters[\"enabled\"]");
        }
        if (parameters.containsKey("fall") && !(parameters.get("fall") instanceof Long) && !(parameters.get("fall") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: fall must be of type Long or Integer parameters[\"fall\"]");
        }
        if (parameters.containsKey("health_check_enabled") && !(parameters.get("health_check_enabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: health_check_enabled must be of type Boolean parameters[\"health_check_enabled\"]");
        }
        if (parameters.containsKey("health_check_type") && !(parameters.get("health_check_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: health_check_type must be of type String parameters[\"health_check_type\"]");
        }
        if (parameters.containsKey("interval") && !(parameters.get("interval") instanceof Long) && !(parameters.get("interval") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: interval must be of type Long or Integer parameters[\"interval\"]");
        }
        if (parameters.containsKey("min_free_cpu") && !(parameters.get("min_free_cpu") instanceof Double)) {
            throw new IllegalArgumentException("Bad parameter: min_free_cpu must be of type Double parameters[\"min_free_cpu\"]");
        }
        if (parameters.containsKey("min_free_mem") && !(parameters.get("min_free_mem") instanceof Double)) {
            throw new IllegalArgumentException("Bad parameter: min_free_mem must be of type Double parameters[\"min_free_mem\"]");
        }
        if (parameters.containsKey("priority") && !(parameters.get("priority") instanceof Long) && !(parameters.get("priority") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: priority must be of type Long or Integer parameters[\"priority\"]");
        }
        if (parameters.containsKey("remote_path") && !(parameters.get("remote_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: remote_path must be of type String parameters[\"remote_path\"]");
        }
        if (parameters.containsKey("rise") && !(parameters.get("rise") instanceof Long) && !(parameters.get("rise") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: rise must be of type Long or Integer parameters[\"rise\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/remote_mount_backends/%s", urlParts);
        TypeReference<RemoteMountBackend> typeReference = new TypeReference<RemoteMountBackend>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        RemoteMountBackend.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        RemoteMountBackend.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        RemoteMountBackend.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/remote_mount_backends/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        RemoteMountBackend.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        RemoteMountBackend.delete(id, parameters, options);
    }
}

