/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class As2Station
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="uri")
    public String uri;
    @JsonProperty(value="domain")
    public String domain;
    @JsonProperty(value="hex_public_certificate_serial")
    public String hexPublicCertificateSerial;
    @JsonProperty(value="public_certificate_md5")
    public String publicCertificateMd5;
    @JsonProperty(value="public_certificate")
    public String publicCertificate;
    @JsonProperty(value="private_key_md5")
    public String privateKeyMd5;
    @JsonProperty(value="public_certificate_subject")
    public String publicCertificateSubject;
    @JsonProperty(value="public_certificate_issuer")
    public String publicCertificateIssuer;
    @JsonProperty(value="public_certificate_serial")
    public String publicCertificateSerial;
    @JsonProperty(value="public_certificate_not_before")
    public String publicCertificateNotBefore;
    @JsonProperty(value="public_certificate_not_after")
    public String publicCertificateNotAfter;
    @JsonProperty(value="private_key_password_md5")
    public String privateKeyPasswordMd5;
    @JsonProperty(value="private_key")
    public String privateKey;
    @JsonProperty(value="private_key_password")
    public String privateKeyPassword;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public As2Station() {
        this(null, null);
    }

    public As2Station(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public As2Station(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getHexPublicCertificateSerial() {
        return this.hexPublicCertificateSerial;
    }

    public void setHexPublicCertificateSerial(String hexPublicCertificateSerial) {
        this.hexPublicCertificateSerial = hexPublicCertificateSerial;
    }

    public String getPublicCertificateMd5() {
        return this.publicCertificateMd5;
    }

    public void setPublicCertificateMd5(String publicCertificateMd5) {
        this.publicCertificateMd5 = publicCertificateMd5;
    }

    public String getPublicCertificate() {
        return this.publicCertificate;
    }

    public void setPublicCertificate(String publicCertificate) {
        this.publicCertificate = publicCertificate;
    }

    public String getPrivateKeyMd5() {
        return this.privateKeyMd5;
    }

    public void setPrivateKeyMd5(String privateKeyMd5) {
        this.privateKeyMd5 = privateKeyMd5;
    }

    public String getPublicCertificateSubject() {
        return this.publicCertificateSubject;
    }

    public void setPublicCertificateSubject(String publicCertificateSubject) {
        this.publicCertificateSubject = publicCertificateSubject;
    }

    public String getPublicCertificateIssuer() {
        return this.publicCertificateIssuer;
    }

    public void setPublicCertificateIssuer(String publicCertificateIssuer) {
        this.publicCertificateIssuer = publicCertificateIssuer;
    }

    public String getPublicCertificateSerial() {
        return this.publicCertificateSerial;
    }

    public void setPublicCertificateSerial(String publicCertificateSerial) {
        this.publicCertificateSerial = publicCertificateSerial;
    }

    public String getPublicCertificateNotBefore() {
        return this.publicCertificateNotBefore;
    }

    public void setPublicCertificateNotBefore(String publicCertificateNotBefore) {
        this.publicCertificateNotBefore = publicCertificateNotBefore;
    }

    public String getPublicCertificateNotAfter() {
        return this.publicCertificateNotAfter;
    }

    public void setPublicCertificateNotAfter(String publicCertificateNotAfter) {
        this.publicCertificateNotAfter = publicCertificateNotAfter;
    }

    public String getPrivateKeyPasswordMd5() {
        return this.privateKeyPasswordMd5;
    }

    public void setPrivateKeyPasswordMd5(String privateKeyPasswordMd5) {
        this.privateKeyPasswordMd5 = privateKeyPasswordMd5;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public As2Station update(HashMap<String, Object> parameters) throws IOException {
        return As2Station.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        As2Station.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        As2Station.create(parameters, this.options);
    }

    public static ListIterator<As2Station> list() throws RuntimeException {
        return As2Station.list(null, null);
    }

    public static ListIterator<As2Station> list(HashMap<String, Object> parameters) throws RuntimeException {
        return As2Station.list(parameters, null);
    }

    public static ListIterator<As2Station> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        String url = String.format("%s%s/as2_stations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<As2Station>> typeReference = new TypeReference<List<As2Station>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<As2Station> all() throws RuntimeException {
        return As2Station.all(null, null);
    }

    public static ListIterator<As2Station> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Station.list(parameters, options);
    }

    public static As2Station find() throws RuntimeException {
        return As2Station.find(null, null, null);
    }

    public static As2Station find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return As2Station.find(id, parameters, null);
    }

    public static As2Station find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Station.find(null, parameters, options);
    }

    public static As2Station find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/as2_stations/%s", urlParts);
        TypeReference<As2Station> typeReference = new TypeReference<As2Station>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static As2Station get() throws RuntimeException {
        return As2Station.get(null, null, null);
    }

    public static As2Station get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Station.find(id, parameters, options);
    }

    public static As2Station create() throws RuntimeException {
        return As2Station.create(null, null);
    }

    public static As2Station create(HashMap<String, Object> parameters) throws RuntimeException {
        return As2Station.create(parameters, null);
    }

    public static As2Station create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("name") || parameters.get("name") == null) {
            throw new NullPointerException("Parameter missing: name parameters[\"name\"]");
        }
        if (!parameters.containsKey("public_certificate") || parameters.get("public_certificate") == null) {
            throw new NullPointerException("Parameter missing: public_certificate parameters[\"public_certificate\"]");
        }
        if (!parameters.containsKey("private_key") || parameters.get("private_key") == null) {
            throw new NullPointerException("Parameter missing: private_key parameters[\"private_key\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("public_certificate") && !(parameters.get("public_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: public_certificate must be of type String parameters[\"public_certificate\"]");
        }
        if (parameters.containsKey("private_key") && !(parameters.get("private_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key must be of type String parameters[\"private_key\"]");
        }
        if (parameters.containsKey("private_key_password") && !(parameters.get("private_key_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key_password must be of type String parameters[\"private_key_password\"]");
        }
        String url = String.format("%s%s/as2_stations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<As2Station> typeReference = new TypeReference<As2Station>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static As2Station update() throws RuntimeException {
        return As2Station.update(null, null, null);
    }

    public static As2Station update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return As2Station.update(id, parameters, null);
    }

    public static As2Station update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2Station.update(null, parameters, options);
    }

    public static As2Station update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("public_certificate") && !(parameters.get("public_certificate") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: public_certificate must be of type String parameters[\"public_certificate\"]");
        }
        if (parameters.containsKey("private_key") && !(parameters.get("private_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key must be of type String parameters[\"private_key\"]");
        }
        if (parameters.containsKey("private_key_password") && !(parameters.get("private_key_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key_password must be of type String parameters[\"private_key_password\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/as2_stations/%s", urlParts);
        TypeReference<As2Station> typeReference = new TypeReference<As2Station>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        As2Station.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        As2Station.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        As2Station.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/as2_stations/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        As2Station.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        As2Station.delete(id, parameters, options);
    }
}

