/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Sync
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="description")
    public String description;
    @JsonProperty(value="site_id")
    public Long siteId;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="src_path")
    public String srcPath;
    @JsonProperty(value="dest_path")
    public String destPath;
    @JsonProperty(value="src_remote_server_id")
    public Long srcRemoteServerId;
    @JsonProperty(value="dest_remote_server_id")
    public Long destRemoteServerId;
    @JsonProperty(value="two_way")
    public Boolean twoWay;
    @JsonProperty(value="keep_after_copy")
    public Boolean keepAfterCopy;
    @JsonProperty(value="delete_empty_folders")
    public Boolean deleteEmptyFolders;
    @JsonProperty(value="disabled")
    public Boolean disabled;
    @JsonProperty(value="trigger")
    public String trigger;
    @JsonProperty(value="trigger_file")
    public String triggerFile;
    @JsonProperty(value="include_patterns")
    public String[] includePatterns;
    @JsonProperty(value="exclude_patterns")
    public String[] excludePatterns;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="updated_at")
    public Date updatedAt;
    @JsonProperty(value="sync_interval_minutes")
    public Long syncIntervalMinutes;
    @JsonProperty(value="interval")
    public String interval;
    @JsonProperty(value="recurring_day")
    public Long recurringDay;
    @JsonProperty(value="schedule_days_of_week")
    public Long[] scheduleDaysOfWeek;
    @JsonProperty(value="schedule_times_of_day")
    public String[] scheduleTimesOfDay;
    @JsonProperty(value="schedule_time_zone")
    public String scheduleTimeZone;
    @JsonProperty(value="holiday_region")
    public String holidayRegion;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Sync() {
        this(null, null);
    }

    public Sync(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Sync(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    public Long getSrcRemoteServerId() {
        return this.srcRemoteServerId;
    }

    public void setSrcRemoteServerId(Long srcRemoteServerId) {
        this.srcRemoteServerId = srcRemoteServerId;
    }

    public Long getDestRemoteServerId() {
        return this.destRemoteServerId;
    }

    public void setDestRemoteServerId(Long destRemoteServerId) {
        this.destRemoteServerId = destRemoteServerId;
    }

    public Boolean getTwoWay() {
        return this.twoWay;
    }

    public void setTwoWay(Boolean twoWay) {
        this.twoWay = twoWay;
    }

    public Boolean getKeepAfterCopy() {
        return this.keepAfterCopy;
    }

    public void setKeepAfterCopy(Boolean keepAfterCopy) {
        this.keepAfterCopy = keepAfterCopy;
    }

    public Boolean getDeleteEmptyFolders() {
        return this.deleteEmptyFolders;
    }

    public void setDeleteEmptyFolders(Boolean deleteEmptyFolders) {
        this.deleteEmptyFolders = deleteEmptyFolders;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public String getTriggerFile() {
        return this.triggerFile;
    }

    public void setTriggerFile(String triggerFile) {
        this.triggerFile = triggerFile;
    }

    public String[] getIncludePatterns() {
        return this.includePatterns;
    }

    public void setIncludePatterns(String[] includePatterns) {
        this.includePatterns = includePatterns;
    }

    public String[] getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Long getSyncIntervalMinutes() {
        return this.syncIntervalMinutes;
    }

    public void setSyncIntervalMinutes(Long syncIntervalMinutes) {
        this.syncIntervalMinutes = syncIntervalMinutes;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public Long getRecurringDay() {
        return this.recurringDay;
    }

    public void setRecurringDay(Long recurringDay) {
        this.recurringDay = recurringDay;
    }

    public Long[] getScheduleDaysOfWeek() {
        return this.scheduleDaysOfWeek;
    }

    public void setScheduleDaysOfWeek(Long[] scheduleDaysOfWeek) {
        this.scheduleDaysOfWeek = scheduleDaysOfWeek;
    }

    public String[] getScheduleTimesOfDay() {
        return this.scheduleTimesOfDay;
    }

    public void setScheduleTimesOfDay(String[] scheduleTimesOfDay) {
        this.scheduleTimesOfDay = scheduleTimesOfDay;
    }

    public String getScheduleTimeZone() {
        return this.scheduleTimeZone;
    }

    public void setScheduleTimeZone(String scheduleTimeZone) {
        this.scheduleTimeZone = scheduleTimeZone;
    }

    public String getHolidayRegion() {
        return this.holidayRegion;
    }

    public void setHolidayRegion(String holidayRegion) {
        this.holidayRegion = holidayRegion;
    }

    public void manualRun(HashMap<String, Object> parameters) throws IOException {
        Sync.manualRun(this.id, parameters, this.options);
    }

    public Sync update(HashMap<String, Object> parameters) throws IOException {
        return Sync.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        Sync.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Sync.create(parameters, this.options);
    }

    public static ListIterator<Sync> list() throws RuntimeException {
        return Sync.list(null, null);
    }

    public static ListIterator<Sync> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Sync.list(parameters, null);
    }

    public static ListIterator<Sync> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/syncs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Sync>> typeReference = new TypeReference<List<Sync>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Sync> all() throws RuntimeException {
        return Sync.all(null, null);
    }

    public static ListIterator<Sync> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Sync.list(parameters, options);
    }

    public static Sync find() throws RuntimeException {
        return Sync.find(null, null, null);
    }

    public static Sync find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Sync.find(id, parameters, null);
    }

    public static Sync find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Sync.find(null, parameters, options);
    }

    public static Sync find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/syncs/%s", urlParts);
        TypeReference<Sync> typeReference = new TypeReference<Sync>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Sync get() throws RuntimeException {
        return Sync.get(null, null, null);
    }

    public static Sync get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Sync.find(id, parameters, options);
    }

    public static Sync create() throws RuntimeException {
        return Sync.create(null, null);
    }

    public static Sync create(HashMap<String, Object> parameters) throws RuntimeException {
        return Sync.create(parameters, null);
    }

    public static Sync create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("src_path") && !(parameters.get("src_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: src_path must be of type String parameters[\"src_path\"]");
        }
        if (parameters.containsKey("dest_path") && !(parameters.get("dest_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: dest_path must be of type String parameters[\"dest_path\"]");
        }
        if (parameters.containsKey("src_remote_server_id") && !(parameters.get("src_remote_server_id") instanceof Long) && !(parameters.get("src_remote_server_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: src_remote_server_id must be of type Long or Integer parameters[\"src_remote_server_id\"]");
        }
        if (parameters.containsKey("dest_remote_server_id") && !(parameters.get("dest_remote_server_id") instanceof Long) && !(parameters.get("dest_remote_server_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: dest_remote_server_id must be of type Long or Integer parameters[\"dest_remote_server_id\"]");
        }
        if (parameters.containsKey("two_way") && !(parameters.get("two_way") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: two_way must be of type Boolean parameters[\"two_way\"]");
        }
        if (parameters.containsKey("keep_after_copy") && !(parameters.get("keep_after_copy") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: keep_after_copy must be of type Boolean parameters[\"keep_after_copy\"]");
        }
        if (parameters.containsKey("delete_empty_folders") && !(parameters.get("delete_empty_folders") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: delete_empty_folders must be of type Boolean parameters[\"delete_empty_folders\"]");
        }
        if (parameters.containsKey("disabled") && !(parameters.get("disabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disabled must be of type Boolean parameters[\"disabled\"]");
        }
        if (parameters.containsKey("interval") && !(parameters.get("interval") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: interval must be of type String parameters[\"interval\"]");
        }
        if (parameters.containsKey("trigger") && !(parameters.get("trigger") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: trigger must be of type String parameters[\"trigger\"]");
        }
        if (parameters.containsKey("trigger_file") && !(parameters.get("trigger_file") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: trigger_file must be of type String parameters[\"trigger_file\"]");
        }
        if (parameters.containsKey("recurring_day") && !(parameters.get("recurring_day") instanceof Long) && !(parameters.get("recurring_day") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: recurring_day must be of type Long or Integer parameters[\"recurring_day\"]");
        }
        if (parameters.containsKey("schedule_time_zone") && !(parameters.get("schedule_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: schedule_time_zone must be of type String parameters[\"schedule_time_zone\"]");
        }
        if (parameters.containsKey("schedule_days_of_week") && !(parameters.get("schedule_days_of_week") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_days_of_week must be of type Long[] parameters[\"schedule_days_of_week\"]");
        }
        if (parameters.containsKey("schedule_times_of_day") && !(parameters.get("schedule_times_of_day") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_times_of_day must be of type String[] parameters[\"schedule_times_of_day\"]");
        }
        String url = String.format("%s%s/syncs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Sync> typeReference = new TypeReference<Sync>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void createMigrateTo() throws RuntimeException {
        Sync.createMigrateTo(null, null);
    }

    public static void createMigrateTo(HashMap<String, Object> parameters) throws RuntimeException {
        Sync.createMigrateTo(parameters, null);
    }

    public static void createMigrateTo(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        options = options != null ? options : new HashMap<String, Object>();
        String url = String.format("%s%s/syncs/migrate_to_syncs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static void manualRun() throws RuntimeException {
        Sync.manualRun(null, null, null);
    }

    public static void manualRun(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Sync.manualRun(id, parameters, null);
    }

    public static void manualRun(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Sync.manualRun(null, parameters, options);
    }

    public static void manualRun(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/syncs/%s/manual_run", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static Sync update() throws RuntimeException {
        return Sync.update(null, null, null);
    }

    public static Sync update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Sync.update(id, parameters, null);
    }

    public static Sync update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Sync.update(null, parameters, options);
    }

    public static Sync update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("src_path") && !(parameters.get("src_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: src_path must be of type String parameters[\"src_path\"]");
        }
        if (parameters.containsKey("dest_path") && !(parameters.get("dest_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: dest_path must be of type String parameters[\"dest_path\"]");
        }
        if (parameters.containsKey("src_remote_server_id") && !(parameters.get("src_remote_server_id") instanceof Long) && !(parameters.get("src_remote_server_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: src_remote_server_id must be of type Long or Integer parameters[\"src_remote_server_id\"]");
        }
        if (parameters.containsKey("dest_remote_server_id") && !(parameters.get("dest_remote_server_id") instanceof Long) && !(parameters.get("dest_remote_server_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: dest_remote_server_id must be of type Long or Integer parameters[\"dest_remote_server_id\"]");
        }
        if (parameters.containsKey("two_way") && !(parameters.get("two_way") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: two_way must be of type Boolean parameters[\"two_way\"]");
        }
        if (parameters.containsKey("keep_after_copy") && !(parameters.get("keep_after_copy") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: keep_after_copy must be of type Boolean parameters[\"keep_after_copy\"]");
        }
        if (parameters.containsKey("delete_empty_folders") && !(parameters.get("delete_empty_folders") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: delete_empty_folders must be of type Boolean parameters[\"delete_empty_folders\"]");
        }
        if (parameters.containsKey("disabled") && !(parameters.get("disabled") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disabled must be of type Boolean parameters[\"disabled\"]");
        }
        if (parameters.containsKey("interval") && !(parameters.get("interval") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: interval must be of type String parameters[\"interval\"]");
        }
        if (parameters.containsKey("trigger") && !(parameters.get("trigger") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: trigger must be of type String parameters[\"trigger\"]");
        }
        if (parameters.containsKey("trigger_file") && !(parameters.get("trigger_file") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: trigger_file must be of type String parameters[\"trigger_file\"]");
        }
        if (parameters.containsKey("recurring_day") && !(parameters.get("recurring_day") instanceof Long) && !(parameters.get("recurring_day") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: recurring_day must be of type Long or Integer parameters[\"recurring_day\"]");
        }
        if (parameters.containsKey("schedule_time_zone") && !(parameters.get("schedule_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: schedule_time_zone must be of type String parameters[\"schedule_time_zone\"]");
        }
        if (parameters.containsKey("schedule_days_of_week") && !(parameters.get("schedule_days_of_week") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_days_of_week must be of type Long[] parameters[\"schedule_days_of_week\"]");
        }
        if (parameters.containsKey("schedule_times_of_day") && !(parameters.get("schedule_times_of_day") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: schedule_times_of_day must be of type String[] parameters[\"schedule_times_of_day\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/syncs/%s", urlParts);
        TypeReference<Sync> typeReference = new TypeReference<Sync>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        Sync.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Sync.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Sync.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/syncs/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Sync.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Sync.delete(id, parameters, options);
    }
}

