/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Lock
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="timeout")
    public Long timeout;
    @JsonProperty(value="depth")
    public String depth;
    @JsonProperty(value="recursive")
    public Boolean recursive;
    @JsonProperty(value="owner")
    public String owner;
    @JsonProperty(value="scope")
    public String scope;
    @JsonProperty(value="exclusive")
    public Boolean exclusive;
    @JsonProperty(value="token")
    public String token;
    @JsonProperty(value="type")
    public String type;
    @JsonProperty(value="allow_access_by_any_user")
    public Boolean allowAccessByAnyUser;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="username")
    public String username;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Lock() {
        this(null, null);
    }

    public Lock(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Lock(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getDepth() {
        return this.depth;
    }

    public void setDepth(String depth) {
        this.depth = depth;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Boolean getExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getAllowAccessByAnyUser() {
        return this.allowAccessByAnyUser;
    }

    public void setAllowAccessByAnyUser(Boolean allowAccessByAnyUser) {
        this.allowAccessByAnyUser = allowAccessByAnyUser;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        Lock.delete(this.path, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Lock.create(parameters, this.options);
    }

    public static ListIterator<Lock> listFor() throws RuntimeException {
        return Lock.listFor(null, null, null);
    }

    public static ListIterator<Lock> listFor(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Lock.listFor(path, parameters, null);
    }

    public static ListIterator<Lock> listFor(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Lock.listFor(null, parameters, options);
    }

    public static ListIterator<Lock> listFor(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("include_children") && !(parameters.get("include_children") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: include_children must be of type Boolean parameters[\"include_children\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/locks/%s", urlParts);
        TypeReference<List<Lock>> typeReference = new TypeReference<List<Lock>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Lock create() throws RuntimeException {
        return Lock.create(null, null, null);
    }

    public static Lock create(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Lock.create(path, parameters, null);
    }

    public static Lock create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Lock.create(null, parameters, options);
    }

    public static Lock create(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("allow_access_by_any_user") && !(parameters.get("allow_access_by_any_user") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: allow_access_by_any_user must be of type Boolean parameters[\"allow_access_by_any_user\"]");
        }
        if (parameters.containsKey("exclusive") && !(parameters.get("exclusive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: exclusive must be of type Boolean parameters[\"exclusive\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        if (parameters.containsKey("timeout") && !(parameters.get("timeout") instanceof Long) && !(parameters.get("timeout") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: timeout must be of type Long or Integer parameters[\"timeout\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/locks/%s", urlParts);
        TypeReference<Lock> typeReference = new TypeReference<Lock>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        Lock.delete(null, null, null);
    }

    public static void delete(String path, HashMap<String, Object> parameters) throws RuntimeException {
        Lock.delete(path, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Lock.delete(null, parameters, options);
    }

    public static void delete(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("token") || parameters.get("token") == null) {
            throw new NullPointerException("Parameter missing: token parameters[\"token\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("token") && !(parameters.get("token") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: token must be of type String parameters[\"token\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/locks/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Lock.destroy(null, null, null);
    }

    public static void destroy(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Lock.delete(path, parameters, options);
    }
}

