/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.FormFieldSet;
import com.files.models.Image;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Bundle
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="code")
    public String code;
    @JsonProperty(value="color_left")
    public String colorLeft;
    @JsonProperty(value="color_link")
    public String colorLink;
    @JsonProperty(value="color_text")
    public String colorText;
    @JsonProperty(value="color_top")
    public String colorTop;
    @JsonProperty(value="color_top_text")
    public String colorTopText;
    @JsonProperty(value="url")
    public String url;
    @JsonProperty(value="description")
    public String description;
    @JsonProperty(value="expires_at")
    public Date expiresAt;
    @JsonProperty(value="password_protected")
    public Boolean passwordProtected;
    @JsonProperty(value="permissions")
    public String permissions;
    @JsonProperty(value="preview_only")
    public Boolean previewOnly;
    @JsonProperty(value="require_registration")
    public Boolean requireRegistration;
    @JsonProperty(value="require_share_recipient")
    public Boolean requireShareRecipient;
    @JsonProperty(value="require_logout")
    public Boolean requireLogout;
    @JsonProperty(value="clickwrap_body")
    public String clickwrapBody;
    @JsonProperty(value="form_field_set")
    public FormFieldSet formFieldSet;
    @JsonProperty(value="skip_name")
    public Boolean skipName;
    @JsonProperty(value="skip_email")
    public Boolean skipEmail;
    @JsonProperty(value="start_access_on_date")
    public Date startAccessOnDate;
    @JsonProperty(value="skip_company")
    public Boolean skipCompany;
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="dont_separate_submissions_by_folder")
    public Boolean dontSeparateSubmissionsByFolder;
    @JsonProperty(value="max_uses")
    public Long maxUses;
    @JsonProperty(value="note")
    public String note;
    @JsonProperty(value="path_template")
    public String pathTemplate;
    @JsonProperty(value="path_template_time_zone")
    public String pathTemplateTimeZone;
    @JsonProperty(value="send_email_receipt_to_uploader")
    public Boolean sendEmailReceiptToUploader;
    @JsonProperty(value="snapshot_id")
    public Long snapshotId;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="clickwrap_id")
    public Long clickwrapId;
    @JsonProperty(value="inbox_id")
    public Long inboxId;
    @JsonProperty(value="watermark_attachment")
    public Image watermarkAttachment;
    @JsonProperty(value="watermark_value")
    public Map<String, String> watermarkValue;
    @JsonProperty(value="has_inbox")
    public Boolean hasInbox;
    @JsonProperty(value="dont_allow_folders_in_uploads")
    public Boolean dontAllowFoldersInUploads;
    @JsonProperty(value="paths")
    public String[] paths;
    @JsonProperty(value="bundlepaths")
    public Object[] bundlepaths;
    @JsonProperty(value="password")
    public String password;
    @JsonProperty(value="form_field_set_id")
    public Long formFieldSetId;
    @JsonProperty(value="create_snapshot")
    public Boolean createSnapshot;
    @JsonProperty(value="finalize_snapshot")
    public Boolean finalizeSnapshot;
    @JsonProperty(value="watermark_attachment_file")
    public byte[] watermarkAttachmentFile;
    @JsonProperty(value="watermark_attachment_delete")
    public Boolean watermarkAttachmentDelete;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Bundle() {
        this(null, null);
    }

    public Bundle(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Bundle(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getColorLeft() {
        return this.colorLeft;
    }

    public void setColorLeft(String colorLeft) {
        this.colorLeft = colorLeft;
    }

    public String getColorLink() {
        return this.colorLink;
    }

    public void setColorLink(String colorLink) {
        this.colorLink = colorLink;
    }

    public String getColorText() {
        return this.colorText;
    }

    public void setColorText(String colorText) {
        this.colorText = colorText;
    }

    public String getColorTop() {
        return this.colorTop;
    }

    public void setColorTop(String colorTop) {
        this.colorTop = colorTop;
    }

    public String getColorTopText() {
        return this.colorTopText;
    }

    public void setColorTopText(String colorTopText) {
        this.colorTopText = colorTopText;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Boolean getPasswordProtected() {
        return this.passwordProtected;
    }

    public void setPasswordProtected(Boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public Boolean getPreviewOnly() {
        return this.previewOnly;
    }

    public void setPreviewOnly(Boolean previewOnly) {
        this.previewOnly = previewOnly;
    }

    public Boolean getRequireRegistration() {
        return this.requireRegistration;
    }

    public void setRequireRegistration(Boolean requireRegistration) {
        this.requireRegistration = requireRegistration;
    }

    public Boolean getRequireShareRecipient() {
        return this.requireShareRecipient;
    }

    public void setRequireShareRecipient(Boolean requireShareRecipient) {
        this.requireShareRecipient = requireShareRecipient;
    }

    public Boolean getRequireLogout() {
        return this.requireLogout;
    }

    public void setRequireLogout(Boolean requireLogout) {
        this.requireLogout = requireLogout;
    }

    public String getClickwrapBody() {
        return this.clickwrapBody;
    }

    public void setClickwrapBody(String clickwrapBody) {
        this.clickwrapBody = clickwrapBody;
    }

    public FormFieldSet getFormFieldSet() {
        return this.formFieldSet;
    }

    public void setFormFieldSet(FormFieldSet formFieldSet) {
        this.formFieldSet = formFieldSet;
    }

    public Boolean getSkipName() {
        return this.skipName;
    }

    public void setSkipName(Boolean skipName) {
        this.skipName = skipName;
    }

    public Boolean getSkipEmail() {
        return this.skipEmail;
    }

    public void setSkipEmail(Boolean skipEmail) {
        this.skipEmail = skipEmail;
    }

    public Date getStartAccessOnDate() {
        return this.startAccessOnDate;
    }

    public void setStartAccessOnDate(Date startAccessOnDate) {
        this.startAccessOnDate = startAccessOnDate;
    }

    public Boolean getSkipCompany() {
        return this.skipCompany;
    }

    public void setSkipCompany(Boolean skipCompany) {
        this.skipCompany = skipCompany;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Boolean getDontSeparateSubmissionsByFolder() {
        return this.dontSeparateSubmissionsByFolder;
    }

    public void setDontSeparateSubmissionsByFolder(Boolean dontSeparateSubmissionsByFolder) {
        this.dontSeparateSubmissionsByFolder = dontSeparateSubmissionsByFolder;
    }

    public Long getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(Long maxUses) {
        this.maxUses = maxUses;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getPathTemplate() {
        return this.pathTemplate;
    }

    public void setPathTemplate(String pathTemplate) {
        this.pathTemplate = pathTemplate;
    }

    public String getPathTemplateTimeZone() {
        return this.pathTemplateTimeZone;
    }

    public void setPathTemplateTimeZone(String pathTemplateTimeZone) {
        this.pathTemplateTimeZone = pathTemplateTimeZone;
    }

    public Boolean getSendEmailReceiptToUploader() {
        return this.sendEmailReceiptToUploader;
    }

    public void setSendEmailReceiptToUploader(Boolean sendEmailReceiptToUploader) {
        this.sendEmailReceiptToUploader = sendEmailReceiptToUploader;
    }

    public Long getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(Long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getClickwrapId() {
        return this.clickwrapId;
    }

    public void setClickwrapId(Long clickwrapId) {
        this.clickwrapId = clickwrapId;
    }

    public Long getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(Long inboxId) {
        this.inboxId = inboxId;
    }

    public Image getWatermarkAttachment() {
        return this.watermarkAttachment;
    }

    public void setWatermarkAttachment(Image watermarkAttachment) {
        this.watermarkAttachment = watermarkAttachment;
    }

    public Map<String, String> getWatermarkValue() {
        return this.watermarkValue;
    }

    public void setWatermarkValue(Map<String, String> watermarkValue) {
        this.watermarkValue = watermarkValue;
    }

    public Boolean getHasInbox() {
        return this.hasInbox;
    }

    public void setHasInbox(Boolean hasInbox) {
        this.hasInbox = hasInbox;
    }

    public Boolean getDontAllowFoldersInUploads() {
        return this.dontAllowFoldersInUploads;
    }

    public void setDontAllowFoldersInUploads(Boolean dontAllowFoldersInUploads) {
        this.dontAllowFoldersInUploads = dontAllowFoldersInUploads;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public Object[] getBundlepaths() {
        return this.bundlepaths;
    }

    public void setBundlepaths(Object[] bundlepaths) {
        this.bundlepaths = bundlepaths;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getFormFieldSetId() {
        return this.formFieldSetId;
    }

    public void setFormFieldSetId(Long formFieldSetId) {
        this.formFieldSetId = formFieldSetId;
    }

    public Boolean getCreateSnapshot() {
        return this.createSnapshot;
    }

    public void setCreateSnapshot(Boolean createSnapshot) {
        this.createSnapshot = createSnapshot;
    }

    public Boolean getFinalizeSnapshot() {
        return this.finalizeSnapshot;
    }

    public void setFinalizeSnapshot(Boolean finalizeSnapshot) {
        this.finalizeSnapshot = finalizeSnapshot;
    }

    public byte[] getWatermarkAttachmentFile() {
        return this.watermarkAttachmentFile;
    }

    public void setWatermarkAttachmentFile(byte[] watermarkAttachmentFile) {
        this.watermarkAttachmentFile = watermarkAttachmentFile;
    }

    public Boolean getWatermarkAttachmentDelete() {
        return this.watermarkAttachmentDelete;
    }

    public void setWatermarkAttachmentDelete(Boolean watermarkAttachmentDelete) {
        this.watermarkAttachmentDelete = watermarkAttachmentDelete;
    }

    public void share(HashMap<String, Object> parameters) throws IOException {
        Bundle.share(this.id, parameters, this.options);
    }

    public Bundle update(HashMap<String, Object> parameters) throws IOException {
        return Bundle.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        Bundle.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Bundle.create(parameters, this.options);
    }

    public static ListIterator<Bundle> list() throws RuntimeException {
        return Bundle.list(null, null);
    }

    public static ListIterator<Bundle> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Bundle.list(parameters, null);
    }

    public static ListIterator<Bundle> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        String url = String.format("%s%s/bundles", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Bundle>> typeReference = new TypeReference<List<Bundle>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Bundle> all() throws RuntimeException {
        return Bundle.all(null, null);
    }

    public static ListIterator<Bundle> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Bundle.list(parameters, options);
    }

    public static Bundle find() throws RuntimeException {
        return Bundle.find(null, null, null);
    }

    public static Bundle find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Bundle.find(id, parameters, null);
    }

    public static Bundle find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Bundle.find(null, parameters, options);
    }

    public static Bundle find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/bundles/%s", urlParts);
        TypeReference<Bundle> typeReference = new TypeReference<Bundle>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Bundle get() throws RuntimeException {
        return Bundle.get(null, null, null);
    }

    public static Bundle get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Bundle.find(id, parameters, options);
    }

    public static Bundle create() throws RuntimeException {
        return Bundle.create(null, null);
    }

    public static Bundle create(HashMap<String, Object> parameters) throws RuntimeException {
        return Bundle.create(parameters, null);
    }

    public static Bundle create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("paths") || parameters.get("paths") == null) {
            throw new NullPointerException("Parameter missing: paths parameters[\"paths\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("paths") && !(parameters.get("paths") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: paths must be of type String[] parameters[\"paths\"]");
        }
        if (parameters.containsKey("password") && !(parameters.get("password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password must be of type String parameters[\"password\"]");
        }
        if (parameters.containsKey("form_field_set_id") && !(parameters.get("form_field_set_id") instanceof Long) && !(parameters.get("form_field_set_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: form_field_set_id must be of type Long or Integer parameters[\"form_field_set_id\"]");
        }
        if (parameters.containsKey("create_snapshot") && !(parameters.get("create_snapshot") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: create_snapshot must be of type Boolean parameters[\"create_snapshot\"]");
        }
        if (parameters.containsKey("dont_separate_submissions_by_folder") && !(parameters.get("dont_separate_submissions_by_folder") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: dont_separate_submissions_by_folder must be of type Boolean parameters[\"dont_separate_submissions_by_folder\"]");
        }
        if (parameters.containsKey("expires_at") && !(parameters.get("expires_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: expires_at must be of type String parameters[\"expires_at\"]");
        }
        if (parameters.containsKey("finalize_snapshot") && !(parameters.get("finalize_snapshot") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: finalize_snapshot must be of type Boolean parameters[\"finalize_snapshot\"]");
        }
        if (parameters.containsKey("max_uses") && !(parameters.get("max_uses") instanceof Long) && !(parameters.get("max_uses") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: max_uses must be of type Long or Integer parameters[\"max_uses\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("note") && !(parameters.get("note") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: note must be of type String parameters[\"note\"]");
        }
        if (parameters.containsKey("code") && !(parameters.get("code") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: code must be of type String parameters[\"code\"]");
        }
        if (parameters.containsKey("path_template") && !(parameters.get("path_template") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path_template must be of type String parameters[\"path_template\"]");
        }
        if (parameters.containsKey("path_template_time_zone") && !(parameters.get("path_template_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path_template_time_zone must be of type String parameters[\"path_template_time_zone\"]");
        }
        if (parameters.containsKey("permissions") && !(parameters.get("permissions") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: permissions must be of type String parameters[\"permissions\"]");
        }
        if (parameters.containsKey("require_registration") && !(parameters.get("require_registration") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: require_registration must be of type Boolean parameters[\"require_registration\"]");
        }
        if (parameters.containsKey("clickwrap_id") && !(parameters.get("clickwrap_id") instanceof Long) && !(parameters.get("clickwrap_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: clickwrap_id must be of type Long or Integer parameters[\"clickwrap_id\"]");
        }
        if (parameters.containsKey("inbox_id") && !(parameters.get("inbox_id") instanceof Long) && !(parameters.get("inbox_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: inbox_id must be of type Long or Integer parameters[\"inbox_id\"]");
        }
        if (parameters.containsKey("require_share_recipient") && !(parameters.get("require_share_recipient") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: require_share_recipient must be of type Boolean parameters[\"require_share_recipient\"]");
        }
        if (parameters.containsKey("send_email_receipt_to_uploader") && !(parameters.get("send_email_receipt_to_uploader") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: send_email_receipt_to_uploader must be of type Boolean parameters[\"send_email_receipt_to_uploader\"]");
        }
        if (parameters.containsKey("skip_email") && !(parameters.get("skip_email") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_email must be of type Boolean parameters[\"skip_email\"]");
        }
        if (parameters.containsKey("skip_name") && !(parameters.get("skip_name") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_name must be of type Boolean parameters[\"skip_name\"]");
        }
        if (parameters.containsKey("skip_company") && !(parameters.get("skip_company") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_company must be of type Boolean parameters[\"skip_company\"]");
        }
        if (parameters.containsKey("start_access_on_date") && !(parameters.get("start_access_on_date") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_access_on_date must be of type String parameters[\"start_access_on_date\"]");
        }
        if (parameters.containsKey("snapshot_id") && !(parameters.get("snapshot_id") instanceof Long) && !(parameters.get("snapshot_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: snapshot_id must be of type Long or Integer parameters[\"snapshot_id\"]");
        }
        if (parameters.containsKey("watermark_attachment_file") && !(parameters.get("watermark_attachment_file") instanceof byte[])) {
            throw new IllegalArgumentException("Bad parameter: watermark_attachment_file must be of type byte[] parameters[\"watermark_attachment_file\"]");
        }
        String url = String.format("%s%s/bundles", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Bundle> typeReference = new TypeReference<Bundle>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void share() throws RuntimeException {
        Bundle.share(null, null, null);
    }

    public static void share(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Bundle.share(id, parameters, null);
    }

    public static void share(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Bundle.share(null, parameters, options);
    }

    public static void share(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("to") && !(parameters.get("to") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: to must be of type String[] parameters[\"to\"]");
        }
        if (parameters.containsKey("note") && !(parameters.get("note") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: note must be of type String parameters[\"note\"]");
        }
        if (parameters.containsKey("recipients") && !(parameters.get("recipients") instanceof Object[])) {
            throw new IllegalArgumentException("Bad parameter: recipients must be of type Object[] parameters[\"recipients\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/bundles/%s/share", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static Bundle update() throws RuntimeException {
        return Bundle.update(null, null, null);
    }

    public static Bundle update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Bundle.update(id, parameters, null);
    }

    public static Bundle update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Bundle.update(null, parameters, options);
    }

    public static Bundle update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("paths") && !(parameters.get("paths") instanceof String[])) {
            throw new IllegalArgumentException("Bad parameter: paths must be of type String[] parameters[\"paths\"]");
        }
        if (parameters.containsKey("password") && !(parameters.get("password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: password must be of type String parameters[\"password\"]");
        }
        if (parameters.containsKey("form_field_set_id") && !(parameters.get("form_field_set_id") instanceof Long) && !(parameters.get("form_field_set_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: form_field_set_id must be of type Long or Integer parameters[\"form_field_set_id\"]");
        }
        if (parameters.containsKey("clickwrap_id") && !(parameters.get("clickwrap_id") instanceof Long) && !(parameters.get("clickwrap_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: clickwrap_id must be of type Long or Integer parameters[\"clickwrap_id\"]");
        }
        if (parameters.containsKey("code") && !(parameters.get("code") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: code must be of type String parameters[\"code\"]");
        }
        if (parameters.containsKey("create_snapshot") && !(parameters.get("create_snapshot") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: create_snapshot must be of type Boolean parameters[\"create_snapshot\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("dont_separate_submissions_by_folder") && !(parameters.get("dont_separate_submissions_by_folder") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: dont_separate_submissions_by_folder must be of type Boolean parameters[\"dont_separate_submissions_by_folder\"]");
        }
        if (parameters.containsKey("expires_at") && !(parameters.get("expires_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: expires_at must be of type String parameters[\"expires_at\"]");
        }
        if (parameters.containsKey("finalize_snapshot") && !(parameters.get("finalize_snapshot") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: finalize_snapshot must be of type Boolean parameters[\"finalize_snapshot\"]");
        }
        if (parameters.containsKey("inbox_id") && !(parameters.get("inbox_id") instanceof Long) && !(parameters.get("inbox_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: inbox_id must be of type Long or Integer parameters[\"inbox_id\"]");
        }
        if (parameters.containsKey("max_uses") && !(parameters.get("max_uses") instanceof Long) && !(parameters.get("max_uses") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: max_uses must be of type Long or Integer parameters[\"max_uses\"]");
        }
        if (parameters.containsKey("note") && !(parameters.get("note") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: note must be of type String parameters[\"note\"]");
        }
        if (parameters.containsKey("path_template") && !(parameters.get("path_template") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path_template must be of type String parameters[\"path_template\"]");
        }
        if (parameters.containsKey("path_template_time_zone") && !(parameters.get("path_template_time_zone") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path_template_time_zone must be of type String parameters[\"path_template_time_zone\"]");
        }
        if (parameters.containsKey("permissions") && !(parameters.get("permissions") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: permissions must be of type String parameters[\"permissions\"]");
        }
        if (parameters.containsKey("require_registration") && !(parameters.get("require_registration") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: require_registration must be of type Boolean parameters[\"require_registration\"]");
        }
        if (parameters.containsKey("require_share_recipient") && !(parameters.get("require_share_recipient") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: require_share_recipient must be of type Boolean parameters[\"require_share_recipient\"]");
        }
        if (parameters.containsKey("send_email_receipt_to_uploader") && !(parameters.get("send_email_receipt_to_uploader") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: send_email_receipt_to_uploader must be of type Boolean parameters[\"send_email_receipt_to_uploader\"]");
        }
        if (parameters.containsKey("skip_company") && !(parameters.get("skip_company") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_company must be of type Boolean parameters[\"skip_company\"]");
        }
        if (parameters.containsKey("start_access_on_date") && !(parameters.get("start_access_on_date") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_access_on_date must be of type String parameters[\"start_access_on_date\"]");
        }
        if (parameters.containsKey("skip_email") && !(parameters.get("skip_email") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_email must be of type Boolean parameters[\"skip_email\"]");
        }
        if (parameters.containsKey("skip_name") && !(parameters.get("skip_name") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: skip_name must be of type Boolean parameters[\"skip_name\"]");
        }
        if (parameters.containsKey("watermark_attachment_delete") && !(parameters.get("watermark_attachment_delete") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: watermark_attachment_delete must be of type Boolean parameters[\"watermark_attachment_delete\"]");
        }
        if (parameters.containsKey("watermark_attachment_file") && !(parameters.get("watermark_attachment_file") instanceof byte[])) {
            throw new IllegalArgumentException("Bad parameter: watermark_attachment_file must be of type byte[] parameters[\"watermark_attachment_file\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/bundles/%s", urlParts);
        TypeReference<Bundle> typeReference = new TypeReference<Bundle>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        Bundle.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Bundle.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Bundle.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/bundles/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Bundle.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Bundle.delete(id, parameters, options);
    }
}

