/*
 * Decompiled with CFR 0.152.
 */
package com.files.util;

import com.files.FilesConfig;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HeaderUtils {
    public static final DateFormat HTTP_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");

    private static Integer cappedRetrySeconds(int retrySeconds) {
        return retrySeconds <= FilesConfig.getInstance().getMaximumRetrySeconds() ? Integer.valueOf(retrySeconds) : null;
    }

    public static Integer retryAfterSeconds(Map<String, List<String>> headers) {
        if (headers.containsKey("Retry-After")) {
            String retryValue = headers.get("Retry-After").get(0);
            try {
                return HeaderUtils.cappedRetrySeconds(Integer.parseInt(retryValue));
            }
            catch (NumberFormatException e) {
                try {
                    return HeaderUtils.cappedRetrySeconds((int)TimeUnit.MILLISECONDS.toSeconds(HTTP_DATE_FORMAT.parse(retryValue).getTime() - Date.from(Instant.now()).getTime()) + 1);
                }
                catch (ParseException e2) {
                    return null;
                }
            }
        }
        return null;
    }

    private HeaderUtils() {
    }
}

