/*
 * Decompiled with CFR 0.152.
 */
package com.files.net;

import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.net.FilesHttpExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesHttpClient {
    private static final Logger log = LoggerFactory.getLogger(FilesHttpClient.class);
    private static FilesHttpClient instance;
    protected CloseableHttpClient httpClient;
    protected FilesHttpExecutor httpExecutor;

    protected FilesHttpClient() {
        FilesConfig filesConfig = FilesConfig.getInstance();
        PoolingHttpClientConnectionManager connectionManager = FilesClient.connectionManager;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)TimeUnit.SECONDS.toMillis(10L)).setSocketTimeout((int)TimeUnit.SECONDS.toMillis(30L)).setConnectionRequestTimeout((int)TimeUnit.SECONDS.toMillis(10L)).build();
        try {
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
            this.httpExecutor = new FilesHttpExecutor(this.httpClient);
        }
        catch (Exception e) {
            log.error("Error initializing Apache HTTP Client", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilesHttpClient getInstance() {
        if (instance != null) return instance;
        Class<FilesHttpClient> clazz = FilesHttpClient.class;
        synchronized (FilesHttpClient.class) {
            if (instance != null) return instance;
            instance = new FilesHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public FilesHttpExecutor getHttpExecutor() {
        return this.httpExecutor;
    }
}

