/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActionNotificationExportResult
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="created_at")
    public Long createdAt;
    @JsonProperty(value="status")
    public Long status;
    @JsonProperty(value="message")
    public String message;
    @JsonProperty(value="success")
    public Boolean success;
    @JsonProperty(value="request_headers")
    public String requestHeaders;
    @JsonProperty(value="request_method")
    public String requestMethod;
    @JsonProperty(value="request_url")
    public String requestUrl;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="folder")
    public String folder;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public ActionNotificationExportResult() {
        this(null, null);
    }

    public ActionNotificationExportResult(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public ActionNotificationExportResult(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getPath() {
        return this.path;
    }

    public String getFolder() {
        return this.folder;
    }

    public static ListIterator<ActionNotificationExportResult> list() throws RuntimeException {
        return ActionNotificationExportResult.list(null, null);
    }

    public static ListIterator<ActionNotificationExportResult> list(HashMap<String, Object> parameters) throws RuntimeException {
        return ActionNotificationExportResult.list(parameters, null);
    }

    public static ListIterator<ActionNotificationExportResult> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("action_notification_export_id") || parameters.get("action_notification_export_id") == null) {
            throw new NullPointerException("Parameter missing: action_notification_export_id parameters[\"action_notification_export_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("action_notification_export_id") && !(parameters.get("action_notification_export_id") instanceof Long) && !(parameters.get("action_notification_export_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: action_notification_export_id must be of type Long or Integer parameters[\"action_notification_export_id\"]");
        }
        String url = String.format("%s%s/action_notification_export_results", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<ActionNotificationExportResult>> typeReference = new TypeReference<List<ActionNotificationExportResult>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<ActionNotificationExportResult> all() throws RuntimeException {
        return ActionNotificationExportResult.all(null, null);
    }

    public static ListIterator<ActionNotificationExportResult> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ActionNotificationExportResult.list(parameters, options);
    }
}

