/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.File;
import com.files.models.ModelInterface;
import com.files.models.Preview;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Folder
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="created_by_id")
    public Long createdById;
    @JsonProperty(value="created_by_api_key_id")
    public Long createdByApiKeyId;
    @JsonProperty(value="created_by_as2_incoming_message_id")
    public Long createdByAs2IncomingMessageId;
    @JsonProperty(value="created_by_automation_id")
    public Long createdByAutomationId;
    @JsonProperty(value="created_by_bundle_registration_id")
    public Long createdByBundleRegistrationId;
    @JsonProperty(value="created_by_inbox_id")
    public Long createdByInboxId;
    @JsonProperty(value="created_by_remote_server_id")
    public Long createdByRemoteServerId;
    @JsonProperty(value="created_by_remote_server_sync_id")
    public Long createdByRemoteServerSyncId;
    @JsonProperty(value="custom_metadata")
    public Map<String, String> customMetadata;
    @JsonProperty(value="display_name")
    public String displayName;
    @JsonProperty(value="type")
    public String type;
    @JsonProperty(value="size")
    public Long size;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="last_modified_by_id")
    public Long lastModifiedById;
    @JsonProperty(value="last_modified_by_api_key_id")
    public Long lastModifiedByApiKeyId;
    @JsonProperty(value="last_modified_by_automation_id")
    public Long lastModifiedByAutomationId;
    @JsonProperty(value="last_modified_by_bundle_registration_id")
    public Long lastModifiedByBundleRegistrationId;
    @JsonProperty(value="last_modified_by_remote_server_id")
    public Long lastModifiedByRemoteServerId;
    @JsonProperty(value="last_modified_by_remote_server_sync_id")
    public Long lastModifiedByRemoteServerSyncId;
    @JsonProperty(value="mtime")
    public Date mtime;
    @JsonProperty(value="provided_mtime")
    public Date providedMtime;
    @JsonProperty(value="crc32")
    public String crc32;
    @JsonProperty(value="md5")
    public String md5;
    @JsonProperty(value="sha1")
    public String sha1;
    @JsonProperty(value="sha256")
    public String sha256;
    @JsonProperty(value="mime_type")
    public String mimeType;
    @JsonProperty(value="region")
    public String region;
    @JsonProperty(value="permissions")
    public String permissions;
    @JsonProperty(value="subfolders_locked?")
    public Boolean subfoldersLocked;
    @JsonProperty(value="is_locked")
    public Boolean isLocked;
    @JsonProperty(value="download_uri")
    public String downloadUri;
    @JsonProperty(value="priority_color")
    public String priorityColor;
    @JsonProperty(value="preview_id")
    public Long previewId;
    @JsonProperty(value="preview")
    public Preview preview;
    @JsonProperty(value="mkdir_parents")
    public Boolean mkdirParents;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Folder() {
        this(null, null);
    }

    public Folder(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Folder(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getCreatedById() {
        return this.createdById;
    }

    public void setCreatedById(Long createdById) {
        this.createdById = createdById;
    }

    public Long getCreatedByApiKeyId() {
        return this.createdByApiKeyId;
    }

    public void setCreatedByApiKeyId(Long createdByApiKeyId) {
        this.createdByApiKeyId = createdByApiKeyId;
    }

    public Long getCreatedByAs2IncomingMessageId() {
        return this.createdByAs2IncomingMessageId;
    }

    public void setCreatedByAs2IncomingMessageId(Long createdByAs2IncomingMessageId) {
        this.createdByAs2IncomingMessageId = createdByAs2IncomingMessageId;
    }

    public Long getCreatedByAutomationId() {
        return this.createdByAutomationId;
    }

    public void setCreatedByAutomationId(Long createdByAutomationId) {
        this.createdByAutomationId = createdByAutomationId;
    }

    public Long getCreatedByBundleRegistrationId() {
        return this.createdByBundleRegistrationId;
    }

    public void setCreatedByBundleRegistrationId(Long createdByBundleRegistrationId) {
        this.createdByBundleRegistrationId = createdByBundleRegistrationId;
    }

    public Long getCreatedByInboxId() {
        return this.createdByInboxId;
    }

    public void setCreatedByInboxId(Long createdByInboxId) {
        this.createdByInboxId = createdByInboxId;
    }

    public Long getCreatedByRemoteServerId() {
        return this.createdByRemoteServerId;
    }

    public void setCreatedByRemoteServerId(Long createdByRemoteServerId) {
        this.createdByRemoteServerId = createdByRemoteServerId;
    }

    public Long getCreatedByRemoteServerSyncId() {
        return this.createdByRemoteServerSyncId;
    }

    public void setCreatedByRemoteServerSyncId(Long createdByRemoteServerSyncId) {
        this.createdByRemoteServerSyncId = createdByRemoteServerSyncId;
    }

    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public void setCustomMetadata(Map<String, String> customMetadata) {
        this.customMetadata = customMetadata;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Long getLastModifiedById() {
        return this.lastModifiedById;
    }

    public void setLastModifiedById(Long lastModifiedById) {
        this.lastModifiedById = lastModifiedById;
    }

    public Long getLastModifiedByApiKeyId() {
        return this.lastModifiedByApiKeyId;
    }

    public void setLastModifiedByApiKeyId(Long lastModifiedByApiKeyId) {
        this.lastModifiedByApiKeyId = lastModifiedByApiKeyId;
    }

    public Long getLastModifiedByAutomationId() {
        return this.lastModifiedByAutomationId;
    }

    public void setLastModifiedByAutomationId(Long lastModifiedByAutomationId) {
        this.lastModifiedByAutomationId = lastModifiedByAutomationId;
    }

    public Long getLastModifiedByBundleRegistrationId() {
        return this.lastModifiedByBundleRegistrationId;
    }

    public void setLastModifiedByBundleRegistrationId(Long lastModifiedByBundleRegistrationId) {
        this.lastModifiedByBundleRegistrationId = lastModifiedByBundleRegistrationId;
    }

    public Long getLastModifiedByRemoteServerId() {
        return this.lastModifiedByRemoteServerId;
    }

    public void setLastModifiedByRemoteServerId(Long lastModifiedByRemoteServerId) {
        this.lastModifiedByRemoteServerId = lastModifiedByRemoteServerId;
    }

    public Long getLastModifiedByRemoteServerSyncId() {
        return this.lastModifiedByRemoteServerSyncId;
    }

    public void setLastModifiedByRemoteServerSyncId(Long lastModifiedByRemoteServerSyncId) {
        this.lastModifiedByRemoteServerSyncId = lastModifiedByRemoteServerSyncId;
    }

    public Date getMtime() {
        return this.mtime;
    }

    public void setMtime(Date mtime) {
        this.mtime = mtime;
    }

    public Date getProvidedMtime() {
        return this.providedMtime;
    }

    public void setProvidedMtime(Date providedMtime) {
        this.providedMtime = providedMtime;
    }

    public String getCrc32() {
        return this.crc32;
    }

    public void setCrc32(String crc32) {
        this.crc32 = crc32;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public Boolean getSubfoldersLocked() {
        return this.subfoldersLocked;
    }

    public void setSubfoldersLocked(Boolean subfoldersLocked) {
        this.subfoldersLocked = subfoldersLocked;
    }

    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public String getDownloadUri() {
        return this.downloadUri;
    }

    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    public String getPriorityColor() {
        return this.priorityColor;
    }

    public void setPriorityColor(String priorityColor) {
        this.priorityColor = priorityColor;
    }

    public Long getPreviewId() {
        return this.previewId;
    }

    public void setPreviewId(Long previewId) {
        this.previewId = previewId;
    }

    public Preview getPreview() {
        return this.preview;
    }

    public void setPreview(Preview preview) {
        this.preview = preview;
    }

    public Boolean getMkdirParents() {
        return this.mkdirParents;
    }

    public void setMkdirParents(Boolean mkdirParents) {
        this.mkdirParents = mkdirParents;
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Folder.create(parameters, this.options);
    }

    public static ListIterator<File> listFor() throws RuntimeException {
        return Folder.listFor(null, null, null);
    }

    public static ListIterator<File> listFor(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Folder.listFor(path, parameters, null);
    }

    public static ListIterator<File> listFor(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Folder.listFor(null, parameters, options);
    }

    public static ListIterator<File> listFor(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("preview_size") && !(parameters.get("preview_size") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: preview_size must be of type String parameters[\"preview_size\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("search") && !(parameters.get("search") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: search must be of type String parameters[\"search\"]");
        }
        if (parameters.containsKey("search_custom_metadata_key") && !(parameters.get("search_custom_metadata_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: search_custom_metadata_key must be of type String parameters[\"search_custom_metadata_key\"]");
        }
        if (parameters.containsKey("search_all") && !(parameters.get("search_all") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: search_all must be of type Boolean parameters[\"search_all\"]");
        }
        if (parameters.containsKey("with_previews") && !(parameters.get("with_previews") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_previews must be of type Boolean parameters[\"with_previews\"]");
        }
        if (parameters.containsKey("with_priority_color") && !(parameters.get("with_priority_color") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: with_priority_color must be of type Boolean parameters[\"with_priority_color\"]");
        }
        String url = String.format("%s%s/folders/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(path));
        TypeReference<List<File>> typeReference = new TypeReference<List<File>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Folder create() throws RuntimeException {
        return Folder.create(null, null, null);
    }

    public static Folder create(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Folder.create(path, parameters, null);
    }

    public static Folder create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Folder.create(null, parameters, options);
    }

    public static Folder create(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("mkdir_parents") && !(parameters.get("mkdir_parents") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mkdir_parents must be of type Boolean parameters[\"mkdir_parents\"]");
        }
        if (parameters.containsKey("provided_mtime") && !(parameters.get("provided_mtime") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: provided_mtime must be of type String parameters[\"provided_mtime\"]");
        }
        String url = String.format("%s%s/folders/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(path));
        TypeReference<Folder> typeReference = new TypeReference<Folder>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }
}

