/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class As2IncomingMessage
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="as2_partner_id")
    public Long as2PartnerId;
    @JsonProperty(value="as2_station_id")
    public Long as2StationId;
    @JsonProperty(value="uuid")
    public String uuid;
    @JsonProperty(value="content_type")
    public String contentType;
    @JsonProperty(value="http_headers")
    public Map<String, String> httpHeaders;
    @JsonProperty(value="processing_result")
    public String processingResult;
    @JsonProperty(value="processing_result_description")
    public String processingResultDescription;
    @JsonProperty(value="mic")
    public String mic;
    @JsonProperty(value="mic_algo")
    public String micAlgo;
    @JsonProperty(value="as2_to")
    public String as2To;
    @JsonProperty(value="as2_from")
    public String as2From;
    @JsonProperty(value="message_id")
    public String messageId;
    @JsonProperty(value="subject")
    public String subject;
    @JsonProperty(value="date")
    public String date;
    @JsonProperty(value="body_size")
    public String bodySize;
    @JsonProperty(value="attachment_filename")
    public String attachmentFilename;
    @JsonProperty(value="ip")
    public String ip;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="http_response_code")
    public String httpResponseCode;
    @JsonProperty(value="http_response_headers")
    public Map<String, String> httpResponseHeaders;
    @JsonProperty(value="recipient_serial")
    public String recipientSerial;
    @JsonProperty(value="hex_recipient_serial")
    public String hexRecipientSerial;
    @JsonProperty(value="recipient_issuer")
    public String recipientIssuer;
    @JsonProperty(value="message_received")
    public Boolean messageReceived;
    @JsonProperty(value="message_decrypted")
    public Boolean messageDecrypted;
    @JsonProperty(value="message_signature_verified")
    public Boolean messageSignatureVerified;
    @JsonProperty(value="message_processing_success")
    public Boolean messageProcessingSuccess;
    @JsonProperty(value="message_mdn_returned")
    public Boolean messageMdnReturned;
    @JsonProperty(value="encrypted_uri")
    public String encryptedUri;
    @JsonProperty(value="smime_signed_uri")
    public String smimeSignedUri;
    @JsonProperty(value="smime_uri")
    public String smimeUri;
    @JsonProperty(value="raw_uri")
    public String rawUri;
    @JsonProperty(value="mdn_response_uri")
    public String mdnResponseUri;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public As2IncomingMessage() {
        this(null, null);
    }

    public As2IncomingMessage(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public As2IncomingMessage(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getAs2PartnerId() {
        return this.as2PartnerId;
    }

    public Long getAs2StationId() {
        return this.as2StationId;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getProcessingResult() {
        return this.processingResult;
    }

    public String getProcessingResultDescription() {
        return this.processingResultDescription;
    }

    public String getMic() {
        return this.mic;
    }

    public String getMicAlgo() {
        return this.micAlgo;
    }

    public String getAs2To() {
        return this.as2To;
    }

    public String getAs2From() {
        return this.as2From;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getDate() {
        return this.date;
    }

    public String getBodySize() {
        return this.bodySize;
    }

    public String getAttachmentFilename() {
        return this.attachmentFilename;
    }

    public String getIp() {
        return this.ip;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public Map<String, String> getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    public String getRecipientSerial() {
        return this.recipientSerial;
    }

    public String getHexRecipientSerial() {
        return this.hexRecipientSerial;
    }

    public String getRecipientIssuer() {
        return this.recipientIssuer;
    }

    public Boolean getMessageReceived() {
        return this.messageReceived;
    }

    public Boolean getMessageDecrypted() {
        return this.messageDecrypted;
    }

    public Boolean getMessageSignatureVerified() {
        return this.messageSignatureVerified;
    }

    public Boolean getMessageProcessingSuccess() {
        return this.messageProcessingSuccess;
    }

    public Boolean getMessageMdnReturned() {
        return this.messageMdnReturned;
    }

    public String getEncryptedUri() {
        return this.encryptedUri;
    }

    public String getSmimeSignedUri() {
        return this.smimeSignedUri;
    }

    public String getSmimeUri() {
        return this.smimeUri;
    }

    public String getRawUri() {
        return this.rawUri;
    }

    public String getMdnResponseUri() {
        return this.mdnResponseUri;
    }

    public static ListIterator<As2IncomingMessage> list() throws RuntimeException {
        return As2IncomingMessage.list(null, null);
    }

    public static ListIterator<As2IncomingMessage> list(HashMap<String, Object> parameters) throws RuntimeException {
        return As2IncomingMessage.list(parameters, null);
    }

    public static ListIterator<As2IncomingMessage> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        if (parameters.containsKey("as2_partner_id") && !(parameters.get("as2_partner_id") instanceof Long) && !(parameters.get("as2_partner_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: as2_partner_id must be of type Long or Integer parameters[\"as2_partner_id\"]");
        }
        String url = String.format("%s%s/as2_incoming_messages", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<As2IncomingMessage>> typeReference = new TypeReference<List<As2IncomingMessage>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<As2IncomingMessage> all() throws RuntimeException {
        return As2IncomingMessage.all(null, null);
    }

    public static ListIterator<As2IncomingMessage> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return As2IncomingMessage.list(parameters, options);
    }
}

