/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.AccountLineItem;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.UrlUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Payment
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="amount")
    public Double amount;
    @JsonProperty(value="balance")
    public Double balance;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="currency")
    public String currency;
    @JsonProperty(value="download_uri")
    public String downloadUri;
    @JsonProperty(value="invoice_line_items")
    public Object[] invoiceLineItems;
    @JsonProperty(value="method")
    public String method;
    @JsonProperty(value="payment_line_items")
    public Object[] paymentLineItems;
    @JsonProperty(value="payment_reversed_at")
    public Date paymentReversedAt;
    @JsonProperty(value="payment_type")
    public String paymentType;
    @JsonProperty(value="site_name")
    public String siteName;
    @JsonProperty(value="type")
    public String type;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Payment() {
        this(null, null);
    }

    public Payment(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Payment(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public Double getAmount() {
        return this.amount;
    }

    public Double getBalance() {
        return this.balance;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDownloadUri() {
        return this.downloadUri;
    }

    public Object[] getInvoiceLineItems() {
        return this.invoiceLineItems;
    }

    public String getMethod() {
        return this.method;
    }

    public Object[] getPaymentLineItems() {
        return this.paymentLineItems;
    }

    public Date getPaymentReversedAt() {
        return this.paymentReversedAt;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getType() {
        return this.type;
    }

    public static ListIterator<AccountLineItem> list() throws RuntimeException {
        return Payment.list(null, null);
    }

    public static ListIterator<AccountLineItem> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Payment.list(parameters, null);
    }

    public static ListIterator<AccountLineItem> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        String url = String.format("%s%s/payments", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<AccountLineItem>> typeReference = new TypeReference<List<AccountLineItem>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<AccountLineItem> all() throws RuntimeException {
        return Payment.all(null, null);
    }

    public static ListIterator<AccountLineItem> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Payment.list(parameters, options);
    }

    public static AccountLineItem find() throws RuntimeException {
        return Payment.find(null, null, null);
    }

    public static AccountLineItem find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Payment.find(id, parameters, null);
    }

    public static AccountLineItem find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Payment.find(null, parameters, options);
    }

    public static AccountLineItem find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/payments/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<AccountLineItem> typeReference = new TypeReference<AccountLineItem>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static AccountLineItem get() throws RuntimeException {
        return Payment.get(null, null, null);
    }

    public static AccountLineItem get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Payment.find(id, parameters, options);
    }
}

