/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BundleRecipient
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="company")
    public String company;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="note")
    public String note;
    @JsonProperty(value="recipient")
    public String recipient;
    @JsonProperty(value="sent_at")
    public Date sentAt;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="bundle_id")
    public Long bundleId;
    @JsonProperty(value="share_after_create")
    public Boolean shareAfterCreate;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public BundleRecipient() {
        this(null, null);
    }

    public BundleRecipient(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public BundleRecipient(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public Date getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(Date sentAt) {
        this.sentAt = sentAt;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(Long bundleId) {
        this.bundleId = bundleId;
    }

    public Boolean getShareAfterCreate() {
        return this.shareAfterCreate;
    }

    public void setShareAfterCreate(Boolean shareAfterCreate) {
        this.shareAfterCreate = shareAfterCreate;
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        BundleRecipient.create(parameters, this.options);
    }

    public static ListIterator<BundleRecipient> list() throws RuntimeException {
        return BundleRecipient.list(null, null);
    }

    public static ListIterator<BundleRecipient> list(HashMap<String, Object> parameters) throws RuntimeException {
        return BundleRecipient.list(parameters, null);
    }

    public static ListIterator<BundleRecipient> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("bundle_id") || parameters.get("bundle_id") == null) {
            throw new NullPointerException("Parameter missing: bundle_id parameters[\"bundle_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("bundle_id") && !(parameters.get("bundle_id") instanceof Long) && !(parameters.get("bundle_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: bundle_id must be of type Long or Integer parameters[\"bundle_id\"]");
        }
        String url = String.format("%s%s/bundle_recipients", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<BundleRecipient>> typeReference = new TypeReference<List<BundleRecipient>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<BundleRecipient> all() throws RuntimeException {
        return BundleRecipient.all(null, null);
    }

    public static ListIterator<BundleRecipient> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return BundleRecipient.list(parameters, options);
    }

    public static BundleRecipient create() throws RuntimeException {
        return BundleRecipient.create(null, null);
    }

    public static BundleRecipient create(HashMap<String, Object> parameters) throws RuntimeException {
        return BundleRecipient.create(parameters, null);
    }

    public static BundleRecipient create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("bundle_id") || parameters.get("bundle_id") == null) {
            throw new NullPointerException("Parameter missing: bundle_id parameters[\"bundle_id\"]");
        }
        if (!parameters.containsKey("recipient") || parameters.get("recipient") == null) {
            throw new NullPointerException("Parameter missing: recipient parameters[\"recipient\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("bundle_id") && !(parameters.get("bundle_id") instanceof Long) && !(parameters.get("bundle_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: bundle_id must be of type Long or Integer parameters[\"bundle_id\"]");
        }
        if (parameters.containsKey("recipient") && !(parameters.get("recipient") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: recipient must be of type String parameters[\"recipient\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("company") && !(parameters.get("company") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: company must be of type String parameters[\"company\"]");
        }
        if (parameters.containsKey("note") && !(parameters.get("note") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: note must be of type String parameters[\"note\"]");
        }
        if (parameters.containsKey("share_after_create") && !(parameters.get("share_after_create") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: share_after_create must be of type Boolean parameters[\"share_after_create\"]");
        }
        String url = String.format("%s%s/bundle_recipients", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<BundleRecipient> typeReference = new TypeReference<BundleRecipient>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }
}

