/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FtpActionLog
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="timestamp")
    public Date timestamp;
    @JsonProperty(value="remote_ip")
    public String remoteIp;
    @JsonProperty(value="server_ip")
    public String serverIp;
    @JsonProperty(value="username")
    public String username;
    @JsonProperty(value="session_uuid")
    public String sessionUuid;
    @JsonProperty(value="seq_id")
    public Long seqId;
    @JsonProperty(value="auth_ciphers")
    public String authCiphers;
    @JsonProperty(value="action_type")
    public String actionType;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="true_path")
    public String truePath;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="cmd")
    public String cmd;
    @JsonProperty(value="param")
    public String param;
    @JsonProperty(value="responseCode")
    public Long responseCode;
    @JsonProperty(value="responseMessage")
    public String responseMessage;
    @JsonProperty(value="entries_returned")
    public Long entriesReturned;
    @JsonProperty(value="success")
    public Boolean success;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="duration_ms")
    public Long durationMs;
    @JsonProperty(value="created_at")
    public Date createdAt;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public FtpActionLog() {
        this(null, null);
    }

    public FtpActionLog(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public FtpActionLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public String getUsername() {
        return this.username;
    }

    public String getSessionUuid() {
        return this.sessionUuid;
    }

    public Long getSeqId() {
        return this.seqId;
    }

    public String getAuthCiphers() {
        return this.authCiphers;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getPath() {
        return this.path;
    }

    public String getTruePath() {
        return this.truePath;
    }

    public String getName() {
        return this.name;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getParam() {
        return this.param;
    }

    public Long getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public Long getEntriesReturned() {
        return this.entriesReturned;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getDurationMs() {
        return this.durationMs;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public static ListIterator<FtpActionLog> list() throws RuntimeException {
        return FtpActionLog.list(null, null);
    }

    public static ListIterator<FtpActionLog> list(HashMap<String, Object> parameters) throws RuntimeException {
        return FtpActionLog.list(parameters, null);
    }

    public static ListIterator<FtpActionLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        String url = String.format("%s%s/ftp_action_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<FtpActionLog>> typeReference = new TypeReference<List<FtpActionLog>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<FtpActionLog> all() throws RuntimeException {
        return FtpActionLog.all(null, null);
    }

    public static ListIterator<FtpActionLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return FtpActionLog.list(parameters, options);
    }
}

