/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HistoryExport
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="history_version")
    public String historyVersion;
    @JsonProperty(value="start_at")
    public Date startAt;
    @JsonProperty(value="end_at")
    public Date endAt;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="query_action")
    public String queryAction;
    @JsonProperty(value="query_interface")
    public String queryInterface;
    @JsonProperty(value="query_user_id")
    public String queryUserId;
    @JsonProperty(value="query_file_id")
    public String queryFileId;
    @JsonProperty(value="query_parent_id")
    public String queryParentId;
    @JsonProperty(value="query_path")
    public String queryPath;
    @JsonProperty(value="query_folder")
    public String queryFolder;
    @JsonProperty(value="query_src")
    public String querySrc;
    @JsonProperty(value="query_destination")
    public String queryDestination;
    @JsonProperty(value="query_ip")
    public String queryIp;
    @JsonProperty(value="query_username")
    public String queryUsername;
    @JsonProperty(value="query_failure_type")
    public String queryFailureType;
    @JsonProperty(value="query_target_id")
    public String queryTargetId;
    @JsonProperty(value="query_target_name")
    public String queryTargetName;
    @JsonProperty(value="query_target_permission")
    public String queryTargetPermission;
    @JsonProperty(value="query_target_user_id")
    public String queryTargetUserId;
    @JsonProperty(value="query_target_username")
    public String queryTargetUsername;
    @JsonProperty(value="query_target_platform")
    public String queryTargetPlatform;
    @JsonProperty(value="query_target_permission_set")
    public String queryTargetPermissionSet;
    @JsonProperty(value="results_url")
    public String resultsUrl;
    @JsonProperty(value="user_id")
    public Long userId;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public HistoryExport() {
        this(null, null);
    }

    public HistoryExport(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public HistoryExport(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getHistoryVersion() {
        return this.historyVersion;
    }

    public void setHistoryVersion(String historyVersion) {
        this.historyVersion = historyVersion;
    }

    public Date getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    public Date getEndAt() {
        return this.endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getQueryAction() {
        return this.queryAction;
    }

    public void setQueryAction(String queryAction) {
        this.queryAction = queryAction;
    }

    public String getQueryInterface() {
        return this.queryInterface;
    }

    public void setQueryInterface(String queryInterface) {
        this.queryInterface = queryInterface;
    }

    public String getQueryUserId() {
        return this.queryUserId;
    }

    public void setQueryUserId(String queryUserId) {
        this.queryUserId = queryUserId;
    }

    public String getQueryFileId() {
        return this.queryFileId;
    }

    public void setQueryFileId(String queryFileId) {
        this.queryFileId = queryFileId;
    }

    public String getQueryParentId() {
        return this.queryParentId;
    }

    public void setQueryParentId(String queryParentId) {
        this.queryParentId = queryParentId;
    }

    public String getQueryPath() {
        return this.queryPath;
    }

    public void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    public String getQueryFolder() {
        return this.queryFolder;
    }

    public void setQueryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
    }

    public String getQuerySrc() {
        return this.querySrc;
    }

    public void setQuerySrc(String querySrc) {
        this.querySrc = querySrc;
    }

    public String getQueryDestination() {
        return this.queryDestination;
    }

    public void setQueryDestination(String queryDestination) {
        this.queryDestination = queryDestination;
    }

    public String getQueryIp() {
        return this.queryIp;
    }

    public void setQueryIp(String queryIp) {
        this.queryIp = queryIp;
    }

    public String getQueryUsername() {
        return this.queryUsername;
    }

    public void setQueryUsername(String queryUsername) {
        this.queryUsername = queryUsername;
    }

    public String getQueryFailureType() {
        return this.queryFailureType;
    }

    public void setQueryFailureType(String queryFailureType) {
        this.queryFailureType = queryFailureType;
    }

    public String getQueryTargetId() {
        return this.queryTargetId;
    }

    public void setQueryTargetId(String queryTargetId) {
        this.queryTargetId = queryTargetId;
    }

    public String getQueryTargetName() {
        return this.queryTargetName;
    }

    public void setQueryTargetName(String queryTargetName) {
        this.queryTargetName = queryTargetName;
    }

    public String getQueryTargetPermission() {
        return this.queryTargetPermission;
    }

    public void setQueryTargetPermission(String queryTargetPermission) {
        this.queryTargetPermission = queryTargetPermission;
    }

    public String getQueryTargetUserId() {
        return this.queryTargetUserId;
    }

    public void setQueryTargetUserId(String queryTargetUserId) {
        this.queryTargetUserId = queryTargetUserId;
    }

    public String getQueryTargetUsername() {
        return this.queryTargetUsername;
    }

    public void setQueryTargetUsername(String queryTargetUsername) {
        this.queryTargetUsername = queryTargetUsername;
    }

    public String getQueryTargetPlatform() {
        return this.queryTargetPlatform;
    }

    public void setQueryTargetPlatform(String queryTargetPlatform) {
        this.queryTargetPlatform = queryTargetPlatform;
    }

    public String getQueryTargetPermissionSet() {
        return this.queryTargetPermissionSet;
    }

    public void setQueryTargetPermissionSet(String queryTargetPermissionSet) {
        this.queryTargetPermissionSet = queryTargetPermissionSet;
    }

    public String getResultsUrl() {
        return this.resultsUrl;
    }

    public void setResultsUrl(String resultsUrl) {
        this.resultsUrl = resultsUrl;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        HistoryExport.create(parameters, this.options);
    }

    public static HistoryExport find() throws RuntimeException {
        return HistoryExport.find(null, null, null);
    }

    public static HistoryExport find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return HistoryExport.find(id, parameters, null);
    }

    public static HistoryExport find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return HistoryExport.find(null, parameters, options);
    }

    public static HistoryExport find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/history_exports/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<HistoryExport> typeReference = new TypeReference<HistoryExport>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static HistoryExport get() throws RuntimeException {
        return HistoryExport.get(null, null, null);
    }

    public static HistoryExport get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return HistoryExport.find(id, parameters, options);
    }

    public static HistoryExport create() throws RuntimeException {
        return HistoryExport.create(null, null);
    }

    public static HistoryExport create(HashMap<String, Object> parameters) throws RuntimeException {
        return HistoryExport.create(parameters, null);
    }

    public static HistoryExport create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("query_action") && !(parameters.get("query_action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_action must be of type String parameters[\"query_action\"]");
        }
        if (parameters.containsKey("query_interface") && !(parameters.get("query_interface") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_interface must be of type String parameters[\"query_interface\"]");
        }
        if (parameters.containsKey("query_user_id") && !(parameters.get("query_user_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_user_id must be of type String parameters[\"query_user_id\"]");
        }
        if (parameters.containsKey("query_file_id") && !(parameters.get("query_file_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_file_id must be of type String parameters[\"query_file_id\"]");
        }
        if (parameters.containsKey("query_parent_id") && !(parameters.get("query_parent_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_parent_id must be of type String parameters[\"query_parent_id\"]");
        }
        if (parameters.containsKey("query_path") && !(parameters.get("query_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_path must be of type String parameters[\"query_path\"]");
        }
        if (parameters.containsKey("query_folder") && !(parameters.get("query_folder") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_folder must be of type String parameters[\"query_folder\"]");
        }
        if (parameters.containsKey("query_src") && !(parameters.get("query_src") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_src must be of type String parameters[\"query_src\"]");
        }
        if (parameters.containsKey("query_destination") && !(parameters.get("query_destination") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_destination must be of type String parameters[\"query_destination\"]");
        }
        if (parameters.containsKey("query_ip") && !(parameters.get("query_ip") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_ip must be of type String parameters[\"query_ip\"]");
        }
        if (parameters.containsKey("query_username") && !(parameters.get("query_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_username must be of type String parameters[\"query_username\"]");
        }
        if (parameters.containsKey("query_failure_type") && !(parameters.get("query_failure_type") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_failure_type must be of type String parameters[\"query_failure_type\"]");
        }
        if (parameters.containsKey("query_target_id") && !(parameters.get("query_target_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_target_id must be of type String parameters[\"query_target_id\"]");
        }
        if (parameters.containsKey("query_target_name") && !(parameters.get("query_target_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_target_name must be of type String parameters[\"query_target_name\"]");
        }
        if (parameters.containsKey("query_target_permission") && !(parameters.get("query_target_permission") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_target_permission must be of type String parameters[\"query_target_permission\"]");
        }
        if (parameters.containsKey("query_target_user_id") && !(parameters.get("query_target_user_id") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_target_user_id must be of type String parameters[\"query_target_user_id\"]");
        }
        if (parameters.containsKey("query_target_username") && !(parameters.get("query_target_username") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_target_username must be of type String parameters[\"query_target_username\"]");
        }
        if (parameters.containsKey("query_target_platform") && !(parameters.get("query_target_platform") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_target_platform must be of type String parameters[\"query_target_platform\"]");
        }
        if (parameters.containsKey("query_target_permission_set") && !(parameters.get("query_target_permission_set") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_target_permission_set must be of type String parameters[\"query_target_permission_set\"]");
        }
        String url = String.format("%s%s/history_exports", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<HistoryExport> typeReference = new TypeReference<HistoryExport>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }
}

