/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InboxRegistration
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="code")
    public String code;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="company")
    public String company;
    @JsonProperty(value="email")
    public String email;
    @JsonProperty(value="ip")
    public String ip;
    @JsonProperty(value="clickwrap_body")
    public String clickwrapBody;
    @JsonProperty(value="form_field_set_id")
    public Long formFieldSetId;
    @JsonProperty(value="form_field_data")
    public Map<String, String> formFieldData;
    @JsonProperty(value="inbox_id")
    public Long inboxId;
    @JsonProperty(value="inbox_recipient_id")
    public Long inboxRecipientId;
    @JsonProperty(value="inbox_title")
    public String inboxTitle;
    @JsonProperty(value="created_at")
    public Date createdAt;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public InboxRegistration() {
        this(null, null);
    }

    public InboxRegistration(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public InboxRegistration(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getCompany() {
        return this.company;
    }

    public String getEmail() {
        return this.email;
    }

    public String getIp() {
        return this.ip;
    }

    public String getClickwrapBody() {
        return this.clickwrapBody;
    }

    public Long getFormFieldSetId() {
        return this.formFieldSetId;
    }

    public Map<String, String> getFormFieldData() {
        return this.formFieldData;
    }

    public Long getInboxId() {
        return this.inboxId;
    }

    public Long getInboxRecipientId() {
        return this.inboxRecipientId;
    }

    public String getInboxTitle() {
        return this.inboxTitle;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public static ListIterator<InboxRegistration> list() throws RuntimeException {
        return InboxRegistration.list(null, null);
    }

    public static ListIterator<InboxRegistration> list(HashMap<String, Object> parameters) throws RuntimeException {
        return InboxRegistration.list(parameters, null);
    }

    public static ListIterator<InboxRegistration> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("folder_behavior_id") && !(parameters.get("folder_behavior_id") instanceof Long) && !(parameters.get("folder_behavior_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: folder_behavior_id must be of type Long or Integer parameters[\"folder_behavior_id\"]");
        }
        String url = String.format("%s%s/inbox_registrations", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<InboxRegistration>> typeReference = new TypeReference<List<InboxRegistration>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<InboxRegistration> all() throws RuntimeException {
        return InboxRegistration.all(null, null);
    }

    public static ListIterator<InboxRegistration> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return InboxRegistration.list(parameters, options);
    }
}

