/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExavaultApiRequestLog
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="timestamp")
    public Date timestamp;
    @JsonProperty(value="endpoint")
    public String endpoint;
    @JsonProperty(value="version")
    public Long version;
    @JsonProperty(value="request_ip")
    public String requestIp;
    @JsonProperty(value="request_method")
    public String requestMethod;
    @JsonProperty(value="error_type")
    public String errorType;
    @JsonProperty(value="error_message")
    public String errorMessage;
    @JsonProperty(value="user_agent")
    public String userAgent;
    @JsonProperty(value="response_code")
    public Long responseCode;
    @JsonProperty(value="success")
    public Boolean success;
    @JsonProperty(value="duration_ms")
    public Long durationMs;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public ExavaultApiRequestLog() {
        this(null, null);
    }

    public ExavaultApiRequestLog(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public ExavaultApiRequestLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getRequestIp() {
        return this.requestIp;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Long getResponseCode() {
        return this.responseCode;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Long getDurationMs() {
        return this.durationMs;
    }

    public static ListIterator<ExavaultApiRequestLog> list() throws RuntimeException {
        return ExavaultApiRequestLog.list(null, null);
    }

    public static ListIterator<ExavaultApiRequestLog> list(HashMap<String, Object> parameters) throws RuntimeException {
        return ExavaultApiRequestLog.list(parameters, null);
    }

    public static ListIterator<ExavaultApiRequestLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/exavault_api_request_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<ExavaultApiRequestLog>> typeReference = new TypeReference<List<ExavaultApiRequestLog>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<ExavaultApiRequestLog> all() throws RuntimeException {
        return ExavaultApiRequestLog.all(null, null);
    }

    public static ListIterator<ExavaultApiRequestLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ExavaultApiRequestLog.list(parameters, options);
    }
}

