/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.UrlUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncRun
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="sync_id")
    public Long syncId;
    @JsonProperty(value="site_id")
    public Long siteId;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="src_remote_server_type")
    public String srcRemoteServerType;
    @JsonProperty(value="dest_remote_server_type")
    public String destRemoteServerType;
    @JsonProperty(value="body")
    public String body;
    @JsonProperty(value="event_errors")
    public String[] eventErrors;
    @JsonProperty(value="compared_files")
    public Long comparedFiles;
    @JsonProperty(value="compared_folders")
    public Long comparedFolders;
    @JsonProperty(value="errored_files")
    public Long erroredFiles;
    @JsonProperty(value="successful_files")
    public Long successfulFiles;
    @JsonProperty(value="runtime")
    public Double runtime;
    @JsonProperty(value="log_url")
    public String logUrl;
    @JsonProperty(value="completed_at")
    public Date completedAt;
    @JsonProperty(value="notified")
    public Boolean notified;
    @JsonProperty(value="dry_run")
    public Boolean dryRun;
    @JsonProperty(value="bytes_synced")
    public Long bytesSynced;
    @JsonProperty(value="estimated_bytes_count")
    public Long estimatedBytesCount;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="updated_at")
    public Date updatedAt;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public SyncRun() {
        this(null, null);
    }

    public SyncRun(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public SyncRun(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getSyncId() {
        return this.syncId;
    }

    public Long getSiteId() {
        return this.siteId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSrcRemoteServerType() {
        return this.srcRemoteServerType;
    }

    public String getDestRemoteServerType() {
        return this.destRemoteServerType;
    }

    public String getBody() {
        return this.body;
    }

    public String[] getEventErrors() {
        return this.eventErrors;
    }

    public Long getComparedFiles() {
        return this.comparedFiles;
    }

    public Long getComparedFolders() {
        return this.comparedFolders;
    }

    public Long getErroredFiles() {
        return this.erroredFiles;
    }

    public Long getSuccessfulFiles() {
        return this.successfulFiles;
    }

    public Double getRuntime() {
        return this.runtime;
    }

    public String getLogUrl() {
        return this.logUrl;
    }

    public Date getCompletedAt() {
        return this.completedAt;
    }

    public Boolean getNotified() {
        return this.notified;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public Long getBytesSynced() {
        return this.bytesSynced;
    }

    public Long getEstimatedBytesCount() {
        return this.estimatedBytesCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public static ListIterator<SyncRun> list() throws RuntimeException {
        return SyncRun.list(null, null);
    }

    public static ListIterator<SyncRun> list(HashMap<String, Object> parameters) throws RuntimeException {
        return SyncRun.list(parameters, null);
    }

    public static ListIterator<SyncRun> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        String url = String.format("%s%s/sync_runs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<SyncRun>> typeReference = new TypeReference<List<SyncRun>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<SyncRun> all() throws RuntimeException {
        return SyncRun.all(null, null);
    }

    public static ListIterator<SyncRun> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SyncRun.list(parameters, options);
    }

    public static SyncRun find() throws RuntimeException {
        return SyncRun.find(null, null, null);
    }

    public static SyncRun find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return SyncRun.find(id, parameters, null);
    }

    public static SyncRun find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SyncRun.find(null, parameters, options);
    }

    public static SyncRun find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/sync_runs/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<SyncRun> typeReference = new TypeReference<SyncRun>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static SyncRun get() throws RuntimeException {
        return SyncRun.get(null, null, null);
    }

    public static SyncRun get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return SyncRun.find(id, parameters, options);
    }
}

