/*
 * Decompiled with CFR 0.152.
 */
package com.files.net;

import com.files.util.FilesInputStream;
import com.files.util.StreamTransfer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpResponse;

public class FilesApacheHttpInputStream
extends FilesInputStream
implements Closeable {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final HttpResponse response;
    private InputStream upstreamInputStream;

    public FilesApacheHttpInputStream(HttpResponse response) {
        this.response = response;
    }

    @Override
    public int read() throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        return this.upstreamInputStream.available();
    }

    @Override
    public void close() throws IOException {
        if (this.upstreamInputStream != null) {
            this.upstreamInputStream.close();
        }
        if (this.response.getEntity() != null) {
            this.response.getEntity().getContent().close();
        }
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (this.upstreamInputStream == null) {
            try {
                this.loadInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load input stream", e);
            }
        }
        this.upstreamInputStream.mark(readLimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        this.upstreamInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        if (this.upstreamInputStream == null) {
            try {
                this.loadInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load input stream", e);
            }
        }
        return this.upstreamInputStream.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        if (this.upstreamInputStream == null) {
            this.loadInputStream();
        }
        long transferred = StreamTransfer.smartCopy(this.response.getEntity().getContentLength(), this, out);
        this.close();
        return transferred;
    }

    private void loadInputStream() throws IOException {
        this.upstreamInputStream = this.response.getEntity().getContent();
    }
}

