/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OutboundConnectionLog
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="timestamp")
    public Date timestamp;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="client_ip")
    public String clientIp;
    @JsonProperty(value="src_remote_server_id")
    public Long srcRemoteServerId;
    @JsonProperty(value="dest_remote_server_id")
    public Long destRemoteServerId;
    @JsonProperty(value="operation")
    public String operation;
    @JsonProperty(value="error_message")
    public String errorMessage;
    @JsonProperty(value="error_operation")
    public String errorOperation;
    @JsonProperty(value="error_type")
    public String errorType;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="duration_ms")
    public Long durationMs;
    @JsonProperty(value="bytes_uploaded")
    public Long bytesUploaded;
    @JsonProperty(value="bytes_downloaded")
    public Long bytesDownloaded;
    @JsonProperty(value="list_count")
    public Long listCount;
    @JsonProperty(value="created_at")
    public Date createdAt;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public OutboundConnectionLog() {
        this(null, null);
    }

    public OutboundConnectionLog(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public OutboundConnectionLog(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getPath() {
        return this.path;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public Long getSrcRemoteServerId() {
        return this.srcRemoteServerId;
    }

    public Long getDestRemoteServerId() {
        return this.destRemoteServerId;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorOperation() {
        return this.errorOperation;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getDurationMs() {
        return this.durationMs;
    }

    public Long getBytesUploaded() {
        return this.bytesUploaded;
    }

    public Long getBytesDownloaded() {
        return this.bytesDownloaded;
    }

    public Long getListCount() {
        return this.listCount;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public static ListIterator<OutboundConnectionLog> list() throws RuntimeException {
        return OutboundConnectionLog.list(null, null);
    }

    public static ListIterator<OutboundConnectionLog> list(HashMap<String, Object> parameters) throws RuntimeException {
        return OutboundConnectionLog.list(parameters, null);
    }

    public static ListIterator<OutboundConnectionLog> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        String url = String.format("%s%s/outbound_connection_logs", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<OutboundConnectionLog>> typeReference = new TypeReference<List<OutboundConnectionLog>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<OutboundConnectionLog> all() throws RuntimeException {
        return OutboundConnectionLog.all(null, null);
    }

    public static ListIterator<OutboundConnectionLog> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return OutboundConnectionLog.list(parameters, options);
    }
}

