/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageComment
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="body")
    public String body;
    @JsonProperty(value="reactions")
    public Object[] reactions;
    @JsonProperty(value="user_id")
    public Long userId;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public MessageComment() {
        this(null, null);
    }

    public MessageComment(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public MessageComment(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Object[] getReactions() {
        return this.reactions;
    }

    public void setReactions(Object[] reactions) {
        this.reactions = reactions;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public MessageComment update(HashMap<String, Object> parameters) throws IOException {
        return MessageComment.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        MessageComment.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        MessageComment.create(parameters, this.options);
    }

    public static ListIterator<MessageComment> list() throws RuntimeException {
        return MessageComment.list(null, null);
    }

    public static ListIterator<MessageComment> list(HashMap<String, Object> parameters) throws RuntimeException {
        return MessageComment.list(parameters, null);
    }

    public static ListIterator<MessageComment> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("message_id") || parameters.get("message_id") == null) {
            throw new NullPointerException("Parameter missing: message_id parameters[\"message_id\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("message_id") && !(parameters.get("message_id") instanceof Long) && !(parameters.get("message_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: message_id must be of type Long or Integer parameters[\"message_id\"]");
        }
        String url = String.format("%s%s/message_comments", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<MessageComment>> typeReference = new TypeReference<List<MessageComment>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<MessageComment> all() throws RuntimeException {
        return MessageComment.all(null, null);
    }

    public static ListIterator<MessageComment> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return MessageComment.list(parameters, options);
    }

    public static MessageComment find() throws RuntimeException {
        return MessageComment.find(null, null, null);
    }

    public static MessageComment find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return MessageComment.find(id, parameters, null);
    }

    public static MessageComment find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return MessageComment.find(null, parameters, options);
    }

    public static MessageComment find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/message_comments/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<MessageComment> typeReference = new TypeReference<MessageComment>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static MessageComment get() throws RuntimeException {
        return MessageComment.get(null, null, null);
    }

    public static MessageComment get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return MessageComment.find(id, parameters, options);
    }

    public static MessageComment create() throws RuntimeException {
        return MessageComment.create(null, null);
    }

    public static MessageComment create(HashMap<String, Object> parameters) throws RuntimeException {
        return MessageComment.create(parameters, null);
    }

    public static MessageComment create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("body") || parameters.get("body") == null) {
            throw new NullPointerException("Parameter missing: body parameters[\"body\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("body") && !(parameters.get("body") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: body must be of type String parameters[\"body\"]");
        }
        String url = String.format("%s%s/message_comments", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<MessageComment> typeReference = new TypeReference<MessageComment>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static MessageComment update() throws RuntimeException {
        return MessageComment.update(null, null, null);
    }

    public static MessageComment update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return MessageComment.update(id, parameters, null);
    }

    public static MessageComment update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return MessageComment.update(null, parameters, options);
    }

    public static MessageComment update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!parameters.containsKey("body") || parameters.get("body") == null) {
            throw new NullPointerException("Parameter missing: body parameters[\"body\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("body") && !(parameters.get("body") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: body must be of type String parameters[\"body\"]");
        }
        String url = String.format("%s%s/message_comments/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<MessageComment> typeReference = new TypeReference<MessageComment>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        MessageComment.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        MessageComment.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        MessageComment.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/message_comments/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        MessageComment.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        MessageComment.delete(id, parameters, options);
    }
}

