/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Behavior
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="attachment_url")
    public String attachmentUrl;
    @JsonProperty(value="behavior")
    public String behavior;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="description")
    public String description;
    @JsonProperty(value="value")
    public Map<String, String> value;
    @JsonProperty(value="disable_parent_folder_behavior")
    public Boolean disableParentFolderBehavior;
    @JsonProperty(value="recursive")
    public Boolean recursive;
    @JsonProperty(value="attachment_file")
    public byte[] attachmentFile;
    @JsonProperty(value="attachment_delete")
    public Boolean attachmentDelete;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Behavior() {
        this(null, null);
    }

    public Behavior(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Behavior(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAttachmentUrl() {
        return this.attachmentUrl;
    }

    public void setAttachmentUrl(String attachmentUrl) {
        this.attachmentUrl = attachmentUrl;
    }

    public String getBehavior() {
        return this.behavior;
    }

    public void setBehavior(String behavior) {
        this.behavior = behavior;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getValue() {
        return this.value;
    }

    public void setValue(Map<String, String> value) {
        this.value = value;
    }

    public Boolean getDisableParentFolderBehavior() {
        return this.disableParentFolderBehavior;
    }

    public void setDisableParentFolderBehavior(Boolean disableParentFolderBehavior) {
        this.disableParentFolderBehavior = disableParentFolderBehavior;
    }

    public Boolean getRecursive() {
        return this.recursive;
    }

    public void setRecursive(Boolean recursive) {
        this.recursive = recursive;
    }

    public byte[] getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(byte[] attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    public Boolean getAttachmentDelete() {
        return this.attachmentDelete;
    }

    public void setAttachmentDelete(Boolean attachmentDelete) {
        this.attachmentDelete = attachmentDelete;
    }

    public Behavior update(HashMap<String, Object> parameters) throws IOException {
        return Behavior.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        Behavior.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Behavior.create(parameters, this.options);
    }

    public static ListIterator<Behavior> list() throws RuntimeException {
        return Behavior.list(null, null);
    }

    public static ListIterator<Behavior> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Behavior.list(parameters, null);
    }

    public static ListIterator<Behavior> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        String url = String.format("%s%s/behaviors", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Behavior>> typeReference = new TypeReference<List<Behavior>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Behavior> all() throws RuntimeException {
        return Behavior.all(null, null);
    }

    public static ListIterator<Behavior> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Behavior.list(parameters, options);
    }

    public static Behavior find() throws RuntimeException {
        return Behavior.find(null, null, null);
    }

    public static Behavior find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Behavior.find(id, parameters, null);
    }

    public static Behavior find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Behavior.find(null, parameters, options);
    }

    public static Behavior find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/behaviors/%s", urlParts);
        TypeReference<Behavior> typeReference = new TypeReference<Behavior>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Behavior get() throws RuntimeException {
        return Behavior.get(null, null, null);
    }

    public static Behavior get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Behavior.find(id, parameters, options);
    }

    public static ListIterator<Behavior> listFor() throws RuntimeException {
        return Behavior.listFor(null, null, null);
    }

    public static ListIterator<Behavior> listFor(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Behavior.listFor(path, parameters, null);
    }

    public static ListIterator<Behavior> listFor(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Behavior.listFor(null, parameters, options);
    }

    public static ListIterator<Behavior> listFor(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("ancestor_behaviors") && !(parameters.get("ancestor_behaviors") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: ancestor_behaviors must be of type Boolean parameters[\"ancestor_behaviors\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/behaviors/folders/%s", urlParts);
        TypeReference<List<Behavior>> typeReference = new TypeReference<List<Behavior>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Behavior create() throws RuntimeException {
        return Behavior.create(null, null);
    }

    public static Behavior create(HashMap<String, Object> parameters) throws RuntimeException {
        return Behavior.create(parameters, null);
    }

    public static Behavior create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("path") || parameters.get("path") == null) {
            throw new NullPointerException("Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("behavior") || parameters.get("behavior") == null) {
            throw new NullPointerException("Parameter missing: behavior parameters[\"behavior\"]");
        }
        if (parameters.containsKey("value") && !(parameters.get("value") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: value must be of type String parameters[\"value\"]");
        }
        if (parameters.containsKey("attachment_file") && !(parameters.get("attachment_file") instanceof byte[])) {
            throw new IllegalArgumentException("Bad parameter: attachment_file must be of type byte[] parameters[\"attachment_file\"]");
        }
        if (parameters.containsKey("disable_parent_folder_behavior") && !(parameters.get("disable_parent_folder_behavior") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disable_parent_folder_behavior must be of type Boolean parameters[\"disable_parent_folder_behavior\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("behavior") && !(parameters.get("behavior") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: behavior must be of type String parameters[\"behavior\"]");
        }
        String url = String.format("%s%s/behaviors", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Behavior> typeReference = new TypeReference<Behavior>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void webhookTest() throws RuntimeException {
        Behavior.webhookTest(null, null);
    }

    public static void webhookTest(HashMap<String, Object> parameters) throws RuntimeException {
        Behavior.webhookTest(parameters, null);
    }

    public static void webhookTest(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("url") || parameters.get("url") == null) {
            throw new NullPointerException("Parameter missing: url parameters[\"url\"]");
        }
        if (parameters.containsKey("url") && !(parameters.get("url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: url must be of type String parameters[\"url\"]");
        }
        if (parameters.containsKey("method") && !(parameters.get("method") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: method must be of type String parameters[\"method\"]");
        }
        if (parameters.containsKey("encoding") && !(parameters.get("encoding") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: encoding must be of type String parameters[\"encoding\"]");
        }
        if (parameters.containsKey("headers") && !(parameters.get("headers") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: headers must be of type Map<String, String> parameters[\"headers\"]");
        }
        if (parameters.containsKey("body") && !(parameters.get("body") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: body must be of type Map<String, String> parameters[\"body\"]");
        }
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        String url = String.format("%s%s/behaviors/webhook/test", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.POST, parameters, options);
    }

    public static Behavior update() throws RuntimeException {
        return Behavior.update(null, null, null);
    }

    public static Behavior update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Behavior.update(id, parameters, null);
    }

    public static Behavior update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Behavior.update(null, parameters, options);
    }

    public static Behavior update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("value") && !(parameters.get("value") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: value must be of type String parameters[\"value\"]");
        }
        if (parameters.containsKey("attachment_file") && !(parameters.get("attachment_file") instanceof byte[])) {
            throw new IllegalArgumentException("Bad parameter: attachment_file must be of type byte[] parameters[\"attachment_file\"]");
        }
        if (parameters.containsKey("disable_parent_folder_behavior") && !(parameters.get("disable_parent_folder_behavior") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: disable_parent_folder_behavior must be of type Boolean parameters[\"disable_parent_folder_behavior\"]");
        }
        if (parameters.containsKey("recursive") && !(parameters.get("recursive") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: recursive must be of type Boolean parameters[\"recursive\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("description") && !(parameters.get("description") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: description must be of type String parameters[\"description\"]");
        }
        if (parameters.containsKey("attachment_delete") && !(parameters.get("attachment_delete") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: attachment_delete must be of type Boolean parameters[\"attachment_delete\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/behaviors/%s", urlParts);
        TypeReference<Behavior> typeReference = new TypeReference<Behavior>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        Behavior.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Behavior.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Behavior.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/behaviors/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Behavior.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Behavior.delete(id, parameters, options);
    }
}

